/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;

public class Element
implements dObject {
    public static final Element TRUE = new Element(Boolean.TRUE);
    public static final Element FALSE = new Element(Boolean.FALSE);
    static final Pattern VALUE_PATTERN = Pattern.compile("el@val(?:ue)?\\[([^\\[\\]]+)\\].*", 2);
    private final String element;
    private String prefix;

    @ObjectFetcher(value="el")
    public static Element valueOf(String string) {
        if (string == null) {
            return null;
        }
        Matcher m = VALUE_PATTERN.matcher(string);
        if (m.matches()) {
            String value = m.group(1);
            aH.Argument arg = aH.Argument.valueOf(value);
            if (arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                return new Element(aH.getIntegerFrom(value));
            }
            if (arg.matchesPrimitive(aH.PrimitiveType.Double)) {
                return new Element(aH.getDoubleFrom(value));
            }
            return new Element(value);
        }
        return new Element(string);
    }

    public static boolean matches(String string) {
        return string != null;
    }

    public Element(String string) {
        this.prefix = "element";
        this.element = string;
    }

    public Element(Boolean bool) {
        this.prefix = "boolean";
        this.element = String.valueOf(bool);
    }

    public Element(Integer integer) {
        this.prefix = "integer";
        this.element = String.valueOf(integer);
    }

    public Element(Byte byt) {
        this.prefix = "byte";
        this.element = String.valueOf(byt);
    }

    public Element(Short shrt) {
        this.prefix = "short";
        this.element = String.valueOf(shrt);
    }

    public Element(Long lng) {
        this.prefix = "long";
        this.element = String.valueOf(lng);
    }

    public Element(Double dbl) {
        this.prefix = "double";
        this.element = String.valueOf(dbl);
    }

    public Element(Float flt) {
        this.prefix = "float";
        this.element = String.valueOf(flt);
    }

    public Element(String prefix, String string) {
        this.prefix = prefix == null ? "element" : prefix;
        this.element = string;
    }

    public double asDouble() {
        return Double.valueOf(this.element.replaceAll("(el@)|%", ""));
    }

    public float asFloat() {
        return Float.valueOf(this.element.replaceAll("(el@)|%", "")).floatValue();
    }

    public int asInt() {
        return Integer.valueOf(this.element.replaceAll("(el@)|%", ""));
    }

    public boolean asBoolean() {
        return Boolean.valueOf(this.element.replaceAll("el@", ""));
    }

    public String asString() {
        return this.element;
    }

    public String getObjectType() {
        return "Element";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public dObject setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    public String identify() {
        return this.element;
    }

    public String toString() {
        return this.identify();
    }

    public boolean isUnique() {
        return false;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("asboolean") || attribute.startsWith("as_boolean")) {
            return new Element(Boolean.valueOf(this.element).toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("asdouble") || attribute.startsWith("as_double")) {
            try {
                return new Element(Double.valueOf(this.element)).getAttribute(attribute.fulfill(1));
            }
            catch (NumberFormatException e) {
                dB.echoError("'" + this.element + "' is not a valid Double.");
                return new Element("null").getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("asduration") || attribute.startsWith("as_duration")) {
            return Duration.valueOf(this.element).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("asentity") || attribute.startsWith("as_entity")) {
            return dEntity.valueOf(this.element).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("asint") || attribute.startsWith("as_int")) {
            try {
                return new Element(Math.round(Double.valueOf(this.element))).getAttribute(attribute.fulfill(1));
            }
            catch (NumberFormatException e) {
                dB.echoError("'" + this.element + "' is not a valid Integer.");
                return new Element("null").getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("asitem") || attribute.startsWith("as_item")) {
            return dItem.valueOf(this.element).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("aslist") || attribute.startsWith("as_list")) {
            return dList.valueOf(this.element).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("aslocation") || attribute.startsWith("as_location")) {
            return dLocation.valueOf(this.element).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("asmoney") || attribute.startsWith("as_money")) {
            try {
                DecimalFormat d = new DecimalFormat("0.00");
                return new Element(d.format(Double.valueOf(this.element))).getAttribute(attribute.fulfill(1));
            }
            catch (NumberFormatException e) {
                dB.echoError("'" + this.element + "' is not a valid Money format.");
                return new Element("null").getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("asnpc") || attribute.startsWith("as_npc")) {
            return dNPC.valueOf(this.element).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("asplayer") || attribute.startsWith("as_player")) {
            return dPlayer.valueOf(this.element).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("asscript") || attribute.startsWith("as_script")) {
            return dScript.valueOf(this.element).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("contains")) {
            String contains = attribute.getContext(1);
            if (contains.toLowerCase().startsWith("regex:")) {
                if (Pattern.compile(contains.substring("regex:".length()), 2).matcher(this.element).matches()) {
                    return new Element("true").getAttribute(attribute.fulfill(1));
                }
                return new Element("false").getAttribute(attribute.fulfill(1));
            }
            if (this.element.toLowerCase().contains(contains.toLowerCase())) {
                return new Element("true").getAttribute(attribute.fulfill(1));
            }
            return new Element("false").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ends_with") || attribute.startsWith("endswith")) {
            return new Element(this.element.endsWith(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_color")) {
            return new Element(ChatColor.getLastColors((String)this.element)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("length")) {
            return new Element(this.element.length()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("starts_with") || attribute.startsWith("startswith")) {
            return new Element(this.element.startsWith(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("after")) {
            String delimiter = attribute.getContext(1);
            if (this.element.contains(delimiter)) {
                return new Element(this.element.substring(this.element.indexOf(delimiter) + delimiter.length())).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.element).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("before")) {
            String delimiter = attribute.getContext(1);
            if (this.element.contains(delimiter)) {
                return new Element(this.element.substring(0, this.element.indexOf(delimiter))).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.element).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("replace") && attribute.hasContext(1)) {
            String replace = attribute.getContext(1);
            String replacement = "";
            attribute.fulfill(1);
            if (attribute.startsWith("with") && attribute.hasContext(1)) {
                replacement = attribute.getContext(1);
                attribute.fulfill(1);
            }
            return new Element(this.element.replace(replace, replacement)).getAttribute(attribute);
        }
        if (attribute.startsWith("split") && attribute.startsWith("limit", 2)) {
            String split_string = attribute.hasContext(1) ? attribute.getContext(1) : " ";
            Integer limit = attribute.hasContext(2) ? attribute.getIntContext(2) : 1;
            if (split_string.toLowerCase().startsWith("regex:")) {
                return new dList(Arrays.asList(this.element.split(split_string.split(":", 2)[1], limit))).getAttribute(attribute.fulfill(1));
            }
            return new dList(Arrays.asList(StringUtils.split((String)this.element, (String)split_string, (int)limit))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("split")) {
            String split_string;
            String string = split_string = attribute.hasContext(1) ? attribute.getContext(1) : " ";
            if (split_string.toLowerCase().startsWith("regex:")) {
                return new dList(Arrays.asList(this.element.split(split_string.split(":", 2)[1]))).getAttribute(attribute.fulfill(1));
            }
            return new dList(Arrays.asList(StringUtils.split((String)this.element, (String)split_string))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("strip_color")) {
            return new Element(ChatColor.stripColor((String)this.element)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("trim")) {
            return new Element(this.element.trim()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("substring") || attribute.startsWith("substr")) {
            int beginning_index = Integer.valueOf(attribute.getContext(1).split(",")[0]) - 1;
            int ending_index = attribute.getContext(1).split(",").length > 1 ? Integer.valueOf(attribute.getContext(1).split(",")[1]) - 1 : this.element.length();
            if (beginning_index < 0) {
                beginning_index = 0;
            }
            if (ending_index > this.element.length()) {
                ending_index = this.element.length();
            }
            return new Element(this.element.substring(beginning_index, ending_index)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("abs")) {
            return new Element(Math.abs(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("add") && attribute.hasContext(1)) {
            return new Element(this.asDouble() + aH.getDoubleFrom(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("div") && attribute.hasContext(1)) {
            return new Element(this.asDouble() / aH.getDoubleFrom(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("mod") && attribute.hasContext(1)) {
            return new Element(this.asDouble() % aH.getDoubleFrom(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("mul") && attribute.hasContext(1)) {
            return new Element(this.asDouble() * aH.getDoubleFrom(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("sqrt")) {
            return new Element(Math.sqrt(this.asDouble())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("sub") && attribute.hasContext(1)) {
            return new Element(this.asDouble() - aH.getDoubleFrom(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.attributes.size() > 0) {
            dB.echoError("Unfilled attributes '" + attribute.attributes.toString() + "'" + "for tag <" + attribute.getOrigin() + ">!");
            return "null";
        }
        dB.log("Filled tag <" + attribute.getOrigin() + "> with '" + this.element + "'.");
        return this.element;
    }
}

