/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Rotation;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RotateCommand
extends AbstractCommand {
    public static Set<UUID> rotatingEntities = new HashSet<UUID>();

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("cancel") && (arg.matches("cancel") || arg.matches("stop"))) {
                scriptEntry.addObject("cancel", "");
                continue;
            }
            if (!scriptEntry.hasObject("infinite") && arg.matches("infinite")) {
                scriptEntry.addObject("infinite", "");
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class) && arg.matchesPrefix("duration, d")) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("frequency") && arg.matchesArgumentType(Duration.class) && arg.matchesPrefix("frequency, f")) {
                scriptEntry.addObject("frequency", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("yaw") && arg.matchesPrefix("yaw, y, rotation, r") && arg.matchesPrimitive(aH.PrimitiveType.Float)) {
                scriptEntry.addObject("yaw", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("pitch") && arg.matchesPrefix("pitch, p, tilt, t") && arg.matchesPrimitive(aH.PrimitiveType.Float)) {
                scriptEntry.addObject("pitch", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
                continue;
            }
            dB.echoError(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg.raw_value);
        }
        scriptEntry.defaultObject("entities", scriptEntry.hasPlayer() ? Arrays.asList(scriptEntry.getPlayer().getDenizenEntity()) : null, scriptEntry.hasNPC() ? Arrays.asList(scriptEntry.getNPC().getDenizenEntity()) : null);
        scriptEntry.defaultObject("yaw", new Element(10));
        scriptEntry.defaultObject("pitch", new Element(0));
        scriptEntry.defaultObject("duration", new Duration(20));
        scriptEntry.defaultObject("frequency", Duration.valueOf("1t"));
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "entities");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        final List entities = (List)scriptEntry.getObject("entities");
        final Duration duration = (Duration)scriptEntry.getObject("duration");
        final Duration frequency = (Duration)scriptEntry.getObject("frequency");
        final Element yaw = (Element)scriptEntry.getObject("yaw");
        final Element pitch = (Element)scriptEntry.getObject("pitch");
        boolean cancel = scriptEntry.hasObject("cancel");
        final boolean infinite = scriptEntry.hasObject("infinite");
        dB.report(this.getName(), (cancel ? aH.debugObj("cancel", cancel) : "") + aH.debugObj("entities", entities.toString()) + (infinite ? aH.debugObj("duration", "infinite") : duration.debug()) + frequency.debug() + yaw.debug() + pitch.debug());
        for (dEntity entity : entities) {
            if (cancel) {
                rotatingEntities.remove(entity.getUUID());
                continue;
            }
            rotatingEntities.add(entity.getUUID());
        }
        if (cancel) {
            return;
        }
        BukkitRunnable task = new BukkitRunnable(){
            int ticks = 0;
            int maxTicks = duration.getTicksAsInt();
            Collection<dEntity> unusedEntities = new LinkedList<dEntity>();

            public void run() {
                if (entities.isEmpty()) {
                    this.cancel();
                } else if (infinite || this.ticks < this.maxTicks) {
                    for (dEntity entity : entities) {
                        if (entity.isSpawned() && rotatingEntities.contains(entity.getUUID())) {
                            Rotation.rotate(entity.getBukkitEntity(), Rotation.normalizeYaw(entity.getLocation().getYaw() + yaw.asFloat()), entity.getLocation().getPitch() + pitch.asFloat());
                            continue;
                        }
                        rotatingEntities.remove(entity.getUUID());
                        this.unusedEntities.add(entity);
                    }
                    if (!this.unusedEntities.isEmpty()) {
                        for (dEntity unusedEntity : this.unusedEntities) {
                            entities.remove(unusedEntity);
                        }
                        this.unusedEntities.clear();
                    }
                    this.ticks = (int)((long)this.ticks + frequency.getTicks());
                } else {
                    this.cancel();
                }
            }
        };
        task.runTaskTimer((Plugin)this.denizen, 0L, frequency.getTicks());
    }
}

