/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;

public class TakeCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("type") && arg.matches("money, coins")) {
                scriptEntry.addObject("type", (Object)Type.MONEY);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("item_in_hand, iteminhand")) {
                scriptEntry.addObject("type", (Object)Type.ITEMINHAND);
                continue;
            }
            if (!scriptEntry.hasObject("qty") && arg.matchesPrefix("q, qty, quantity") && arg.matchesPrimitive(aH.PrimitiveType.Double)) {
                scriptEntry.addObject("qty", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("items") && !scriptEntry.hasObject("type") && arg.matchesArgumentList(dItem.class)) {
                scriptEntry.addObject("items", dList.valueOf(arg.raw_value.replace("item:", "")).filter(dItem.class));
                continue;
            }
            if (!scriptEntry.hasObject("inventory") && arg.matchesPrefix("f, from") && arg.matchesArgumentType(dInventory.class)) {
                scriptEntry.addObject("inventory", arg.asType(dInventory.class));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("inventory")) {
                scriptEntry.addObject("type", (Object)Type.INVENTORY);
                continue;
            }
            if (scriptEntry.hasObject("inventory") || !arg.matches("npc")) continue;
            scriptEntry.addObject("inventory", new dInventory(scriptEntry.getNPC().getEntity()));
        }
        scriptEntry.defaultObject("type", new Object[]{Type.ITEM}).defaultObject("inventory", scriptEntry.hasPlayer() ? new dInventory(scriptEntry.getPlayer().getPlayerEntity()) : null).defaultObject("qty", new Element(1));
        if (scriptEntry.getObject("type") == Type.ITEM && scriptEntry.getObject("items") == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "ITEMS");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dInventory inventory = (dInventory)scriptEntry.getObject("inventory");
        Element qty = scriptEntry.getElement("qty");
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        Object items_object = scriptEntry.getObject("items");
        List items = null;
        if (items_object != null) {
            items = (List)items_object;
        }
        dB.report(this.getName(), aH.debugObj("Type", type.name()) + qty.debug() + inventory.debug() + aH.debugObj("Items", items));
        switch (type) {
            case INVENTORY: {
                inventory.clear();
                break;
            }
            case ITEMINHAND: {
                int inHandAmt = scriptEntry.getPlayer().getPlayerEntity().getItemInHand().getAmount();
                int theAmount = qty.asInt();
                ItemStack newHandItem = new ItemStack(0);
                if (theAmount > inHandAmt) {
                    dB.echoDebug("...player did not have enough of the item in hand, so Denizen just took as many as it could. To avoid this situation, use an IF <PLAYER.ITEM_IN_HAND.QTY>.");
                    scriptEntry.getPlayer().getPlayerEntity().setItemInHand(newHandItem);
                    break;
                }
                if (theAmount == inHandAmt) {
                    scriptEntry.getPlayer().getPlayerEntity().setItemInHand(newHandItem);
                    break;
                }
                newHandItem = new ItemStack(scriptEntry.getPlayer().getPlayerEntity().getItemInHand().getType(), inHandAmt - theAmount, (short)scriptEntry.getPlayer().getPlayerEntity().getItemInHand().getData().getData());
                newHandItem.setItemMeta(scriptEntry.getPlayer().getPlayerEntity().getItemInHand().getItemMeta());
                scriptEntry.getPlayer().getPlayerEntity().setItemInHand(newHandItem);
                scriptEntry.getPlayer().getPlayerEntity().updateInventory();
                break;
            }
            case MONEY: {
                if (Depends.economy != null) {
                    dB.echoDebug("...taking " + qty.asDouble() + " money.");
                    Depends.economy.withdrawPlayer(scriptEntry.getPlayer().getName(), qty.asDouble());
                    break;
                }
                dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                break;
            }
            case ITEM: {
                for (dItem item : items) {
                    ItemStack is = item.getItemStack();
                    is.setAmount(qty.asInt());
                    if (is.getItemMeta() instanceof BookMeta) {
                        if (!((BookMeta)is.getItemMeta()).hasTitle()) continue;
                        inventory.removeBook(is);
                        continue;
                    }
                    if (inventory.getInventory().removeItem(new ItemStack[]{is}).isEmpty()) continue;
                    dB.echoError("Inventory does not contain at least " + qty.asInt() + " of " + item.identify() + "... Taking as much as possible...");
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        MONEY,
        ITEMINHAND,
        ITEM,
        INVENTORY;

    }
}

