/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class ScoreboardHelper {
    public static ScoreboardManager manager = Bukkit.getScoreboardManager();
    public static Map<String, Scoreboard> scoreboards = new HashMap<String, Scoreboard>();

    public static void _recallScoreboards() {
        for (Map.Entry<String, Scoreboard> entry : scoreboards.entrySet()) {
            ScoreboardHelper.clearScoreboard(entry.getValue());
        }
        scoreboards.clear();
        ConfigurationSection rootSection = DenizenAPI.getCurrentInstance().getScoreboards().getConfigurationSection("Scoreboards");
        if (rootSection == null) {
            return;
        }
        Scoreboard board = null;
        for (String id : rootSection.getKeys(false)) {
            board = ScoreboardHelper.createScoreboard(id);
            List viewers = rootSection.getStringList(id + ".Viewers");
            for (String viewer : viewers) {
                dPlayer player;
                if (!dPlayer.matches(viewer) || !(player = dPlayer.valueOf(viewer)).isOnline()) continue;
                player.getPlayerEntity().setScoreboard(board);
            }
            ConfigurationSection objSection = rootSection.getConfigurationSection(id + ".Objectives");
            if (objSection == null) {
                return;
            }
            for (String obj : objSection.getKeys(false)) {
                ConfigurationSection scoreSection;
                String displaySlot = objSection.getString(obj + ".Display slot");
                String criteria = objSection.getString(obj + ".Criteria");
                if (criteria == null) {
                    criteria = "dummy";
                }
                if (displaySlot == null) {
                    displaySlot = "NONE";
                }
                Objective o = board.registerNewObjective(obj, criteria);
                o.setDisplayName(obj);
                if (aH.Argument.valueOf(displaySlot).matchesEnum((Enum[])DisplaySlot.values())) {
                    o.setDisplaySlot(DisplaySlot.valueOf((String)displaySlot.toUpperCase()));
                }
                if ((scoreSection = objSection.getConfigurationSection(obj + ".Scores")) == null) continue;
                for (String scoreName : scoreSection.getKeys(false)) {
                    int scoreInt = scoreSection.getInt(scoreName);
                    ScoreboardHelper.addScore(o, scoreName, scoreInt);
                }
            }
        }
    }

    public static void _saveScoreboards() {
        for (Map.Entry<String, Scoreboard> entry : scoreboards.entrySet()) {
            String id = entry.getKey();
            ArrayList<String> viewers = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.getScoreboard() != entry.getValue()) continue;
                viewers.add(player.getName());
            }
            DenizenAPI.getCurrentInstance().getScoreboards().set("Scoreboards." + id + ".Viewers", viewers);
            for (Objective obj : entry.getValue().getObjectives()) {
                String objPath = "Scoreboards." + id + ".Objectives." + obj.getName();
                DenizenAPI.getCurrentInstance().getScoreboards().set(objPath + ".Criteria", (Object)obj.getCriteria());
                String displaySlot = obj.getDisplaySlot() != null ? obj.getDisplaySlot().name() : "NONE";
                DenizenAPI.getCurrentInstance().getScoreboards().set(objPath + ".Display slot", (Object)displaySlot);
                for (OfflinePlayer player : entry.getValue().getPlayers()) {
                    int score = obj.getScore(player).getScore();
                    if (score == 0) continue;
                    DenizenAPI.getCurrentInstance().getScoreboards().set(objPath + ".Scores." + player.getName(), (Object)score);
                }
            }
        }
    }

    public static void addScore(Objective o, String name, int score) {
        Score sc = o.getScore(Bukkit.getOfflinePlayer((String)name));
        if (score == 0) {
            sc.setScore(1);
            sc.setScore(0);
        } else {
            sc.setScore(score);
        }
    }

    public static void removeScore(Objective o, String name) {
        Scoreboard board = o.getScoreboard();
        HashMap<String, Integer> scoreMap = new HashMap<String, Integer>();
        for (Score score : board.getScores(Bukkit.getOfflinePlayer((String)name))) {
            if (score.getObjective().equals(o)) continue;
            scoreMap.put(score.getObjective().getName(), score.getScore());
        }
        board.resetScores(Bukkit.getOfflinePlayer((String)name));
        for (Map.Entry entry : scoreMap.entrySet()) {
            board.getObjective((String)entry.getKey()).getScore(Bukkit.getOfflinePlayer((String)name)).setScore(((Integer)entry.getValue()).intValue());
        }
    }

    public static void clearScoreboard(Scoreboard board) {
        for (Objective o : board.getObjectives()) {
            o.unregister();
        }
    }

    public static Scoreboard createScoreboard() {
        Scoreboard board = manager.getNewScoreboard();
        return board;
    }

    public static Scoreboard createScoreboard(String id) {
        Scoreboard board = manager.getNewScoreboard();
        scoreboards.put(id.toUpperCase(), board);
        return board;
    }

    public static void deleteScoreboard(String id) {
        if (id.equalsIgnoreCase("main")) {
            ScoreboardHelper.clearScoreboard(ScoreboardHelper.getMain());
        } else {
            ScoreboardHelper.clearScoreboard(ScoreboardHelper.getScoreboard(id));
            scoreboards.remove(id.toUpperCase());
        }
    }

    public static Scoreboard getMain() {
        return manager.getMainScoreboard();
    }

    public static Scoreboard getScoreboard(String id) {
        return scoreboards.get(id.toUpperCase());
    }

    public static boolean hasScoreboard(String id) {
        return scoreboards.containsKey(id.toUpperCase());
    }
}

