/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.notable.Notable;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.objects.notable.Note;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.core.InventoryScriptContainer;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dInventory
implements dObject,
Notable {
    public static final int maxSlots = 54;
    static final Pattern inventory_by_type = Pattern.compile("(in@)(npc|player|entity|location|equipment|generic)\\[(.+?)\\]", 2);
    static final Pattern inventory_by_script = Pattern.compile("(in@)(.+)", 2);
    String idType = null;
    String idHolder = null;
    private Inventory inventory = null;
    private String prefix = this.getObjectType();

    @Override
    public boolean isUnique() {
        return this.idType.equals("notable");
    }

    @Override
    @Note(value="inventory")
    public String getSaveObject() {
        return this.idHolder;
    }

    @Override
    public void makeUnique(String id) {
        this.idType = "notable";
        this.idHolder = id;
        NotableManager.saveAs(this, id);
    }

    @Override
    public void forget() {
        NotableManager.remove(this.idHolder);
        this.loadIdentifiers();
    }

    public static dInventory valueOf(String string) {
        return dInventory.valueOf(string, null, null);
    }

    @ObjectFetcher(value="in")
    public static dInventory valueOf(String string, dPlayer player, dNPC npc) {
        if (string == null) {
            return null;
        }
        Matcher m = inventory_by_type.matcher(string);
        if (m.matches()) {
            String type = m.group(2);
            String holder = m.group(3);
            if (type.equalsIgnoreCase("generic")) {
                aH.Argument arg = aH.Argument.valueOf(holder);
                if (arg.matchesEnum((Enum[])InventoryType.values())) {
                    return new dInventory(InventoryType.valueOf((String)holder.toUpperCase()));
                }
                if (arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                    return new dInventory(arg.asElement().asInt());
                }
                dB.echoError("That type of inventory does not exist!");
            } else if (type.equalsIgnoreCase("entity") || type.equalsIgnoreCase("player") || type.equalsIgnoreCase("npc")) {
                if (dEntity.matches(holder)) {
                    return dEntity.valueOf(holder).getInventory();
                }
            } else if (type.equalsIgnoreCase("location")) {
                if (dLocation.matches(holder)) {
                    return dLocation.valueOf(holder).getInventory();
                }
            } else if (type.equalsIgnoreCase("equipment")) {
                dEntity.valueOf(holder).getEquipment();
            }
            dB.echoError("Value of dInventory returning null. Invalid " + type + " specified: " + holder);
            return null;
        }
        m = inventory_by_script.matcher(string);
        if (m.matches()) {
            if (ScriptRegistry.containsScript(m.group(2), InventoryScriptContainer.class)) {
                return ScriptRegistry.getScriptContainerAs(m.group(2), InventoryScriptContainer.class).getInventoryFrom(player, npc);
            }
            if (NotableManager.isSaved(m.group(2)) && NotableManager.isType(m.group(2), dInventory.class)) {
                return (dInventory)NotableManager.getSavedObject(m.group(2));
            }
        }
        dB.echoError("Value of dInventory returning null. Invalid dInventory specified: " + string);
        return null;
    }

    public static boolean matches(String arg) {
        return dInventory.valueOf(arg) != null;
    }

    public dInventory(Inventory inventory) {
        this.inventory = inventory;
        this.loadIdentifiers();
    }

    public dInventory(InventoryHolder holder) {
        this.inventory = holder.getInventory();
        this.loadIdentifiers();
    }

    public dInventory(InventoryType type) {
        this.inventory = Bukkit.getServer().createInventory(null, type);
        this.loadIdentifiers();
    }

    public dInventory(int size) {
        this.inventory = Bukkit.getServer().createInventory(null, size);
        this.loadIdentifiers();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private void loadIdentifiers() {
        InventoryHolder holder = this.inventory.getHolder();
        if (holder != null) {
            if (holder instanceof Player) {
                this.idType = "player";
                this.idHolder = "p@" + ((Player)holder).getName();
            } else if (holder instanceof Entity) {
                this.idType = "entity";
                this.idHolder = "e@" + ((Entity)holder).getEntityId();
            } else {
                this.idType = "location";
                this.idHolder = this.getLocation().identify();
            }
        } else {
            this.idType = "generic";
            this.idHolder = this.getInventory().getType().name();
        }
    }

    public void setIdentifiers(String type, String holder) {
        this.idType = type;
        this.idHolder = holder;
    }

    public String getIdType() {
        return this.idType;
    }

    public String getIdHolder() {
        return this.idHolder;
    }

    public dLocation getLocation() {
        if (this.inventory != null) {
            InventoryHolder holder = this.inventory.getHolder();
            if (holder instanceof BlockState) {
                return new dLocation(((BlockState)holder).getLocation());
            }
            if (holder instanceof Player) {
                return new dLocation(((Player)holder).getLocation());
            }
        }
        return null;
    }

    public ItemStack[] getContents() {
        if (this.inventory != null) {
            return this.inventory.getContents();
        }
        return new ItemStack[0];
    }

    public dInventory getEquipment() {
        if (this.inventory instanceof PlayerInventory) {
            return new dInventory(InventoryType.CRAFTING).add(((PlayerInventory)this.inventory).getArmorContents());
        }
        if (this.inventory instanceof HorseInventory) {
            return new dInventory(InventoryType.CRAFTING).add(((HorseInventory)this.inventory).getArmor()).add(((HorseInventory)this.inventory).getSaddle());
        }
        return null;
    }

    public InventoryType getInventoryType() {
        return this.inventory.getType();
    }

    public int getSize() {
        return this.inventory.getSize();
    }

    public void remove(ItemStack item) {
        this.inventory.remove(item);
    }

    public void setContents(ItemStack[] contents) {
        this.inventory.setContents(contents);
    }

    public dInventory add(ItemStack ... items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        for (ItemStack item : items) {
            if (item == null) continue;
            this.inventory.addItem(new ItemStack[]{item});
        }
        return this;
    }

    public HashMap<Integer, ItemStack> addWithLeftovers(ItemStack ... items) {
        if (this.inventory == null || items == null) {
            return null;
        }
        return this.inventory.addItem(items);
    }

    public int count(ItemStack item, boolean stacks) {
        if (this.inventory == null) {
            return 0;
        }
        int qty = 0;
        for (ItemStack invStack : this.inventory) {
            if (invStack == null || item != null && !invStack.isSimilar(item)) continue;
            if (stacks) {
                ++qty;
                continue;
            }
            qty += invStack.getAmount();
        }
        return qty;
    }

    public dInventory keep(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        for (ItemStack invStack : this.inventory) {
            if (invStack == null) continue;
            boolean keep = false;
            for (ItemStack item : items) {
                if (!invStack.isSimilar(item)) continue;
                keep = true;
                break;
            }
            if (keep) continue;
            this.remove(invStack);
        }
        return this;
    }

    public dInventory exclude(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        int oldCount = this.count(null, false);
        int newCount = -1;
        while (oldCount != newCount) {
            oldCount = newCount;
            newCount = this.remove(items).count(null, false);
        }
        return this;
    }

    public dInventory fill(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        int oldCount = this.count(null, false);
        int newCount = -1;
        while (oldCount != newCount) {
            oldCount = newCount;
            newCount = this.add(items).count(null, false);
        }
        return this;
    }

    public dInventory remove(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        for (ItemStack item : items) {
            if (item == null) continue;
            this.inventory.removeItem(new ItemStack[]{item});
        }
        return this;
    }

    public dInventory removeBook(ItemStack book) {
        if (this.inventory == null || book == null) {
            return this;
        }
        int qty = book.getAmount();
        BookMeta bookMeta = (BookMeta)book.getItemMeta();
        for (ItemStack invStack : this.inventory) {
            BookMeta invMeta;
            if (qty == 0) break;
            if (invStack == null || !(invStack.getItemMeta() instanceof BookMeta) || !(invMeta = (BookMeta)invStack.getItemMeta()).getAuthor().equalsIgnoreCase(bookMeta.getAuthor()) || !invMeta.getTitle().equalsIgnoreCase(bookMeta.getTitle())) continue;
            if (qty - invStack.getAmount() < 0) {
                invStack.setAmount((qty - invStack.getAmount()) * -1);
                continue;
            }
            this.inventory.removeItem(new ItemStack[]{invStack});
            qty -= invStack.getAmount();
        }
        return this;
    }

    public void replace(dInventory destination) {
        if (this.inventory == null || destination == null) {
            return;
        }
        if (destination.getSize() < this.getSize()) {
            destination.clear();
            destination.add(this.getContents());
        } else {
            destination.setContents(this.getContents());
        }
    }

    public void clear() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
    }

    @Override
    public String getObjectType() {
        return "Inventory";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dInventory setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    @Override
    public String identify() {
        return "in@" + (this.idType.equals("script") || this.idType.equals("notable") ? this.idHolder : this.idType + '[' + this.idHolder + ']');
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("contains.display") && attribute.hasContext(2)) {
            int qty = 1;
            int attribs = 2;
            String search_string = attribute.getContext(2);
            boolean strict = false;
            if (search_string.startsWith("strict:")) {
                strict = true;
                search_string = search_string.replace("strict:", "");
            }
            if (attribute.getAttribute(3).startsWith("qty") && attribute.hasContext(3) && aH.matchesInteger(attribute.getContext(3))) {
                qty = attribute.getIntContext(3);
                attribs = 3;
            }
            int found_items = 0;
            if (strict) {
                for (ItemStack item : this.getContents()) {
                    if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName() || !item.getItemMeta().getDisplayName().equalsIgnoreCase(search_string)) continue;
                    ++found_items;
                }
            } else {
                for (ItemStack item : this.getContents()) {
                    if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName() || !item.getItemMeta().getDisplayName().toLowerCase().contains(search_string.toLowerCase())) continue;
                    ++found_items;
                }
            }
            return found_items >= qty ? Element.TRUE.getAttribute(attribute.fulfill(attribs)) : Element.FALSE.getAttribute(attribute.fulfill(attribs));
        }
        if (attribute.startsWith("contains") && attribute.hasContext(1) && dItem.matches(attribute.getContext(1))) {
            int qty = 1;
            int attribs = 1;
            if (attribute.getAttribute(2).startsWith("qty") && attribute.hasContext(2) && aH.matchesInteger(attribute.getContext(2))) {
                qty = attribute.getIntContext(2);
                attribs = 2;
            }
            return new Element(this.getInventory().containsAtLeast(dItem.valueOf(attribute.getContext(1)).getItemStack(), qty)).getAttribute(attribute.fulfill(attribs));
        }
        if (attribute.startsWith("location")) {
            return new dLocation(this.getLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("qty")) {
            if (attribute.hasContext(1) && dItem.matches(attribute.getContext(1))) {
                return new Element(this.count(dItem.valueOf(attribute.getContext(1)).getItemStack(), false)).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.count(null, false)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("size")) {
            return new Element(this.getSize()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("stacks")) {
            if (attribute.hasContext(1) && dItem.matches(attribute.getContext(1))) {
                return new Element(this.count(dItem.valueOf(attribute.getContext(1)).getItemStack(), true)).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.count(null, true)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element(this.getInventory().getType().name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("equipment")) {
            return this.getEquipment().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_contents")) {
            ArrayList<dItem> items = new ArrayList<dItem>();
            for (ItemStack item : this.getContents()) {
                if (item == null || item.getType() == Material.AIR) continue;
                items.add(new dItem(item));
            }
            return new dList(items).getAttribute(attribute.fulfill(1));
        }
        return new Element(this.identify()).getAttribute(attribute);
    }
}

