/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class TimeCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", (Object)Type.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("value") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("value", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(dWorld.class)) {
                scriptEntry.addObject("world", arg.asType(dWorld.class));
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg.raw_value);
        }
        if (!scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "VALUE");
        }
        scriptEntry.defaultObject("world", scriptEntry.hasNPC() ? new dWorld(scriptEntry.getNPC().getWorld()) : null, scriptEntry.hasPlayer() ? new dWorld(scriptEntry.getPlayer().getWorld()) : null, dWorld.valueOf("world"));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Duration value = (Duration)scriptEntry.getObject("value");
        dWorld world = (dWorld)scriptEntry.getObject("world");
        Type type = scriptEntry.hasObject("type") ? (Type)((Object)scriptEntry.getObject("type")) : Type.GLOBAL;
        dB.report(this.getName(), aH.debugObj("type", type.name()) + (type.name().equalsIgnoreCase("player") ? aH.debugObj("player", scriptEntry.getPlayer()) : "") + (type.name().equalsIgnoreCase("global") ? aH.debugObj("world", world) : "") + aH.debugObj("value", value));
        if (type.equals((Object)Type.GLOBAL)) {
            world.getWorld().setTime(value.getTicks());
        } else {
            scriptEntry.getPlayer().getPlayerEntity().setPlayerTime(value.getTicks(), true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        GLOBAL,
        PLAYER;

    }
}

