/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.schematic.SchematicFormat;
import java.io.File;
import java.net.URLDecoder;
import java.util.Map;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class SchematicCommand
extends AbstractCommand
implements Listener {
    public static Map<String, CuboidClipboard> schematics;

    public void onEnable() {
        if (Depends.worldEdit != null) {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        }
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (Depends.worldEdit == null) {
            dB.echoError("This command requires WorldEdit!");
            return;
        }
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", new Element(arg.raw_value.toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("name") && arg.matchesPrefix("name")) {
                scriptEntry.addObject("name", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("angle") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("angle", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("noair") && arg.matches("noair")) {
                scriptEntry.addObject("noair", Element.TRUE);
                continue;
            }
            dB.echoError(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg.raw_value);
        }
        if (!scriptEntry.hasObject("type")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "type");
        }
        if (!scriptEntry.hasObject("name")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "name");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element angle = scriptEntry.getElement("angle");
        Element type = scriptEntry.getElement("type");
        Element name = scriptEntry.getElement("name");
        Element noair = scriptEntry.getElement("noair");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        dB.report(this.getName(), type.debug() + name.debug() + (location != null ? location.debug() : "") + (angle != null ? angle.debug() : "") + (noair != null ? noair.debug() : ""));
        switch (Type.valueOf(type.asString())) {
            case LOAD: {
                CuboidClipboard cc;
                if (schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError("Schematic file " + name.asString() + " is already loaded.");
                    return;
                }
                try {
                    String directory = URLDecoder.decode(System.getProperty("user.dir"));
                    File f = new File(directory + "/plugins/Denizen/schematics/" + name.asString() + ".schematic");
                    if (!f.exists()) {
                        dB.echoError("Schematic file " + name.asString() + " does not exist.");
                        return;
                    }
                    cc = SchematicFormat.MCEDIT.load(f);
                }
                catch (Exception ex) {
                    dB.echoError("Error loading schematic file " + name.asString() + ".");
                    return;
                }
                schematics.put(name.asString().toUpperCase(), cc);
                break;
            }
            case UNLOAD: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError("Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                schematics.remove(name.asString().toUpperCase());
                break;
            }
            case ROTATE: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError("Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                if (angle == null) {
                    dB.echoError(dB.Messages.ERROR_MISSING_OTHER, "ANGLE");
                    return;
                }
                schematics.get(name.asString().toUpperCase()).rotate2D(angle.asInt());
                break;
            }
            case PASTE: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError("Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                if (location == null) {
                    dB.echoError(dB.Messages.ERROR_MISSING_OTHER, "LOCATION");
                    return;
                }
                try {
                    schematics.get(name.asString().toUpperCase()).paste(new EditSession((LocalWorld)new BukkitWorld(location.getWorld()), 99999999), new Vector(location.getX(), location.getY(), location.getZ()), noair != null);
                    break;
                }
                catch (Exception ex) {
                    dB.echoError("Exception while pasting " + name.asString());
                }
            }
        }
    }

    @EventHandler
    public void schematicTags(ReplaceableTagEvent event) {
        if (!event.matches("schematic, schem")) {
            return;
        }
        if (!event.hasNameContext()) {
            return;
        }
        String id = event.getNameContext().toUpperCase();
        if (!schematics.containsKey(id)) {
            dB.echoError("Schematic file " + id + " is not loaded.");
            return;
        }
        CuboidClipboard cc = schematics.get(id);
        Attribute attribute = new Attribute(event.raw_tag, event.getScriptEntry()).fulfill(1);
        if (attribute.startsWith("height")) {
            event.setReplaced(new Element(cc.getHeight()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("length")) {
            event.setReplaced(new Element(cc.getLength()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("width")) {
            event.setReplaced(new Element(cc.getWidth()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("block") && attribute.hasContext(1) && dLocation.matches(attribute.getContext(1))) {
            dLocation location = dLocation.valueOf(attribute.getContext(1));
            BaseBlock bb = cc.getBlock(new Vector(location.getX(), location.getY(), location.getZ()));
            event.setReplaced(dMaterial.valueOf(bb.getType() + ":" + bb.getData()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("origin")) {
            event.setReplaced(new dLocation((World)Bukkit.getWorlds().get(0), cc.getOrigin().getX(), cc.getOrigin().getY(), cc.getOrigin().getZ()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("offset")) {
            event.setReplaced(new dLocation((World)Bukkit.getWorlds().get(0), cc.getOffset().getX(), cc.getOffset().getY(), cc.getOffset().getZ()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("blocks")) {
            event.setReplaced(new Element(cc.getHeight() * cc.getWidth() * cc.getLength()).getAttribute(attribute.fulfill(1)));
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        LOAD,
        UNLOAD,
        ROTATE,
        PASTE;

    }
}

