/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.Fetchable;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.commands.core.CooldownCommand;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.tags.Attribute;

public class dScript
implements dObject {
    public static final Pattern CONTAINER_PATTERN = Pattern.compile("(s@|)(.+)", 2);
    private ScriptContainer container;
    private String prefix = "Container";
    private String name = null;
    private boolean valid = false;

    @Fetchable(value="s")
    public static dScript valueOf(String string) {
        dScript script;
        Matcher m = CONTAINER_PATTERN.matcher(string);
        if (m.matches() && (script = new dScript(m.group(2))).isValid()) {
            return script;
        }
        return null;
    }

    public static boolean matches(String string) {
        dScript script;
        Matcher m = CONTAINER_PATTERN.matcher(string);
        return m.matches() && (script = new dScript(m.group(2))).isValid();
    }

    public dScript(String scriptName) {
        if (ScriptRegistry.getScriptContainer(scriptName) != null) {
            this.container = ScriptRegistry.getScriptContainer(scriptName);
            this.name = scriptName.toUpperCase();
            this.valid = true;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getType() {
        return this.container != null ? this.container.getContainerType() : "invalid";
    }

    public String getName() {
        return this.name;
    }

    public ScriptContainer getContainer() {
        return this.container;
    }

    public String getObjectType() {
        return "Container";
    }

    public String identify() {
        return "s@" + this.name;
    }

    public String toString() {
        return this.identify();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public dObject setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return "<G>" + this.prefix + "='<A>" + this.name + "<Y>(" + this.getType() + ")<G>'  ";
    }

    public boolean isUnique() {
        return true;
    }

    public String colorless_debug() {
        return this.prefix + "='" + this.name + "(" + this.getType() + ")'";
    }

    public String getAttribute(Attribute attribute) {
        dPlayer player;
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("container_type") || attribute.startsWith("type")) {
            return new Element(this.container.getContainerType()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("cooled_down")) {
            dPlayer player2;
            dPlayer dPlayer2 = player2 = attribute.hasContext(1) ? dPlayer.valueOf(attribute.getContext(1)) : attribute.getScriptEntry().getPlayer();
            if (player2 != null && player2.isValid()) {
                return new Element(this.container.checkCooldown(player2)).getAttribute(attribute.fulfill(1));
            }
            return "null";
        }
        if (attribute.startsWith("requirements.check")) {
            dPlayer dPlayer3 = player = attribute.hasContext(1) ? dPlayer.valueOf(attribute.getContext(1)) : attribute.getScriptEntry().getPlayer();
            if (attribute.hasContext(2)) {
                return new Element(this.container.checkRequirements(player, attribute.getScriptEntry().getNPC(), attribute.getContext(2))).getAttribute(attribute.fulfill(2));
            }
        }
        if (attribute.startsWith("cooldown")) {
            player = attribute.hasContext(1) ? dPlayer.valueOf(attribute.getContext(1)) : attribute.getScriptEntry().getPlayer();
            return CooldownCommand.getCooldownDuration(player != null ? player.getName() : null, this.container.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name")) {
            return new Element(this.name).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.colorless_debug()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("object_type")) {
            return new Element(this.getObjectType()).getAttribute(attribute.fulfill(1));
        }
        return new Element(this.identify()).getAttribute(attribute);
    }
}

