/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;

public class DropCommand
extends AbstractCommand {
    public String getHelp() {
        return "Drops things into the world. Must specify something to drop,such as 'experience', an item, or an entity. Must alsospecify a location, and if more than 1, a quantity. \n \nUse to drop items, even custom item_scripts. \n- drop iron_helmet <npc.location> \n- drop butter 5 <notable.location[churn]> \nUse to reward the player with some experience. \n- drop experience 1000 <player.location> \nUse to drop entities, such as boats or minecarts. \n- drop e@boat <player.flag[dock_location]>";
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("action") && !arg.matchesPrefix("qty") && arg.matchesArgumentType(dItem.class)) {
                scriptEntry.addObject("action", new Element(Action.DROP_ITEM.toString()).setPrefix("action"));
                scriptEntry.addObject("item", dItem.valueOf(arg.getValue(), scriptEntry.getPlayer(), scriptEntry.getNPC()).setPrefix("item"));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("experience, exp, xp")) {
                scriptEntry.addObject("action", new Element(Action.DROP_EXP.toString()).setPrefix("action"));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesArgumentType(dEntity.class)) {
                scriptEntry.addObject("action", new Element(Action.DROP_ENTITY.toString()).setPrefix("action"));
                scriptEntry.addObject("entity", arg.asType(dEntity.class).setPrefix("entity"));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class).setPrefix("location"));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesPrefix("speed") && arg.matchesPrimitive(aH.PrimitiveType.Double)) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("qty") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("qty", arg.asElement().setPrefix("qty"));
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg.raw_value);
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify something to drop!");
        }
        if (!scriptEntry.hasObject("location")) {
            if (scriptEntry.getPlayer() != null && scriptEntry.getPlayer().isOnline()) {
                scriptEntry.addObject("location", scriptEntry.getPlayer().getLocation().setPrefix("location"));
                dB.echoDebug("Did not specify a location, assuming Player's location.");
            } else {
                throw new InvalidArgumentsException("Must specify a location!");
            }
        }
        if (!scriptEntry.hasObject("qty")) {
            scriptEntry.addObject("qty", Element.valueOf("1").setPrefix("qty"));
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation location = (dLocation)scriptEntry.getObject("location");
        Element qty = scriptEntry.getElement("qty");
        Element action = scriptEntry.getElement("action");
        Element speed = scriptEntry.getElement("speed");
        dItem item = (dItem)scriptEntry.getObject("item");
        dEntity entity = (dEntity)scriptEntry.getObject("entity");
        dB.report(this.getName(), action.debug() + location.debug() + qty.debug() + (item != null ? item.debug() : "") + (entity != null ? entity.debug() : "") + (speed != null ? speed.debug() : ""));
        switch (Action.valueOf(action.asString())) {
            case DROP_EXP: {
                ((ExperienceOrb)location.getWorld().spawnEntity((Location)location, EntityType.EXPERIENCE_ORB)).setExperience(qty.asInt());
                break;
            }
            case DROP_ITEM: {
                if (qty.asInt() > 1 && item.isUnique()) {
                    dB.echoDebug("Cannot drop multiples of this item because it is Unique!");
                }
                for (int x = 0; x < qty.asInt(); ++x) {
                    Item e = location.getWorld().dropItemNaturally((Location)location, item.getItemStack());
                    e.setVelocity(e.getVelocity().multiply(speed != null ? speed.asDouble() : 1.0));
                }
                break;
            }
            case DROP_ENTITY: {
                if (qty.asInt() > 1 && entity.isUnique()) {
                    dB.echoDebug("Cannot drop multiples of this entity because it is Unique!");
                }
                for (int x = 0; x < qty.asInt(); ++x) {
                    entity.spawnAt(location);
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        DROP_ITEM,
        DROP_EXP,
        DROP_ENTITY;

    }
}

