/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class ScoreboardHelper {
    public static ScoreboardManager manager = Bukkit.getScoreboardManager();
    public static Map<String, Scoreboard> scoreboardMap = new HashMap<String, Scoreboard>();
    public static Map<String, String> viewerMap = new HashMap<String, String>();

    public static void _recallScoreboards() {
        for (Map.Entry<String, Scoreboard> entry : scoreboardMap.entrySet()) {
            ScoreboardHelper.clearScoreboard(entry.getValue());
        }
        Scoreboard emptyBoard = ScoreboardHelper.createScoreboard();
        for (Map.Entry<String, String> entry : viewerMap.entrySet()) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((String)entry.getKey());
            if (!player.isOnline()) continue;
            player.getPlayer().setScoreboard(emptyBoard);
        }
        scoreboardMap.clear();
        viewerMap.clear();
        ConfigurationSection rootSection = DenizenAPI.getCurrentInstance().getScoreboards().getConfigurationSection("Scoreboards");
        if (rootSection == null) {
            return;
        }
        Scoreboard board = null;
        for (String id : rootSection.getKeys(false)) {
            board = ScoreboardHelper.createScoreboard(id);
            List viewerList = rootSection.getStringList(id + ".Viewers");
            for (String viewer : viewerList) {
                if (!dPlayer.matches(viewer)) continue;
                dPlayer player = dPlayer.valueOf(viewer);
                viewerMap.put(player.getName(), id);
                if (!player.isOnline()) continue;
                player.getPlayerEntity().setScoreboard(board);
            }
            ConfigurationSection objSection = rootSection.getConfigurationSection(id + ".Objectives");
            if (objSection == null) {
                return;
            }
            for (String obj : objSection.getKeys(false)) {
                ConfigurationSection scoreSection;
                String displaySlot = objSection.getString(obj + ".Display slot");
                String criteria = objSection.getString(obj + ".Criteria");
                if (criteria == null) {
                    criteria = "dummy";
                }
                if (displaySlot == null) {
                    displaySlot = "NONE";
                }
                Objective o = board.registerNewObjective(obj, criteria);
                o.setDisplayName(obj);
                if (aH.Argument.valueOf(displaySlot).matchesEnum((Enum[])DisplaySlot.values())) {
                    o.setDisplaySlot(DisplaySlot.valueOf((String)displaySlot.toUpperCase()));
                }
                if ((scoreSection = objSection.getConfigurationSection(obj + ".Scores")) == null) continue;
                for (String scoreName : scoreSection.getKeys(false)) {
                    int scoreInt = scoreSection.getInt(scoreName);
                    ScoreboardHelper.addScore(o, Bukkit.getOfflinePlayer((String)scoreName), scoreInt);
                }
            }
        }
    }

    public static void _saveScoreboards() {
        DenizenAPI.getCurrentInstance().getScoreboards().set("Scoreboards", null);
        for (Map.Entry<String, Scoreboard> scoreboardEntry : scoreboardMap.entrySet()) {
            String id = scoreboardEntry.getKey();
            ArrayList<String> viewerList = new ArrayList<String>();
            for (Map.Entry<String, String> viewerEntry : viewerMap.entrySet()) {
                if (!id.equalsIgnoreCase(viewerEntry.getValue())) continue;
                viewerList.add(viewerEntry.getKey());
            }
            DenizenAPI.getCurrentInstance().getScoreboards().set("Scoreboards." + id + ".Viewers", viewerList);
            for (Objective obj : scoreboardEntry.getValue().getObjectives()) {
                String objPath = "Scoreboards." + id + ".Objectives." + obj.getName();
                DenizenAPI.getCurrentInstance().getScoreboards().set(objPath + ".Criteria", (Object)obj.getCriteria());
                String displaySlot = obj.getDisplaySlot() != null ? obj.getDisplaySlot().name() : "NONE";
                DenizenAPI.getCurrentInstance().getScoreboards().set(objPath + ".Display slot", (Object)displaySlot);
                for (OfflinePlayer player : scoreboardEntry.getValue().getPlayers()) {
                    int score = obj.getScore(player).getScore();
                    if (score == 0) continue;
                    DenizenAPI.getCurrentInstance().getScoreboards().set(objPath + ".Scores." + player.getName(), (Object)score);
                }
            }
        }
    }

    public static void addScore(Objective o, OfflinePlayer player, int score) {
        Score sc = o.getScore(player);
        if (score == 0) {
            sc.setScore(1);
            sc.setScore(0);
        } else {
            sc.setScore(score);
        }
    }

    public static void removeScore(Objective o, OfflinePlayer player) {
        Scoreboard board = o.getScoreboard();
        HashMap<String, Integer> scoreMap = new HashMap<String, Integer>();
        for (Score score : board.getScores(player)) {
            if (score.getObjective().equals(o)) continue;
            scoreMap.put(score.getObjective().getName(), score.getScore());
        }
        board.resetScores(player);
        for (Map.Entry entry : scoreMap.entrySet()) {
            board.getObjective((String)entry.getKey()).getScore(player).setScore(((Integer)entry.getValue()).intValue());
        }
    }

    public static void clearScoreboard(Scoreboard board) {
        for (Objective o : board.getObjectives()) {
            o.unregister();
        }
    }

    public static Scoreboard createScoreboard() {
        Scoreboard board = manager.getNewScoreboard();
        return board;
    }

    public static Scoreboard createScoreboard(String id) {
        Scoreboard board = manager.getNewScoreboard();
        scoreboardMap.put(id.toUpperCase(), board);
        return board;
    }

    public static void deleteScoreboard(String id) {
        if (id.equalsIgnoreCase("main")) {
            ScoreboardHelper.clearScoreboard(ScoreboardHelper.getMain());
        } else {
            ScoreboardHelper.clearScoreboard(ScoreboardHelper.getScoreboard(id));
            scoreboardMap.remove(id.toUpperCase());
        }
    }

    public static Scoreboard getMain() {
        return manager.getMainScoreboard();
    }

    public static Scoreboard getScoreboard(String id) {
        return scoreboardMap.get(id.toUpperCase());
    }

    public static boolean hasScoreboard(String id) {
        return scoreboardMap.containsKey(id.toUpperCase());
    }

    public static void removePlayer(String id, OfflinePlayer player) {
        scoreboardMap.get(id.toUpperCase()).resetScores(player);
    }
}

