/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.events.ScriptReloadEvent;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizen.scripts.containers.core.WorldScriptContainer;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.ScoreboardHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Position;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.SheepDyeWoolEvent;
import org.bukkit.event.entity.SheepRegrowWoolEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldScriptHelper
implements Listener {
    public static Map<String, WorldScriptContainer> world_scripts = new ConcurrentHashMap<String, WorldScriptContainer>(8, 0.9f, 1);
    public static Map<UUID, dEntity> entityKillers = new HashMap<UUID, dEntity>();
    public static Map<String, List<WorldScriptContainer>> events = new HashMap<String, List<WorldScriptContainer>>();
    private final Map<String, Integer> current_time = new HashMap<String, Integer>();

    public WorldScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @EventHandler
    public void scanWorldEvents(ScriptReloadEvent event) {
        for (WorldScriptContainer script : world_scripts.values()) {
            if (script == null || !script.contains("EVENTS")) continue;
            for (String eventName : script.getConfigurationSection("EVENTS").getKeys(false)) {
                List<Object> list = events.containsKey(eventName) ? events.get(eventName) : new ArrayList();
                list.add(script);
                events.put(eventName, list);
            }
        }
    }

    public static List<String> trimEvents(List<String> event) {
        ArrayList<String> parsed = new ArrayList<String>();
        for (String e : event) {
            if (!events.containsKey("ON " + e.toUpperCase())) continue;
            parsed.add(e);
        }
        return parsed;
    }

    public static List<String> addAlternates(List<String> events) {
        HashSet<String> newEvents = new HashSet<String>();
        for (String event : events) {
            if (!event.matches(".*?[a-z]{1,2}@[\\w ]+")) continue;
            newEvents.add(event.replaceAll("[a-z]{1,2}@", ""));
        }
        ArrayList<String> finalEvents = new ArrayList<String>();
        finalEvents.addAll(events);
        finalEvents.addAll(newEvents);
        return finalEvents;
    }

    public static String doEvents(List<String> eventNames, dNPC npc, Player player, Map<String, dObject> context, boolean usesIdentifiers) {
        return WorldScriptHelper.doEvents(usesIdentifiers ? WorldScriptHelper.addAlternates(eventNames) : eventNames, npc, player, context);
    }

    public static String doEvents(List<String> eventNames, dNPC npc, Player player, Map<String, dObject> context) {
        String determination = "none";
        if (dB.showEventsFiring) {
            dB.echoApproval("Fired world events for '" + eventNames.toString() + '\'');
        }
        for (String eventName : eventNames) {
            if (!events.containsKey("ON " + eventName.toUpperCase())) continue;
            for (WorldScriptContainer script : events.get("ON " + eventName.toUpperCase())) {
                List<ScriptEntry> entries;
                if (script == null || (entries = script.getEntries(player != null ? new dPlayer((OfflinePlayer)player) : null, npc, "events.on " + eventName)).isEmpty()) continue;
                dB.report(script, "Event", aH.debugObj("Type", "on " + eventName) + script.getAsScriptArg().debug() + (npc != null ? aH.debugObj("NPC", npc.toString()) : "") + (player != null ? aH.debugObj("Player", player.getName()) : "") + (context != null ? aH.debugObj("Context", context.toString()) : ""));
                dB.echoDebug(script, dB.DebugElement.Header, "Building event 'ON " + eventName.toUpperCase() + "' for " + script.getName());
                long id = DetermineCommand.getNewId();
                ScriptBuilder.addObjectToEntries(entries, "ReqId", id);
                ScriptQueue queue = InstantQueue.getQueue(null).addEntries(entries);
                if (context != null) {
                    for (Map.Entry<String, dObject> entry : context.entrySet()) {
                        queue.addContext(entry.getKey(), entry.getValue());
                    }
                }
                queue.start();
                if (!DetermineCommand.hasOutcome(id)) continue;
                determination = DetermineCommand.getOutcome(id);
            }
        }
        return determination;
    }

    @EventHandler
    public void blockBreak(BlockBreakEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Block block = event.getBlock();
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        dItem item = new dItem(event.getPlayer().getItemInHand());
        List<String> events = new ArrayList<String>();
        events.add("player breaks block");
        events.add("player breaks " + material.identify());
        events.add("player breaks block with " + item.identify());
        events.add("player breaks " + material.identify() + " with " + item.identify());
        events.add("player breaks block with " + item.identifyMaterial());
        events.add("player breaks " + material.identify() + " with " + item.identifyMaterial());
        List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(event.getBlock().getLocation());
        if (cuboids.size() > 0) {
            dList cuboid_context = new dList();
            for (dCuboid cuboid : cuboids) {
                events.add("player breaks block in " + cuboid.identify());
                events.add("player breaks " + material.identify() + " in " + cuboid.identify());
                events.add("player breaks " + material.identify() + " with " + item.identify() + " in " + cuboid.identify());
                events.add("player breaks " + material.identify() + " with " + item.identifyMaterial() + " in " + cuboid.identify());
                events.add("player breaks block in cuboid");
                events.add("player breaks " + material.identify() + " in cuboid");
                events.add("player breaks " + material.identify() + " with " + item.identify() + " in cuboid");
                events.add("player breaks " + material.identify() + " with " + item.identifyMaterial() + " in cuboid");
                cuboid_context.add(cuboid.identify());
            }
            context.put("cuboids", cuboid_context);
        }
        if ((events = WorldScriptHelper.trimEvents(events)).size() == 0) {
            return;
        }
        context.put("location", new dLocation(block.getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (determination.toUpperCase().startsWith("NOTHING")) {
            event.setCancelled(true);
            block.setType(Material.AIR);
        } else if (aH.Argument.valueOf(determination).matchesArgumentList(dItem.class)) {
            List<dObject> list;
            event.setCancelled(true);
            block.setType(Material.AIR);
            List<dObject> newItems = list = dList.valueOf(determination).filter(dItem.class);
            for (dItem dItem2 : newItems) {
                block.getWorld().dropItemNaturally(block.getLocation(), dItem2.getItemStack());
            }
        }
    }

    @EventHandler
    public void blockBurn(BlockBurnEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getBlock().getLocation()));
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block burns", material.identify() + " burns"), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockCanBuild(BlockCanBuildEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial oldMaterial = dMaterial.getMaterialFrom(event.getBlock().getType());
        dMaterial newMaterial = dMaterial.getMaterialFrom(event.getMaterial());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("old_material", oldMaterial);
        context.put("new_material", newMaterial);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block being built", "block being built on " + oldMaterial.identify(), newMaterial.identify() + " being built", newMaterial.identify() + " being built on " + oldMaterial.identify()), null, null, context, true);
        if (determination.toUpperCase().startsWith("BUILDABLE")) {
            event.setBuildable(true);
        }
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setBuildable(false);
        }
    }

    @EventHandler
    public void blockDamage(BlockDamageEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        List<String> events = new ArrayList<String>();
        List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(event.getBlock().getLocation());
        if (cuboids.size() > 0) {
            dList cuboid_context = new dList();
            for (dCuboid cuboid : cuboids) {
                events.add("player damages block in " + cuboid.identify());
                events.add("player damages " + material.identify() + " in " + cuboid.identify());
                cuboid_context.add(cuboid.identify());
            }
            context.put("cuboids", cuboid_context);
        }
        events.add("player damages block");
        events.add("player damages " + material.identify());
        events = WorldScriptHelper.trimEvents(events);
        if (events.size() == 0) {
            return;
        }
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (determination.toUpperCase().startsWith("INSTABREAK")) {
            event.setInstaBreak(true);
        }
    }

    @EventHandler
    public void blockDispense(BlockDispenseEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getItem());
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("item", item);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block dispenses item", "block dispenses " + item.identify(), material.identify() + " dispenses item", material.identify() + " dispenses " + item.identify()), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Double)) {
            event.setVelocity(event.getVelocity().normalize().multiply(aH.getDoubleFrom(determination)));
        }
    }

    @EventHandler
    public void blockFade(BlockFadeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block fades", material.identify() + " fades"), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockForm(BlockFormEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block forms", material.identify() + " forms"), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockFromTo(BlockFromToEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("destination", new dLocation(event.getToBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("liquid spreads", material.identify() + " spreads"), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockGrow(BlockGrowEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block grows", material.identify() + " grows"), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockIgnite(BlockIgniteEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block ignites", material.identify() + " ignites"), null, event.getPlayer(), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockPistonExtend(BlockPistonExtendEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        context.put("length", new Element(event.getLength()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("piston extends", material.identify() + " extends"), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockPistonRetract(BlockPistonRetractEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("retract_location", new dLocation(event.getRetractLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("piston retracts", material.identify() + " retracts"), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockPlace(BlockPlaceEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        List<String> events = new ArrayList<String>();
        List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(event.getBlock().getLocation());
        if (cuboids.size() > 0) {
            dList cuboid_context = new dList();
            for (dCuboid cuboid : cuboids) {
                events.add("player places block in " + cuboid.identify());
                events.add("player places " + material.identify() + " in " + cuboid.identify());
                cuboid_context.add(cuboid.identify());
            }
            context.put("cuboids", cuboid_context);
        }
        events.add("player places block");
        events.add("player places " + material.identify());
        events = WorldScriptHelper.trimEvents(events);
        if (events.size() == 0) {
            return;
        }
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockSpread(BlockSpreadEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block spreads", material.identify() + " spreads"), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void brew(BrewEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("inventory", new dInventory((Inventory)event.getContents()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("brewing stand brews"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityBlockForm(EntityBlockFormEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        dEntity entity = new dEntity(event.getEntity());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        context.put("entity", entity.getDenizenObject());
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity forms block", "entity forms " + material.identify(), entity.identifyType() + " forms block", entity.identifyType() + " forms " + material.identify()), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void furnaceBurn(FurnaceBurnEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getFuel());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("item", item);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("furnace burns item", "furnace burns " + item.identify()), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Integer)) {
            event.setBurnTime(aH.getIntegerFrom(determination));
        }
    }

    @EventHandler
    public void furnaceExtract(FurnaceExtractEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial itemMaterial = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        dItem item = new dItem(itemMaterial, event.getItemAmount());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("item", item);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player takes item from furnace", "player takes " + item.identify() + " from furnace", "player takes " + item.identifyMaterial() + " from furnace"), null, event.getPlayer(), context, true);
        if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Integer)) {
            event.setExpToDrop(aH.getIntegerFrom(determination));
        }
    }

    @EventHandler
    public void furnaceSmelt(FurnaceSmeltEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem source = new dItem(event.getSource());
        dItem result = new dItem(event.getResult());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("source_item", source);
        context.put("result_item", result);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("furnace smelts item", "furnace smelts " + source.identify(), "furnace smelts item into " + result.identify(), "furnace smelts " + source.identify() + " into " + result.identify()), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (dItem.matches(determination)) {
            event.setResult(dItem.valueOf(determination).getItemStack());
        }
    }

    @EventHandler
    public void leavesDecay(LeavesDecayEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("leaves decay", material.identify() + " decay"), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void signChange(SignChangeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (block == null || !(block.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        dMaterial material = dMaterial.getMaterialFrom(block.getType(), block.getData());
        context.put("old", new dList(Arrays.asList(sign.getLines())));
        context.put("new", new dList(Arrays.asList(event.getLines())));
        context.put("location", new dLocation(block.getLocation()));
        context.put("material", material);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player changes sign", "player changes " + material.identify()), null, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    public void serverStartEvent() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                WorldScriptHelper.this.timeEvent();
            }
        }, Settings.WorldScriptTimeEventFrequency().getTicks(), Settings.WorldScriptTimeEventFrequency().getTicks());
        String determination = WorldScriptHelper.doEvents(Arrays.asList("server start"), null, null, null);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            Bukkit.getServer().shutdown();
        }
    }

    public void timeEvent() {
        for (World world : Bukkit.getWorlds()) {
            dWorld currentWorld;
            int hour = Double.valueOf(world.getTime() / 1000L).intValue();
            if ((hour += 6) >= 24) {
                hour -= 24;
            }
            if (this.current_time.containsKey((currentWorld = new dWorld(world)).identify()) && this.current_time.get(currentWorld.identify()) == hour) continue;
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            context.put("time", new Element(hour));
            context.put("world", currentWorld);
            WorldScriptHelper.doEvents(Arrays.asList("time changes in " + currentWorld.identify(), String.valueOf(hour) + ":00 in " + currentWorld.identify(), "time " + String.valueOf(hour) + " in " + currentWorld.identify()), null, null, context, true);
            this.current_time.put(currentWorld.identify(), hour);
        }
    }

    @EventHandler
    public void hangingBreak(HangingBreakEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity hanging = new dEntity((Entity)event.getEntity());
        String cause = event.getCause().name();
        List<String> events = new ArrayList<String>();
        events.add("hanging breaks");
        events.add("hanging breaks because " + cause);
        events.add(hanging.identifyType() + " breaks");
        events.add(hanging.identifyType() + " breaks because " + cause);
        if (event instanceof HangingBreakByEntityEvent) {
            HangingBreakByEntityEvent subEvent = (HangingBreakByEntityEvent)event;
            dEntity entity = new dEntity(subEvent.getRemover());
            context.put("entity", entity.getDenizenObject());
            if (entity.isNPC()) {
                npc = entity.getDenizenNPC();
            } else if (entity.isPlayer()) {
                player = entity.getPlayer();
            }
            List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(event.getEntity().getLocation());
            if (cuboids.size() > 0) {
                dList cuboid_context = new dList();
                for (dCuboid cuboid : cuboids) {
                    events.add(entity.identifyType() + " breaks " + hanging.identifyType() + " in " + cuboid.identify());
                    cuboid_context.add(cuboid.identify());
                }
                context.put("cuboids", cuboid_context);
            }
            events.add("entity breaks hanging");
            events.add("entity breaks hanging because " + cause);
            events.add("entity breaks " + hanging.identifyType());
            events.add("entity breaks " + hanging.identifyType() + " because " + cause);
            events.add(entity.identifyType() + " breaks hanging");
            events.add(entity.identifyType() + " breaks hanging because " + cause);
            events.add(entity.identifyType() + " breaks " + hanging.identifyType());
            events.add(entity.identifyType() + " breaks " + hanging.identifyType() + " because " + cause);
        }
        if ((events = WorldScriptHelper.trimEvents(events)).size() == 0) {
            return;
        }
        context.put("hanging", hanging);
        context.put("cause", new Element(cause));
        String determination = WorldScriptHelper.doEvents(events, npc, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void hangingPlace(HangingPlaceEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity hanging = new dEntity((Entity)event.getEntity());
        context.put("hanging", hanging);
        context.put("location", new dLocation(event.getBlock().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player places hanging", "player places " + hanging.identifyType()), null, event.getPlayer(), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void creatureSpawn(CreatureSpawnEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        String reason = event.getSpawnReason().name();
        context.put("entity", entity);
        context.put("reason", new Element(reason));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity spawns", "entity spawns because " + event.getSpawnReason().name(), entity.identifyType() + " spawns", entity.identifyType() + " spawns because " + reason), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void creeperPower(CreeperPowerEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        dEntity lightning = new dEntity((Entity)event.getLightning());
        String cause = event.getCause().name();
        context.put("entity", entity);
        context.put("lightning", lightning);
        context.put("cause", new Element(cause));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("creeper powered", "creeper powered because " + cause), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityChangeBlock(EntityChangeBlockEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        dMaterial oldMaterial = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        dMaterial newMaterial = dMaterial.getMaterialFrom(event.getTo());
        context.put("entity", entity.getDenizenObject());
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("old_material", oldMaterial);
        context.put("new_material", newMaterial);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity changes block", "entity changes " + oldMaterial.identify(), "entity changes block into " + newMaterial.identify(), "entity changes " + oldMaterial.identify() + " into " + newMaterial.identify(), entity.identifyType() + " changes block", entity.identifyType() + " changes " + oldMaterial.identify(), entity.identifyType() + " changes block into " + newMaterial.identify(), entity.identifyType() + " changes " + oldMaterial.identify() + " into " + newMaterial.identify()), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityCombust(EntityCombustEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Entity entity = event.getEntity();
        context.put("entity", new dEntity(entity).getDenizenObject());
        context.put("duration", new Duration((long)event.getDuration()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity combusts", entity.getType().name() + " combusts"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityDamage(EntityDamageEvent event) {
        String determination;
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        String cause = event.getCause().name();
        context.put("entity", entity.getDenizenObject());
        context.put("damage", new Element(event.getDamage()));
        context.put("cause", new Element(event.getCause().name()));
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        boolean isFatal = false;
        if (entity.isValid() && entity.isLivingEntity() && event.getDamage() >= entity.getLivingEntity().getHealth()) {
            isFatal = true;
        }
        ArrayList<String> events = new ArrayList<String>();
        events.add("entity damaged");
        events.add("entity damaged by " + cause);
        events.add(entity.identifyType() + " damaged");
        events.add(entity.identifyType() + " damaged by " + cause);
        if (isFatal) {
            events.add("entity killed");
            events.add("entity killed by " + cause);
            events.add(entity.identifyType() + " killed");
            events.add(entity.identifyType() + " killed by " + cause);
        }
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent subEvent = (EntityDamageByEntityEvent)event;
            Player subPlayer = null;
            dNPC subNPC = null;
            dEntity projectile = null;
            dEntity damager = new dEntity(subEvent.getDamager());
            if (damager.isProjectile()) {
                projectile = damager;
                context.put("projectile", projectile);
                if (damager.hasShooter()) {
                    damager = damager.getShooter();
                }
                if (!damager.getEntityType().equals((Object)projectile.getEntityType())) {
                    events.add("entity damaged by " + projectile.identifyType());
                    events.add(entity.identifyType() + " damaged by " + projectile.identifyType());
                }
            }
            context.put("damager", damager.getDenizenObject());
            events.add("entity damaged by entity");
            events.add("entity damaged by " + damager.identifyType());
            events.add(entity.identifyType() + " damaged by entity");
            events.add(entity.identifyType() + " damaged by " + damager.identifyType());
            if (damager.isNPC()) {
                subNPC = damager.getDenizenNPC();
                if (npc == null) {
                    npc = subNPC;
                }
            } else if (damager.isPlayer()) {
                subPlayer = damager.getPlayer();
                if (player == null) {
                    player = subPlayer;
                }
            }
            ArrayList<String> subEvents = new ArrayList<String>();
            subEvents.add("entity damages entity");
            subEvents.add("entity damages " + entity.identifyType());
            subEvents.add(damager.identifyType() + " damages entity");
            subEvents.add(damager.identifyType() + " damages " + entity.identifyType());
            if (projectile != null && !damager.getEntityType().equals((Object)projectile.getEntityType())) {
                subEvents.add(projectile.identifyType() + " damages entity");
                subEvents.add(projectile.identifyType() + " damages " + entity.identifyType());
            }
            if (isFatal) {
                if (!entityKillers.containsKey(entity.getUUID())) {
                    entityKillers.put(entity.getUUID(), damager);
                }
                events.add("entity killed by entity");
                events.add("entity killed by " + damager.identifyType());
                events.add(entity.identifyType() + " killed by entity");
                events.add(entity.identifyType() + " killed by " + damager.identifyType());
                if (projectile != null && !damager.getEntityType().equals((Object)projectile.getEntityType())) {
                    events.add("entity killed by " + projectile.identifyType());
                    events.add(entity.identifyType() + " killed by " + projectile.identifyType());
                }
                subEvents.add("entity kills entity");
                subEvents.add("entity kills " + entity.identifyType());
                subEvents.add(damager.identifyType() + " kills entity");
                subEvents.add(damager.identifyType() + " kills " + entity.identifyType());
                if (projectile != null && !damager.getEntityType().equals((Object)projectile.getEntityType())) {
                    subEvents.add(projectile.identifyType() + " kills entity");
                    subEvents.add(projectile.identifyType() + " kills " + entity.identifyType());
                }
            }
            if ((determination = WorldScriptHelper.doEvents(subEvents, subNPC, subPlayer, context, true)).toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Double)) {
                event.setDamage(aH.getDoubleFrom(determination));
            }
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, player, context, true)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Double)) {
            event.setDamage(aH.getDoubleFrom(determination));
        }
    }

    @EventHandler
    public void entityDeath(EntityDeathEvent event) {
        String determination;
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        if (entityKillers.containsKey(entity.getUUID())) {
            context.put("damager", entityKillers.get(entity.getUUID()));
            entityKillers.remove(entity.getUUID());
        }
        PlayerDeathEvent subEvent = null;
        if (event instanceof PlayerDeathEvent) {
            subEvent = (PlayerDeathEvent)event;
            context.put("message", new Element(subEvent.getDeathMessage()));
            if (player != null) {
                context.put("inventory", new dInventory((Inventory)player.getInventory()));
            }
        }
        if ((determination = WorldScriptHelper.doEvents(Arrays.asList("entity dies", entity.identifyType() + " dies", "entity death", entity.identifyType() + " death"), npc, player, context, true)).equalsIgnoreCase("NO_DROPS")) {
            event.getDrops().clear();
        } else if (determination.toUpperCase().startsWith("DROPS ")) {
            dList drops = dList.valueOf(determination.substring(6));
            drops.filter(dItem.class);
            event.getDrops().clear();
            for (String drop : drops) {
                dItem item = dItem.valueOf(drop);
                if (item == null) continue;
                event.getDrops().add(item.getItemStack());
            }
        } else if (!determination.equalsIgnoreCase("NONE") && event instanceof PlayerDeathEvent) {
            subEvent.setDeathMessage(determination);
        }
    }

    @EventHandler
    public void entityExplode(EntityExplodeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        if (event.getEntity() == null) {
            return;
        }
        dEntity entity = new dEntity(event.getEntity());
        context.put("entity", entity.getDenizenObject());
        context.put("location", new dLocation(event.getLocation()));
        String blocks = "";
        for (Block block : event.blockList()) {
            blocks = blocks + new dLocation(block.getLocation()) + "|";
        }
        context.put("blocks", blocks.length() > 0 ? new dList(blocks) : null);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity explodes", entity.identifyType() + " explodes"), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityRegainHealth(EntityRegainHealthEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        String reason = event.getRegainReason().name();
        context.put("reason", new Element(event.getRegainReason().name()));
        context.put("amount", new Element(event.getAmount()));
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity heals", "entity heals because " + reason, entity.identifyType() + " heals", entity.identifyType() + " heals because " + reason), npc, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Double)) {
            event.setAmount(aH.getDoubleFrom(determination));
        }
    }

    @EventHandler
    public void entityPortalEnter(EntityPortalEnterEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        context.put("location", new dLocation(event.getLocation()));
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        WorldScriptHelper.doEvents(Arrays.asList("entity enters portal", entity.identifyType() + " enters portal"), npc, player, context, true);
    }

    @EventHandler
    public void entityPortalExit(EntityPortalExitEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        context.put("location", new dLocation(event.getTo()));
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        WorldScriptHelper.doEvents(Arrays.asList("entity exits portal", entity.identifyType() + " exits portal"), npc, player, context, true);
    }

    @EventHandler
    public void entityShootBow(EntityShootBowEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Player player = null;
        dNPC npc = null;
        dItem bow = new dItem(event.getBow());
        dEntity projectile = new dEntity(event.getProjectile());
        dEntity entity = new dEntity((Entity)event.getEntity());
        context.put("bow", bow);
        context.put("projectile", projectile);
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity shoots bow", "entity shoots " + bow.identify(), entity.identifyType() + " shoots bow", entity.identifyType() + " shoots " + bow.identify()), npc, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesArgumentList(dEntity.class)) {
            List<dObject> list;
            event.setCancelled(true);
            List<dObject> newProjectiles = list = dList.valueOf(determination).filter(dEntity.class);
            for (dEntity dEntity2 : newProjectiles) {
                dEntity2.spawnAt(projectile.getLocation());
                if (!dEntity2.isProjectile()) continue;
                dEntity2.setShooter(entity);
            }
            Position.mount(Conversion.convertEntities(newProjectiles));
            Entity lastProjectile = ((dEntity)newProjectiles.get(newProjectiles.size() - 1)).getBukkitEntity();
            lastProjectile.setVelocity(projectile.getVelocity());
        }
    }

    @EventHandler
    public void entityTame(EntityTameEvent event) {
        String determination;
        Player player = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        context.put("entity", entity);
        ArrayList<String> events = new ArrayList<String>();
        events.add("entity tamed");
        events.add(entity.identifyType() + " tamed");
        if (event.getOwner() instanceof Player) {
            player = (Player)event.getOwner();
            events.add("player tames entity");
            events.add("player tames " + entity.identifyType());
        }
        if ((determination = WorldScriptHelper.doEvents(events, null, player, context, true)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityTarget(EntityTargetEvent event) {
        String determination;
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        final dEntity entity = new dEntity(event.getEntity());
        String reason = event.getReason().name();
        context.put("entity", entity);
        context.put("reason", new Element(reason));
        ArrayList<String> events = new ArrayList<String>();
        events.add("entity targets");
        events.add("entity targets because " + reason);
        events.add(entity.identifyType() + " targets");
        events.add(entity.identifyType() + " targets because " + reason);
        if (event.getTarget() != null) {
            dEntity target = new dEntity(event.getTarget());
            context.put("target", target.getDenizenObject());
            if (target.isNPC()) {
                npc = target.getDenizenNPC();
            } else if (target.isPlayer()) {
                player = target.getPlayer();
            }
            events.add("entity targets entity");
            events.add("entity targets entity because " + reason);
            events.add("entity targets " + target.identifyType());
            events.add("entity targets " + target.identifyType() + " because " + reason);
            events.add(entity.identifyType() + " targets entity");
            events.add(entity.identifyType() + " targets entity because " + reason);
            events.add(entity.identifyType() + " targets " + target.identifyType());
            events.add(entity.identifyType() + " targets " + target.identifyType() + " because " + reason);
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, player, context, true)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (dEntity.matches(determination)) {
            final dEntity newTarget = dEntity.valueOf(determination);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    entity.target(newTarget.getLivingEntity());
                }
            }, 1L);
        }
    }

    @EventHandler
    public void entityTeleport(EntityTeleportEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        context.put("origin", new dLocation(event.getFrom()));
        context.put("destination", new dLocation(event.getTo()));
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity teleports", entity.identifyType() + " teleports"), npc, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityUnleash(EntityUnleashEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        String reason = event.getReason().name();
        context.put("entity", entity.getDenizenObject());
        context.put("reason", new Element(reason));
        WorldScriptHelper.doEvents(Arrays.asList("entity unleashed", "entity unleashed because " + reason, entity.identifyType() + " unleashed", entity.identifyType() + " unleashed because " + reason), null, null, context, true);
    }

    @EventHandler
    public void explosionPrimeEvent(ExplosionPrimeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Entity entity = event.getEntity();
        context.put("entity", new dEntity(entity));
        context.put("radius", new Element(Float.valueOf(event.getRadius())));
        context.put("fire", new Element(event.getFire()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity explosion primes", entity.getType().name() + " explosion primes"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void foodLevelChange(FoodLevelChangeEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        context.put("food", new Element(event.getFoodLevel()));
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity changes food level", entity.identifyType() + " changes food level"), npc, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Integer)) {
            event.setFoodLevel(aH.getIntegerFrom(determination));
        }
    }

    @EventHandler
    public void horseJump(HorseJumpEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        String variant = event.getEntity().getVariant().name();
        String color = event.getEntity().getColor().name();
        dEntity entity = new dEntity((Entity)event.getEntity());
        context.put("variant", new Element(variant));
        context.put("color", new Element(color));
        context.put("power", new Element(Float.valueOf(event.getPower())));
        context.put("entity", entity);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("horse jumps", variant + " jumps", color + " jumps", color + " " + variant + " jumps"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Float)) {
            event.setPower(aH.getFloatFrom(determination));
        }
    }

    @EventHandler
    public void itemDespawn(ItemDespawnEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getEntity().getItemStack());
        context.put("item", item);
        context.put("entity", new dEntity((Entity)event.getEntity()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("item despawns");
        events.add(item.identify() + " despawns");
        events.add(item.identifyMaterial() + " despawns");
        String determination = WorldScriptHelper.doEvents(events, null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void itemSpawn(ItemSpawnEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getEntity().getItemStack());
        context.put("item", item);
        context.put("entity", new dEntity((Entity)event.getEntity()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("item spawns");
        events.add(item.identify() + " spawns");
        events.add(item.identifyMaterial() + " spawns");
        String determination = WorldScriptHelper.doEvents(events, null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void pigZap(PigZapEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity pig = new dEntity((Entity)event.getEntity());
        dEntity pigZombie = new dEntity((Entity)event.getPigZombie());
        dEntity lightning = new dEntity((Entity)event.getLightning());
        context.put("pig", pig);
        context.put("pig_zombie", pigZombie);
        context.put("lightning", lightning);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("pig zapped"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void projectileHit(ProjectileHitEvent event) {
        Player player = null;
        dNPC npc = null;
        if (event.getEntity() == null) {
            return;
        }
        dEntity projectile = new dEntity((Entity)event.getEntity());
        if (projectile.getLocation() == null) {
            return;
        }
        Block block = null;
        BlockIterator bi = new BlockIterator(projectile.getLocation().getWorld(), projectile.getLocation().toVector(), projectile.getLocation().getDirection().normalize(), 0.0, 4);
        while (bi.hasNext() && (block = bi.next()).getTypeId() == 0) {
        }
        if (block == null) {
            return;
        }
        dEntity shooter = projectile.getShooter();
        dMaterial material = dMaterial.getMaterialFrom(block.getType(), block.getData());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("projectile", projectile);
        context.put("location", new dLocation(block.getLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("projectile hits block");
        events.add("projectile hits " + material.identify());
        events.add(projectile.identifyType() + " hits block");
        events.add(projectile.identifyType() + " hits " + material.identify());
        if (shooter != null) {
            context.put("shooter", shooter.getDenizenObject());
            if (shooter.isNPC()) {
                npc = shooter.getDenizenNPC();
            } else if (shooter.isPlayer()) {
                player = shooter.getPlayer();
            }
            events.add("entity shoots block");
            events.add("entity shoots block with " + projectile.identifyType());
            events.add("entity shoots " + material.identify() + " with " + projectile.identifyType());
            events.add(shooter.identifyType() + " shoots block");
            events.add(shooter.identifyType() + " shoots block with " + projectile.identifyType());
            events.add(shooter.identifyType() + " shoots " + material.identify() + " with " + projectile.identifyType());
        }
        WorldScriptHelper.doEvents(events, npc, player, context, true);
    }

    @EventHandler
    public void sheepDyeWool(SheepDyeWoolEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        String color = event.getColor().name();
        context.put("entity", entity);
        context.put("color", new Element(color));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player dyes sheep", "player dyes sheep " + color, "sheep dyed", "sheep dyed " + color), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (determination.equals(determination.toUpperCase())) {
            try {
                event.setColor(DyeColor.valueOf((String)determination));
            }
            catch (IllegalArgumentException e) {
                dB.echoError("Unknown dye color " + determination);
            }
        }
    }

    @EventHandler
    public void sheepRegrowWool(SheepRegrowWoolEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        context.put("entity", entity);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("sheep regrows wool"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void slimeSplit(SlimeSplitEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        int count = event.getCount();
        context.put("entity", entity);
        context.put("count", new Element(count));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("slime splits", "slime splits into " + count), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Integer)) {
            event.setCount(aH.getIntegerFrom(determination));
        }
    }

    @EventHandler
    public void enchantItemEvent(EnchantItemEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Player player = event.getEnchanter();
        dItem item = new dItem(event.getItem());
        context.put("location", new dLocation(event.getEnchantBlock().getLocation()));
        context.put("inventory", new dInventory(event.getInventory()));
        context.put("item", item);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("item enchanted", item.identify() + " enchanted"), null, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void inventoryClickEvent(InventoryClickEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = null;
        Player player = (Player)event.getWhoClicked();
        String type = event.getInventory().getType().name();
        String click = event.getClick().name();
        String slotType = event.getSlotType().name();
        List<String> events = new ArrayList<String>();
        events.add("player clicks in inventory");
        events.add("player clicks in " + type);
        String interaction = "player " + click + " clicks";
        events.add(interaction + " in inventory");
        events.add(interaction + " in " + type);
        if (event.getCurrentItem() != null) {
            item = new dItem(event.getCurrentItem());
            events.add("player clicks " + item.identify() + " in inventory");
            events.add(interaction + item.identify() + " in inventory");
            events.add(interaction + item.identify() + " in " + type);
            events.add("player clicks " + item.identifyMaterial() + " in inventory");
            events.add(interaction + item.identifyMaterial() + " in inventory");
            events.add(interaction + item.identifyMaterial() + " in " + type);
        }
        if ((events = WorldScriptHelper.trimEvents(events)).size() == 0) {
            return;
        }
        context.put("item", item);
        context.put("inventory", new dInventory(event.getInventory()));
        context.put("click", new Element(click));
        context.put("slot_type", new Element(slotType));
        String determination = WorldScriptHelper.doEvents(events, null, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void inventoryCloseEvent(InventoryCloseEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Player player = (Player)event.getPlayer();
        String type = event.getInventory().getType().name();
        context.put("inventory", new dInventory(event.getInventory()));
        WorldScriptHelper.doEvents(Arrays.asList("player closes inventory", "player closes " + type), null, player, context);
    }

    @EventHandler
    public void inventoryDragEvent(InventoryDragEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = null;
        Player player = (Player)event.getWhoClicked();
        String type = event.getInventory().getType().name();
        List<String> events = new ArrayList<String>();
        events.add("player drags");
        events.add("player drags in inventory");
        events.add("player drags in " + type);
        if (event.getOldCursor() != null) {
            item = new dItem(event.getOldCursor());
            events.add("player drags " + item.identify());
            events.add("player drags " + item.identify() + " in inventory");
            events.add("player drags " + item.identify() + " in " + type);
            events.add("player drags " + item.identifyMaterial());
            events.add("player drags " + item.identifyMaterial() + " in inventory");
            events.add("player drags " + item.identifyMaterial() + " in " + type);
        }
        if ((events = WorldScriptHelper.trimEvents(events)).size() == 0) {
            return;
        }
        context.put("item", item);
        context.put("inventory", new dInventory(event.getInventory()));
        String determination = WorldScriptHelper.doEvents(events, null, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void inventoryMoveItemEvent(InventoryMoveItemEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getItem());
        String originType = event.getSource().getType().name();
        String destinationType = event.getDestination().getType().name();
        List<String> events = Arrays.asList("item moves from inventory", "item moves from " + originType, "item moves from " + originType + " to " + destinationType, item.identify() + " moves from inventory", item.identify() + " moves from " + originType, item.identify() + " moves from " + originType + " to " + destinationType);
        if ((events = WorldScriptHelper.trimEvents(events)).size() == 0) {
            return;
        }
        context.put("origin", new dInventory(event.getSource()));
        context.put("destination", new dInventory(event.getDestination()));
        context.put("initiator", new dInventory(event.getInitiator()));
        context.put("item", item);
        String determination = WorldScriptHelper.doEvents(events, null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (dItem.matches(determination)) {
            event.setItem(dItem.valueOf(determination).getItemStack());
        }
    }

    @EventHandler
    public void inventoryOpenEvent(InventoryOpenEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Player player = (Player)event.getPlayer();
        String type = event.getInventory().getType().name();
        context.put("inventory", new dInventory(event.getInventory()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player opens inventory", "player opens " + type), null, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void inventoryPickupItemEvent(InventoryPickupItemEvent event) {
        if (event.getInventory().getType() == InventoryType.HOPPER) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        String type = event.getInventory().getType().name();
        dItem item = new dItem(event.getItem());
        List<String> events = Arrays.asList("inventory picks up item", "inventory picks up " + item.identify(), type + " picks up item", type + " picks up " + item.identify());
        if ((events = WorldScriptHelper.trimEvents(events)).size() == 0) {
            return;
        }
        dInventory inventory = new dInventory(event.getInventory());
        context.put("inventory", inventory);
        context.put("item", item);
        String determination = WorldScriptHelper.doEvents(events, null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void asyncPlayerChat(final AsyncPlayerChatEvent event) {
        if (!Settings.WorldScriptChatEventAsynchronous()) {
            return;
        }
        final HashMap<String, Element> context = new HashMap<String, Element>();
        context.put("message", new Element(event.getMessage().replace('<', '\u0001').replace('>', '\u0002').replace(String.valueOf('\u0001'), "<&lt>").replace(String.valueOf('\u0002'), "<&gt>").replace("%", "<&pc>")));
        Callable<String> call = new Callable<String>(){

            @Override
            public String call() {
                return WorldScriptHelper.doEvents(Arrays.asList("player chats"), null, event.getPlayer(), context);
            }
        };
        String determination = null;
        try {
            determination = event.isAsynchronous() ? (String)Bukkit.getScheduler().callSyncMethod((Plugin)DenizenAPI.getCurrentInstance(), (Callable)call).get() : (String)call.call();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (determination == null) {
            return;
        }
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (!determination.equals("none")) {
            event.setMessage(determination);
        }
    }

    @EventHandler
    public void playerAnimation(PlayerAnimationEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        String animation = event.getAnimationType().name();
        context.put("animation", new Element(animation));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player animates", "player animates " + animation), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerBedEnter(PlayerBedEnterEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getBed().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player enters bed"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerBedLeave(PlayerBedLeaveEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getBed().getLocation()));
        WorldScriptHelper.doEvents(Arrays.asList("player leaves bed"), null, event.getPlayer(), context);
    }

    @EventHandler
    public void playerBucketEmpty(PlayerBucketEmptyEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("item", new dItem(event.getBucket()));
        context.put("location", new dLocation(event.getBlockClicked().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player empties bucket"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (dItem.matches(determination)) {
            ItemStack is = dItem.valueOf(determination).getItemStack();
            event.setItemStack(is != null ? is : new ItemStack(Material.AIR));
        }
    }

    @EventHandler
    public void playerBucketFill(PlayerBucketFillEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("item", new dItem(event.getBucket()));
        context.put("location", new dLocation(event.getBlockClicked().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player fills bucket"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (dItem.matches(determination)) {
            ItemStack is = dItem.valueOf(determination).getItemStack();
            event.setItemStack(is != null ? is : new ItemStack(Material.AIR));
        }
    }

    @EventHandler
    public void playerChangedWorld(PlayerChangedWorldEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld originWorld = new dWorld(event.getFrom());
        dWorld destinationWorld = new dWorld(event.getPlayer().getWorld());
        context.put("origin_world", originWorld);
        WorldScriptHelper.doEvents(Arrays.asList("player changes world", "player changes world from " + originWorld.identify(), "player changes world to " + destinationWorld.identify(), "player changes world from " + originWorld.identify() + " to " + destinationWorld.identify()), null, event.getPlayer(), context, true);
    }

    @EventHandler
    public void playerChat(PlayerChatEvent event) {
        if (dB.record) {
            dB.log(ChatColor.DARK_GREEN + "CHAT: " + event.getPlayer().getName() + ": " + event.getMessage());
        }
        if (Settings.WorldScriptChatEventAsynchronous()) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(event.getMessage().replace('<', '\u0001').replace('>', '\u0002').replace(String.valueOf('\u0001'), "<&lt>").replace(String.valueOf('\u0002'), "<&gt>").replace("%", "<&pc>")));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player chats"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (!determination.equals("none")) {
            event.setMessage(determination);
        }
    }

    @EventHandler
    public void playerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dPlayer player = dPlayer.valueOf(event.getPlayer().getName());
        String message = event.getMessage().replace('<', '\u0001').replace('>', '\u0002').replace(String.valueOf('\u0001'), "<&lt>").replace(String.valueOf('\u0002'), "<&gt>").replace("%", "<&pc>");
        String command = message.split(" ")[0].replace("/", "").toUpperCase();
        List<String> events = new ArrayList<String>();
        events.add("command");
        events.add(command + " command");
        List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(event.getPlayer().getLocation());
        if (cuboids.size() > 0) {
            dList cuboid_context = new dList();
            for (dCuboid cuboid : cuboids) {
                events.add(command + " command in " + cuboid.identify());
                cuboid_context.add(cuboid.identify());
            }
            context.put("cuboids", cuboid_context);
        }
        if ((events = WorldScriptHelper.trimEvents(events)).size() == 0) {
            return;
        }
        List<String> args = Arrays.asList(aH.buildArgs(message.split(" ").length > 1 ? message.split(" ", 2)[1] : ""));
        List<String> parsed_args = Arrays.asList(aH.buildArgs(event.getMessage().split(" ").length > 1 ? event.getMessage().split(" ", 2)[1] : ""));
        context.put("args", new dList(args));
        context.put("parsed_args", new dList(parsed_args));
        context.put("command", new Element(command));
        context.put("raw_args", new Element(message.split(" ").length > 1 ? message.split(" ", 2)[1] : ""));
        context.put("server", Element.FALSE);
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context).toUpperCase();
        if (determination.equals("FULFILLED") || determination.equals("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerDropItem(PlayerDropItemEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getItemDrop().getItemStack());
        context.put("item", item);
        context.put("entity", new dEntity((Entity)event.getItemDrop()));
        context.put("location", new dLocation(event.getItemDrop().getLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player drops item");
        events.add("player drops " + item.identify());
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerEggThrow(PlayerEggThrowEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity egg = new dEntity((Entity)event.getEgg());
        context.put("egg", egg);
        context.put("is_hatching", new Element(event.isHatching()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player throws egg");
        if (event.isHatching()) {
            events.add("player throws hatching egg");
        } else {
            events.add("player throws non-hatching egg");
        }
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context);
        if (dEntity.matches(determination)) {
            event.setHatching(true);
            event.setHatchingType(dEntity.valueOf(determination).getEntityType());
        }
    }

    @EventHandler
    public void playerFish(PlayerFishEvent event) {
        String determination;
        dNPC npc = null;
        String state = event.getState().name();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("hook", new dEntity((Entity)event.getHook()));
        context.put("state", new Element(state));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player fishes");
        events.add("player fishes while " + state);
        if (event.getCaught() != null) {
            dEntity entity = new dEntity(event.getCaught());
            context.put("entity", entity.getDenizenObject());
            if (entity.isNPC()) {
                npc = entity.getDenizenNPC();
            }
            events.add("player fishes " + entity.identifyType());
            events.add("player fishes " + entity.identifyType() + " while " + state);
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, event.getPlayer(), context, true)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerGameModeChange(PlayerGameModeChangeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("gamemode", new Element(event.getNewGameMode().name()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player changes gamemode", "player changes gamemode to " + event.getNewGameMode().name()), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerInteract(PlayerInteractEvent event) {
        String determination;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Action action = event.getAction();
        dItem item = null;
        ArrayList<String> events = new ArrayList<String>();
        String interaction = action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK ? "player left clicks" : (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK ? "player right clicks" : "player stands on");
        events.add(interaction);
        if (event.hasItem()) {
            item = new dItem(event.getItem());
            context.put("item", item);
            events.add(interaction + " with item");
            events.add(interaction + " with " + item.identify());
            events.add(interaction + " with " + item.identifyMaterial());
        }
        if (event.hasBlock()) {
            List<dCuboid> cuboids;
            Block block = event.getClickedBlock();
            dMaterial blockMaterial = dMaterial.getMaterialFrom(block.getType(), block.getData());
            context.put("location", new dLocation(block.getLocation()));
            events.add(interaction + " block");
            events.add(interaction + " " + blockMaterial.identify());
            if (event.hasItem()) {
                events.add(interaction + " block with item");
                events.add(interaction + " block with " + item.identify());
                events.add(interaction + " block with " + item.identifyMaterial());
                events.add(interaction + " " + blockMaterial.identify() + " with item");
                events.add(interaction + " " + blockMaterial.identify() + " with " + item.identify());
                events.add(interaction + " " + blockMaterial.identify() + " with " + item.identifyMaterial());
            }
            if ((cuboids = dCuboid.getNotableCuboidsContaining(event.getClickedBlock().getLocation())).size() > 0) {
                dList cuboid_context = new dList();
                for (dCuboid cuboid : cuboids) {
                    events.add(interaction + " block in " + cuboid.identify());
                    events.add(interaction + " block in cuboid");
                    events.add(interaction + " " + blockMaterial.identify() + " in " + cuboid.identify());
                    events.add(interaction + " " + blockMaterial.identify() + " in cuboid");
                    cuboid_context.add(cuboid.identify());
                }
                context.put("cuboids", cuboid_context);
            }
        }
        if ((determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context, true)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerInteractEntity(PlayerInteractEntityEvent event) {
        List<dCuboid> cuboids;
        dNPC npc = null;
        dItem item = new dItem(event.getPlayer().getItemInHand());
        dEntity entity = new dEntity(event.getRightClicked());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getRightClicked().getLocation()));
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
        }
        List<String> events = new ArrayList<String>();
        events.add("player right clicks entity");
        events.add("player right clicks " + entity.identifyType());
        events.add("player right clicks entity with " + item.identify());
        events.add("player right clicks " + entity.identifyType() + " with " + item.identify());
        events.add("player right clicks entity with " + item.identifyMaterial());
        events.add("player right clicks " + entity.identifyType() + " with " + item.identifyMaterial());
        if (entity.getBukkitEntity() instanceof ItemFrame) {
            dItem itemFrame = new dItem(((ItemFrame)entity.getBukkitEntity()).getItem());
            context.put("itemframe", itemFrame);
            events.add("player right clicks " + entity.identifyType() + " " + itemFrame.identify());
            events.add("player right clicks " + entity.identifyType() + " " + itemFrame.identifyMaterial());
        }
        if ((cuboids = dCuboid.getNotableCuboidsContaining(event.getRightClicked().getLocation())).size() > 0) {
            dList cuboid_context = new dList();
            for (dCuboid cuboid : cuboids) {
                events.add("player right clicks entity in " + cuboid.identify());
                events.add("player right clicks entity in cuboid");
                events.add("player right clicks " + entity.identifyType() + " in cuboid");
                events.add("player right clicks " + entity.identifyType() + " in " + cuboid.identify());
                cuboid_context.add(cuboid.identify());
            }
            context.put("cuboids", cuboid_context);
        }
        if ((events = WorldScriptHelper.trimEvents(events)).size() == 0) {
            return;
        }
        String determination = WorldScriptHelper.doEvents(events, npc, event.getPlayer(), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerItemConsume(PlayerItemConsumeEvent event) {
        dItem item = new dItem(event.getItem());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("item", item);
        ArrayList<String> events = new ArrayList<String>();
        events.add("player consumes " + item.identify());
        events.add("player consumes " + item.identifyMaterial());
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerJoinEvent(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(event.getJoinMessage()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player joins", "player join"), null, player, context);
        if (!determination.equals("none")) {
            event.setJoinMessage(determination);
        }
        if (ScoreboardHelper.viewerMap.containsKey(player.getName())) {
            player.setScoreboard(ScoreboardHelper.getScoreboard(ScoreboardHelper.viewerMap.get(player.getName())));
        }
    }

    @EventHandler
    public void playerKick(PlayerKickEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(event.getLeaveMessage()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player kicked"), null, event.getPlayer(), context);
        if (!determination.equals("none")) {
            event.setLeaveMessage(determination);
        }
    }

    @EventHandler
    public void playerLeashEntity(PlayerLeashEntityEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        context.put("entity", entity);
        context.put("holder", new dEntity(event.getLeashHolder()));
        WorldScriptHelper.doEvents(Arrays.asList("player leashes entity", "entity leashes " + entity.identifyType()), null, event.getPlayer(), context, true);
    }

    @EventHandler
    public void playerLevelChange(PlayerLevelChangeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("level", new Element(event.getNewLevel()));
        WorldScriptHelper.doEvents(Arrays.asList("player levels up", "player levels up to " + event.getNewLevel(), "player levels up from " + event.getOldLevel()), null, event.getPlayer(), context);
    }

    @EventHandler
    public void playerLogin(PlayerLoginEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("hostname", new Element(event.getHostname()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player logs in", "player login"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("KICKED")) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, determination);
        }
    }

    @EventHandler
    public void playerMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlock().equals(event.getTo().getBlock())) {
            return;
        }
        String name = dLocation.getSaved(event.getPlayer().getLocation());
        if (name != null) {
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            context.put("notable", new Element(name));
            String determination = WorldScriptHelper.doEvents(Arrays.asList("player walks over notable", "player walks over " + name, "walked over notable", "walked over " + name), null, event.getPlayer(), context);
            if (determination.toUpperCase().startsWith("CANCELLED") || determination.toUpperCase().startsWith("FROZEN")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void playerPickupItem(PlayerPickupItemEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getItem().getItemStack());
        context.put("item", item);
        context.put("entity", new dEntity((Entity)event.getItem()));
        context.put("location", new dLocation(event.getItem().getLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player picks up item");
        events.add("player picks up " + item.identify());
        events.add("player picks up " + item.identifyMaterial());
        events.add("player takes item");
        events.add("player takes " + item.identify());
        events.add("player takes " + item.identifyMaterial());
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerQuit(PlayerQuitEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(event.getQuitMessage()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player quits", "player quit"), null, event.getPlayer(), context);
        if (!determination.equals("none")) {
            event.setQuitMessage(determination);
        }
    }

    @EventHandler
    public void playerRespawn(PlayerRespawnEvent event) {
        dLocation location;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getRespawnLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player respawns");
        if (event.isBedSpawn()) {
            events.add("player respawns at bed");
        } else {
            events.add("player respawns elsewhere");
        }
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context);
        if (dLocation.matches(determination) && (location = dLocation.valueOf(determination)) != null) {
            event.setRespawnLocation((Location)location);
        }
    }

    @EventHandler
    public void playerShearEntity(PlayerShearEntityEvent event) {
        String determination;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        context.put("entity", entity);
        ArrayList<String> events = new ArrayList<String>();
        events.add("player shears entity");
        events.add("player shears " + entity.identifyType());
        if (entity.getEntityType().equals((Object)EntityType.SHEEP)) {
            String color = ((Sheep)entity.getBukkitEntity()).getColor().name();
            events.add("player shears " + color + " sheep");
        }
        if ((determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context, true)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerToggleFlight(PlayerToggleFlightEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("state", new Element(event.isFlying()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player toggles flight", "player " + (event.isFlying() ? "starts" : "stops") + " flying"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerToggleSneak(PlayerToggleSneakEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("state", new Element(event.isSneaking()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player toggles sneak", "player " + (event.isSneaking() ? "starts" : "stops") + " sneaking"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerToggleSprint(PlayerToggleSprintEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("state", new Element(event.isSprinting()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player toggles sprint", "player " + (event.isSprinting() ? "starts" : "stops") + " sprinting"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void serverCommand(ServerCommandEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        String message = event.getCommand().replace('<', '\u0001').replace('>', '\u0002').replace(String.valueOf('\u0001'), "<&lt>").replace(String.valueOf('\u0002'), "<&gt>").replace("%", "<&pc>");
        String command = event.getCommand().split(" ")[0].replace("/", "").toUpperCase();
        List<String> events = WorldScriptHelper.trimEvents(Arrays.asList("command", command + " command"));
        if (events.size() == 0) {
            return;
        }
        List<String> args = Arrays.asList(aH.buildArgs(message.split(" ").length > 1 ? message.split(" ", 2)[1] : ""));
        List<String> parsed_args = Arrays.asList(aH.buildArgs(event.getCommand().split(" ").length > 1 ? event.getCommand().split(" ", 2)[1] : ""));
        context.put("args", new dList(args));
        context.put("parsed_args", new dList(parsed_args));
        context.put("command", new Element(command));
        context.put("raw_args", new Element(message.split(" ").length > 1 ? event.getCommand().split(" ", 2)[1] : ""));
        context.put("server", Element.TRUE);
        WorldScriptHelper.doEvents(events, null, null, context);
    }

    @EventHandler
    public void vehicleBlockCollision(VehicleBlockCollisionEvent event) {
        if (event.getBlock().getType() == Material.AIR) {
            return;
        }
        Player player = null;
        dNPC npc = null;
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("vehicle", vehicle);
        context.put("location", new dLocation(event.getBlock().getLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("vehicle collides with block");
        events.add("vehicle collides with " + material.identify());
        events.add(vehicle.identifyType() + " collides with block");
        events.add(vehicle.identifyType() + " collides with " + material.identify());
        WorldScriptHelper.doEvents(events, npc, player, context, true);
    }

    @EventHandler
    public void vehicleEntityCollision(VehicleEntityCollisionEvent event) {
        Player player = null;
        dNPC npc = null;
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        dEntity entity = new dEntity(event.getEntity());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("vehicle", vehicle);
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        ArrayList<String> events = new ArrayList<String>();
        events.add("vehicle collides with entity");
        events.add("vehicle collides with " + entity.identifyType());
        events.add(vehicle.identifyType() + " collides with entity");
        events.add(vehicle.identifyType() + " collides with " + entity.identifyType());
        String determination = WorldScriptHelper.doEvents(events, npc, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (determination.toUpperCase().startsWith("NOPICKUP")) {
            event.setPickupCancelled(true);
        }
    }

    @EventHandler
    public void vehicleCreate(VehicleCreateEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        context.put("vehicle", vehicle);
        WorldScriptHelper.doEvents(Arrays.asList("vehicle created", vehicle.identifyType() + " created"), null, null, context, true);
    }

    @EventHandler
    public void vehicleDamage(VehicleDamageEvent event) {
        String determination;
        Player player = null;
        dNPC npc = null;
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("damage", new Element(event.getDamage()));
        context.put("vehicle", vehicle);
        ArrayList<String> events = new ArrayList<String>();
        events.add("vehicle damaged");
        events.add(vehicle.identifyType() + " damaged");
        if (event.getAttacker() != null) {
            dEntity entity = new dEntity(event.getAttacker());
            context.put("entity", entity.getDenizenObject());
            if (entity.isNPC()) {
                npc = entity.getDenizenNPC();
            } else if (entity.isPlayer()) {
                player = entity.getPlayer();
            }
            events.add("entity damages vehicle");
            events.add("entity damages " + vehicle.identifyType());
            events.add(entity.identifyType() + " damages vehicle");
            events.add(entity.identifyType() + " damages " + vehicle.identifyType());
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, player, context, true)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Double)) {
            event.setDamage(aH.getDoubleFrom(determination));
        }
    }

    @EventHandler
    public void vehicleDestroy(VehicleDestroyEvent event) {
        String determination;
        Player player = null;
        dNPC npc = null;
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("vehicle", vehicle);
        ArrayList<String> events = new ArrayList<String>();
        events.add("vehicle destroyed");
        events.add(vehicle.identifyType() + " destroyed");
        if (event.getAttacker() != null) {
            dEntity entity = new dEntity(event.getAttacker());
            context.put("entity", entity.getDenizenObject());
            if (entity.isNPC()) {
                npc = entity.getDenizenNPC();
            } else if (entity.isPlayer()) {
                player = entity.getPlayer();
            }
            events.add("entity destroys vehicle");
            events.add("entity destroys " + vehicle.identifyType());
            events.add(entity.identifyType() + " destroys vehicle");
            events.add(entity.identifyType() + " destroys " + vehicle.identifyType());
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, player, context, true)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void vehicleEnter(VehicleEnterEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        dEntity entity = new dEntity(event.getEntered());
        context.put("vehicle", vehicle);
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity enters vehicle", entity.identifyType() + " enters vehicle", "entity enters " + vehicle.identifyType(), entity.identifyType() + " enters " + vehicle.identifyType()), npc, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void vehicleExit(VehicleExitEvent event) {
        Player player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        dEntity entity = new dEntity((Entity)event.getExited());
        context.put("vehicle", vehicle);
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = entity.getPlayer();
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity exits vehicle", "entity exits " + vehicle.identifyType(), entity.identifyType() + " exits vehicle", entity.identifyType() + " exits " + vehicle.identifyType()), npc, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void lightningStrike(LightningStrikeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        context.put("location", new dLocation(event.getLightning().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("lightning strikes", "lightning strikes in " + world.identify()), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void weatherChange(WeatherChangeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        ArrayList<String> events = new ArrayList<String>();
        events.add("weather changes");
        events.add("weather changes in " + world.identify());
        if (event.toWeatherState()) {
            context.put("weather", new Element("rain"));
            events.add("weather rains");
            events.add("weather rains in " + world.identify());
        } else {
            context.put("weather", new Element("clear"));
            events.add("weather clears");
            events.add("weather clears in " + world.identify());
        }
        String determination = WorldScriptHelper.doEvents(events, null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void portalCreate(PortalCreateEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        String reason = event.getReason().name();
        context.put("world", world);
        context.put("reason", new Element(reason));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("portal created", "portal created because " + reason, "portal created in " + world.identify(), "portal created in " + world.identify() + " because " + reason), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void spawnChange(SpawnChangeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        context.put("old_location", new dLocation(event.getPreviousLocation()));
        context.put("new_location", new dLocation(world.getWorld().getSpawnLocation()));
        WorldScriptHelper.doEvents(Arrays.asList("spawn changes", "spawn changes in " + world.identify()), null, null, context, true);
    }

    @EventHandler
    public void structureGrow(StructureGrowEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        String treeType = event.getSpecies().name();
        context.put("world", world);
        context.put("location", new dLocation(event.getLocation()));
        context.put("structure", new Element(treeType));
        ArrayList<String> events = new ArrayList<String>();
        events.add("structure grows");
        events.add("structure grows in " + world.identify());
        events.add(treeType + " grows");
        events.add(treeType + " grows in " + world.identify());
        if (event.isFromBonemeal()) {
            events.add("structure grows from bonemeal");
            events.add("structure grows from bonemeal in " + world.identify());
            events.add(treeType + " grows from bonemeal");
            events.add(treeType + " grows from bonemeal in " + world.identify());
        } else {
            events.add("structure grows naturally");
            events.add("structure grows naturally in " + world.identify());
            events.add(treeType + " grows naturally");
            events.add(treeType + " grows naturally in " + world.identify());
        }
        String determination = WorldScriptHelper.doEvents(events, null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void worldInit(WorldInitEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        WorldScriptHelper.doEvents(Arrays.asList("world initializes", world.identify() + " initializes"), null, null, context, true);
    }

    @EventHandler
    public void worldLoad(WorldLoadEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        WorldScriptHelper.doEvents(Arrays.asList("world loads", world.identify() + " loads"), null, null, context, true);
    }

    @EventHandler
    public void worldSave(WorldSaveEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        WorldScriptHelper.doEvents(Arrays.asList("world saves", world.identify() + " saves"), null, null, context, true);
    }

    @EventHandler
    public void worldUnload(WorldUnloadEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        WorldScriptHelper.doEvents(Arrays.asList("world unloads", world.identify() + " unloads"), null, null, context, true);
    }
}

