/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.properties.EntityAge;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class AgeCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("agetype") && arg.matchesEnum(AgeType.values())) {
                scriptEntry.addObject("agetype", (Object)AgeType.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("age") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("age", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("lock") && arg.matches("lock")) {
                scriptEntry.addObject("lock", "");
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        scriptEntry.defaultObject("age", new Element(1));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        AgeType ageType = (AgeType)((Object)scriptEntry.getObject("agetype"));
        int age = scriptEntry.getElement("age").asInt();
        boolean lock = scriptEntry.hasObject("lock");
        dB.report(scriptEntry, this.getName(), (lock ? aH.debugObj("lock", lock) : "") + (ageType != null ? aH.debugObj("agetype", (Object)ageType) : aH.debugObj("age", age)) + aH.debugObj("entities", entities.toString()));
        for (dEntity entity : entities) {
            if (!entity.isSpawned()) continue;
            if (EntityAge.describes(entity)) {
                EntityAge property = EntityAge.getFrom(entity);
                if (ageType != null) {
                    if (ageType.equals((Object)AgeType.BABY)) {
                        property.setBaby(true);
                    } else {
                        property.setBaby(false);
                    }
                } else {
                    property.setAge(age);
                }
                if (!lock) continue;
                property.setLock(true);
                continue;
            }
            dB.echoError(entity.identify() + " is not ageable!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AgeType {
        ADULT,
        BABY;

    }
}

