/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.jar.JarFile;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    static Random random = new Random();
    protected static FilenameFilter scriptsFilter = new FilenameFilter(){

        public boolean accept(File file, String fileName) {
            if (fileName.startsWith(".")) {
                return false;
            }
            String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
            return ext.equalsIgnoreCase("YML") || ext.equalsIgnoreCase("DSCRIPT");
        }
    };

    public static Random getRandom() {
        return random;
    }

    public static Location getWalkableLocationNear(Location location, int range) {
        int selected_z;
        int selected_x = random.nextInt(range * 2);
        Location returnable = location.add((double)(selected_x - range), 1.0, (double)((selected_z = random.nextInt(range * 2)) - range));
        if (!Utilities.isWalkable(returnable)) {
            return Utilities.getWalkableLocationNear(location, range);
        }
        return returnable;
    }

    public static boolean isWalkable(Location location) {
        return (location.getBlock().getType() == Material.AIR || location.getBlock().getType() == Material.GRASS) && location.add(0.0, 1.0, 0.0).getBlock().getType() == Material.AIR;
    }

    public static String arrayToString(String[] input, String glue) {
        String output = "";
        int length = input.length;
        int i = 1;
        for (String s : input) {
            output.concat(s);
            if (++i == length) continue;
            output.concat(glue);
        }
        return output;
    }

    public static String[] wrapWords(String text, int width) {
        StringBuilder sb = new StringBuilder(text);
        int i = 0;
        while (i + width < sb.length() && (i = sb.lastIndexOf(" ", i + width)) != -1) {
            sb.replace(i, i + 1, "\n");
        }
        return sb.toString().split("\n");
    }

    public static void talkToNPC(String message, dPlayer player, dNPC npc, double range) {
        String replacer = String.valueOf('\u0003');
        String talkFormat = Settings.ChatToNpcFormat().replace("<TEXT>", replacer).replace("<text>", replacer).replace("<Text>", replacer);
        String bystanderFormat = Settings.ChatToNpcOverheardFormat().replace("<TEXT>", replacer).replace("<text>", replacer).replace("<Text>", replacer);
        talkFormat = TagManager.tag(player, npc, talkFormat, false).replace(replacer, message);
        bystanderFormat = TagManager.tag(player, npc, bystanderFormat, false).replace(replacer, message);
        player.getPlayerEntity().sendMessage(talkFormat);
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (target == player.getPlayerEntity() || !target.getWorld().equals(player.getPlayerEntity().getWorld()) || !(target.getLocation().distance(player.getPlayerEntity().getLocation()) <= range)) continue;
            target.sendMessage(bystanderFormat);
        }
    }

    public static int lastIndexOfUCL(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean isBetween(double a, double b, double c) {
        return a == c || b == c || (b > a ? c > a && c < b : c > b && c < a);
    }

    public String getVersionNumber() {
        Properties props = new Properties();
        props.put("version", "Unknown development build");
        try {
            props.load(this.getClass().getResourceAsStream("/META-INF/maven/net.aufdemrand/denizen/pom.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props.getProperty("version");
    }

    public static List<Block> getRandomSolidBlocks(Location location, int range, int count) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int x = 0;
        int f = 0;
        while (x < count && f <= 1000) {
            ++f;
            Location loc = location.clone().add((double)(Utilities.getRandom().nextInt(range * 2) - range), (double)(Utilities.getRandom().nextInt(range * 2) - range), (double)(Utilities.getRandom().nextInt(range * 2) - range));
            if (!loc.getBlock().getType().isSolid()) continue;
            blocks.add(loc.getBlock());
            ++x;
        }
        dB.log(blocks.size() + " blocksize");
        return blocks;
    }

    public static Player getClosestPlayer(Location location, int range) {
        Player closestPlayer = null;
        double closestDistance = Math.pow(range, 2.0);
        ArrayList<Player> playerList = new ArrayList<Player>(Arrays.asList(Bukkit.getOnlinePlayers()));
        for (Player player : playerList) {
            Location loc = player.getLocation();
            if (!loc.getWorld().equals(location.getWorld()) || !(loc.distanceSquared(location) < closestDistance)) continue;
            closestPlayer = player;
            closestDistance = player.getLocation().distanceSquared(location);
        }
        return closestPlayer;
    }

    public static List<dPlayer> getClosestPlayers(Location location, int range) {
        ArrayList<dPlayer> closestPlayers = new ArrayList<dPlayer>();
        double closestDistance = Math.pow(range, 2.0);
        ArrayList<Player> playerList = new ArrayList<Player>(Arrays.asList(Bukkit.getOnlinePlayers()));
        for (Player player : playerList) {
            Location loc = player.getLocation();
            if (!loc.getWorld().equals(location.getWorld()) || !(loc.distanceSquared(location) < closestDistance)) continue;
            closestPlayers.add(dPlayer.mirrorBukkitPlayer((OfflinePlayer)player));
        }
        return closestPlayers;
    }

    public static dNPC getClosestNPC(Location location, int range) {
        dNPC closestNPC = null;
        double closestDistance = Math.pow(range, 2.0);
        for (dNPC npc : DenizenAPI.getSpawnedNPCs()) {
            dLocation loc = npc.getLocation();
            if (!loc.getWorld().equals(location.getWorld()) || !(loc.distanceSquared(location) < closestDistance)) continue;
            closestNPC = npc;
            closestDistance = npc.getLocation().distanceSquared(location);
        }
        return closestNPC;
    }

    public static dNPC getClosestNPC_ChatTrigger(Location location, int range) {
        dNPC closestNPC = null;
        double closestDistance = Math.pow(range, 2.0);
        for (dNPC npc : DenizenAPI.getSpawnedNPCs()) {
            dLocation loc = npc.getLocation();
            if (!npc.getCitizen().hasTrait(TriggerTrait.class) || !npc.getTriggerTrait().hasTrigger("CHAT") || !loc.getWorld().equals(location.getWorld()) || !(loc.distanceSquared(location) < closestDistance)) continue;
            closestNPC = npc;
            closestDistance = npc.getLocation().distanceSquared(location);
        }
        return closestNPC;
    }

    public static Set<dNPC> getClosestNPCs(Location location, int maxRange) {
        maxRange = (int)Math.pow(maxRange, 2.0);
        HashSet<dNPC> closestNPCs = new HashSet<dNPC>();
        for (dNPC npc : DenizenAPI.getSpawnedNPCs()) {
            dLocation loc = npc.getLocation();
            if (!loc.getWorld().equals(location.getWorld()) || !(loc.distanceSquared(location) < (double)maxRange)) continue;
            closestNPCs.add(npc);
        }
        return closestNPCs;
    }

    public static boolean checkLocation(LivingEntity entity, Location theLocation, int theLeeway) {
        if (entity.getWorld() != theLocation.getWorld()) {
            return false;
        }
        Location entityLocation = entity.getLocation();
        if (Math.abs(entityLocation.getX() - theLocation.getX()) > (double)theLeeway) {
            return false;
        }
        if (Math.abs(entityLocation.getY() - theLocation.getY()) > (double)theLeeway) {
            return false;
        }
        return !(Math.abs(entityLocation.getZ() - theLocation.getZ()) > (double)theLeeway);
    }

    public static boolean checkLocation(Location baseLocation, Location theLocation, int theLeeway) {
        if (!baseLocation.getWorld().getName().equals(theLocation.getWorld().getName())) {
            return false;
        }
        if (Math.abs(baseLocation.getX() - theLocation.getX()) > (double)theLeeway) {
            return false;
        }
        if (Math.abs(baseLocation.getY() - theLocation.getY()) > (double)theLeeway) {
            return false;
        }
        return !(Math.abs(baseLocation.getZ() - theLocation.getZ()) > (double)theLeeway);
    }

    public static List<File> listDScriptFiles(File dir, boolean recursive) {
        File[] entries;
        ArrayList<File> files = new ArrayList<File>();
        for (File file : entries = dir.listFiles()) {
            if (scriptsFilter == null || scriptsFilter.accept(dir, file.getName())) {
                files.add(file);
            }
            if (!recursive || !file.isDirectory()) continue;
            files.addAll(Utilities.listDScriptFiles(file, recursive));
        }
        return files;
    }

    public static void setSignLines(Sign sign, String[] lines) {
        int n = 0;
        for (String line : lines) {
            sign.setLine(n, line);
            ++n;
        }
        sign.update();
    }

    public static void setSignRotation(BlockState signState) {
        BlockFace[] blockFaces;
        for (BlockFace blockFace : blockFaces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH}) {
            Block block = signState.getBlock().getRelative(blockFace);
            if (block.getType() == Material.AIR || block.getType() == Material.SIGN_POST || block.getType() == Material.WALL_SIGN) continue;
            ((org.bukkit.material.Sign)signState.getData()).setFacingDirection(blockFace.getOppositeFace());
            signState.update();
        }
    }

    public static void setSignRotation(BlockState signState, String direction) {
        BlockFace[] blockFaces;
        for (BlockFace blockFace : blockFaces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH}) {
            if (!blockFace.name().startsWith(direction.toUpperCase().substring(0, 1))) continue;
            ((org.bukkit.material.Sign)signState.getData()).setFacingDirection(blockFace);
        }
        signState.update();
    }

    public static boolean isBlock(Location block, Location location) {
        if (!block.getWorld().getName().equals(location.getWorld().getName())) {
            return false;
        }
        if (Math.abs(block.getBlockX() - location.getBlockX()) > 0) {
            return false;
        }
        if (Math.abs(block.getBlockY() - location.getBlockY()) > 0) {
            return false;
        }
        return Math.abs(block.getBlockZ() - location.getBlockZ()) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extractFile(File jarFile, String fileName, String destDir) {
        jar = null;
        try {
            jar = new JarFile(jarFile);
            myEnum = jar.entries();
            while (myEnum.hasMoreElements()) {
                file = myEnum.nextElement();
                if (!file.getName().equalsIgnoreCase(fileName)) continue;
                f = new File(destDir + "/" + file.getName());
                if (file.isDirectory()) continue;
                is = jar.getInputStream(file);
                fos = new FileOutputStream(f);
                while (is.available() > 0) {
                    fos.write(is.read());
                }
                fos.close();
                is.close();
                var10_10 = null;
                if (jar == null) return;
                ** GOTO lbl48
            }
            dB.echoError(fileName + " not found in the jar!");
            ** GOTO lbl55
        }
        catch (IOException e) {
            if (dB.showStackTraces) {
                e.printStackTrace();
            }
            var10_12 = null;
            if (jar == null) return;
            try {
                jar.close();
                return;
            }
            catch (IOException e) {
                if (dB.showStackTraces == false) return;
                e.printStackTrace();
                return;
            }
        }
        {
            catch (Throwable var9_18) {
                var10_13 = null;
                if (jar == null) throw var9_18;
                ** try [egrp 2[TRYBLOCK] [6 : 216->223)] { 
lbl42:
                // 1 sources

                jar.close();
                throw var9_18;
lbl44:
                // 1 sources

                catch (IOException e) {
                    if (dB.showStackTraces == false) throw var9_18;
                    e.printStackTrace();
                }
                throw var9_18;
            }
lbl48:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [6 : 216->223)] { 
lbl49:
            // 1 sources

            jar.close();
            return;
lbl51:
            // 1 sources

            catch (IOException e) {
                if (dB.showStackTraces == false) return;
                e.printStackTrace();
            }
            return;
lbl55:
            // 1 sources

            var10_11 = null;
            if (jar == null) return;
            try {}
            catch (IOException e) {}
            if (dB.showStackTraces == false) return;
            e.printStackTrace();
            return;
            jar.close();
            return;
        }
    }
}

