/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.BracedCommand;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.Debuggable;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class RandomCommand
extends BracedCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matches("{")) {
                scriptEntry.addObject("braces", this.getBracedCommands(scriptEntry, 0));
                break;
            }
            if (!scriptEntry.hasObject("possibilities") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("possibilities", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("braces")) {
            if (!scriptEntry.hasObject("possibilities")) {
                throw new InvalidArgumentsException("Missing possibilities!");
            }
            if (scriptEntry.getElement("possibilities").asInt() <= 1) {
                throw new InvalidArgumentsException("Must randomly select more than one item.");
            }
            if (scriptEntry.getResidingQueue().getQueueSize() < scriptEntry.getElement("possibilities").asInt()) {
                throw new InvalidArgumentsException("Invalid Size! Random # must not be larger than the script!");
            }
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        int possibilities = 0;
        ScriptQueue queue = scriptEntry.getResidingQueue();
        ArrayList bracedCommands = null;
        if (!scriptEntry.hasObject("braces")) {
            possibilities = scriptEntry.getElement("possibilities").asInt();
        } else {
            bracedCommands = (ArrayList)((LinkedHashMap)scriptEntry.getObject("braces")).get("RANDOM");
            possibilities = bracedCommands.size();
        }
        int selected = Utilities.getRandom().nextInt(possibilities);
        dB.echoDebug((Debuggable)scriptEntry, "...random number generator selected '" + String.valueOf(selected + 1) + "'.");
        if (bracedCommands == null) {
            ScriptEntry keeping = null;
            for (int x = 0; x < possibilities; ++x) {
                if (x != selected) {
                    queue.removeEntry(0);
                    continue;
                }
                dB.echoDebug((Debuggable)scriptEntry, "...selected '" + queue.getEntry(0).getCommandName() + ": " + queue.getEntry(0).getArguments() + "'.");
                keeping = queue.getEntry(0);
                queue.removeEntry(0);
            }
            queue.injectEntry(keeping, 0);
        } else {
            queue.injectEntry((ScriptEntry)bracedCommands.get(selected), 0);
        }
    }
}

