/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.trait.trait.Equipment;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class HeadCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("skin") && arg.matchesPrefix("skin, s")) {
                scriptEntry.addObject("skin", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matches("player") && scriptEntry.hasPlayer()) {
                scriptEntry.addObject("entities", Arrays.asList(scriptEntry.getPlayer().getDenizenEntity()));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("entities", scriptEntry.hasNPC() ? Arrays.asList(scriptEntry.getNPC().getDenizenEntity()) : null, scriptEntry.hasPlayer() ? Arrays.asList(scriptEntry.getPlayer().getDenizenEntity()) : null);
        if (!scriptEntry.hasObject("skin")) {
            throw new InvalidArgumentsException("Must specify a skin!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        Element skin = scriptEntry.getElement("skin");
        dB.report(scriptEntry, this.getName(), aH.debugObj("entities", entities.toString()) + skin.debug());
        ItemStack item = new ItemStack(Material.SKULL_ITEM, 1, 3);
        ItemMeta itemMeta = item.getItemMeta();
        ((SkullMeta)itemMeta).setOwner(skin.asString().replaceAll("[pP]@", ""));
        item.setItemMeta(itemMeta);
        for (dEntity entity : entities) {
            if (entity.isNPC()) {
                if (!entity.getNPC().hasTrait(Equipment.class)) {
                    entity.getNPC().addTrait(Equipment.class);
                }
                Equipment trait = (Equipment)entity.getNPC().getTrait(Equipment.class);
                trait.set(1, item);
                continue;
            }
            if (entity.isPlayer()) {
                entity.getPlayer().getInventory().setHelmet(item);
                continue;
            }
            if (entity.isLivingEntity() && entity.getLivingEntity().getEquipment() != null) {
                entity.getLivingEntity().getEquipment().setHelmet(item);
                continue;
            }
            dB.echoError(entity.identify() + " is not a living entity!");
        }
    }
}

