/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.Sound;

public class PlaySoundCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && !scriptEntry.hasObject("entities") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("location") && !scriptEntry.hasObject("entities") && arg.matchesArgumentList(dPlayer.class)) {
                scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dPlayer.class));
                continue;
            }
            if (!scriptEntry.hasObject("volume") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("volume, v")) {
                scriptEntry.addObject("volume", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("pitch") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("pitch, p")) {
                scriptEntry.addObject("pitch", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("sound") && arg.matchesPrimitive(aH.PrimitiveType.String)) {
                scriptEntry.addObject("sound", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("sound")) {
            throw new InvalidArgumentsException("Missing sound argument!");
        }
        if (!scriptEntry.hasObject("location") && !scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
        scriptEntry.defaultObject("volume", new Element(1));
        scriptEntry.defaultObject("pitch", new Element(1));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation location = (dLocation)scriptEntry.getObject("location");
        List players = (List)scriptEntry.getObject("entities");
        Element sound = scriptEntry.getElement("sound");
        Element volume = scriptEntry.getElement("volume");
        Element pitch = scriptEntry.getElement("pitch");
        dB.report(scriptEntry, this.getName(), (location != null ? location.debug() : "") + (players != null ? aH.debugObj("entities", players.toString()) : "") + sound.debug() + volume.debug() + pitch.debug());
        try {
            if (location != null) {
                location.getWorld().playSound((Location)location, Sound.valueOf((String)sound.asString().toUpperCase()), volume.asFloat(), pitch.asFloat());
            } else {
                for (dPlayer player : players) {
                    player.getPlayerEntity().playSound((Location)player.getLocation(), Sound.valueOf((String)sound.asString().toUpperCase()), volume.asFloat(), pitch.asFloat());
                }
            }
        }
        catch (Exception e) {
            dB.echoError("Invalid sound!");
        }
    }
}

