/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.minecraft.server.v1_6_R3.Block;
import net.minecraft.server.v1_6_R3.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_6_R3.CraftWorld;
import org.bukkit.plugin.Plugin;

public class SwitchCommand
extends AbstractCommand {
    private Map<Location, Integer> taskMap = new ConcurrentHashMap<Location, Integer>(8, 0.9f, 1);

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("state") && arg.matchesEnum(SwitchState.values())) {
                scriptEntry.addObject("switchstate", new Element(arg.getValue().toUpperCase()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        scriptEntry.defaultObject("duration", new Duration(0));
        scriptEntry.defaultObject("switchstate", new Element("TOGGLE"));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        final dLocation interactLocation = (dLocation)scriptEntry.getObject("location");
        int duration = ((Duration)scriptEntry.getObject("duration")).getSecondsAsInt();
        final SwitchState switchState = SwitchState.valueOf(scriptEntry.getElement("switchstate").asString());
        this.switchBlock(interactLocation, switchState);
        if (duration > 0) {
            if (this.taskMap.containsKey(interactLocation)) {
                try {
                    this.denizen.getServer().getScheduler().cancelTask(this.taskMap.get(interactLocation).intValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            dB.log("Setting delayed task 'SWITCH' for " + interactLocation.identify());
            this.taskMap.put(interactLocation, this.denizen.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.denizen, new Runnable(){

                public void run() {
                    if (switchState == SwitchState.OFF && (interactLocation.getBlock().getData() & 8) <= 0) {
                        SwitchCommand.this.switchBlock(interactLocation, SwitchState.ON);
                    } else if (switchState == SwitchState.ON && (interactLocation.getBlock().getData() & 8) > 0) {
                        SwitchCommand.this.switchBlock(interactLocation, SwitchState.OFF);
                    } else if (switchState == SwitchState.TOGGLE) {
                        SwitchCommand.this.switchBlock(interactLocation, SwitchState.TOGGLE);
                    }
                }
            }, (long)(duration * 20)));
        }
    }

    public void switchBlock(Location interactLocation, SwitchState switchState) {
        org.bukkit.World world = interactLocation.getWorld();
        boolean currentState = (interactLocation.getBlock().getData() & 8) > 0;
        String state = switchState.toString();
        if (state.equals("ON") && !currentState || state.equals("OFF") && currentState || state.equals("TOGGLE")) {
            try {
                Block.byId[interactLocation.getBlock().getType().getId()].interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                dB.log("Switched " + interactLocation.getBlock().getType().toString() + "! Current state now: " + ((interactLocation.getBlock().getData() & 8) > 0 ? "ON" : "OFF"));
            }
            catch (NullPointerException e) {
                dB.echoError("Cannot switch " + interactLocation.getBlock().getType().toString() + "!");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SwitchState {
        ON,
        OFF,
        TOGGLE;

    }
}

