/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class DamageTrigger
extends AbstractTrigger
implements Listener {
    @EventHandler
    public void damageTrigger(EntityDamageByEntityEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        dEntity damager = new dEntity(event.getDamager());
        if (damager.isProjectile() && damager.hasShooter()) {
            damager = damager.getShooter();
        }
        dPlayer dplayer = null;
        if (!damager.isPlayer()) {
            return;
        }
        dplayer = damager.getDenizenPlayer();
        if (CitizensAPI.getNPCRegistry().isNPC(event.getEntity())) {
            Map<String, String> idMap;
            dNPC npc = DenizenAPI.getDenizenNPC(CitizensAPI.getNPCRegistry().getNPC(event.getEntity()));
            if (npc == null) {
                return;
            }
            if (npc.getCitizen() == null) {
                return;
            }
            if (!npc.getCitizen().hasTrait(TriggerTrait.class)) {
                return;
            }
            if (!npc.getTriggerTrait().isEnabled(this.name)) {
                return;
            }
            if (!npc.getTriggerTrait().trigger(this, dplayer)) {
                return;
            }
            InteractScriptContainer script = InteractScriptHelper.getInteractScript(npc, dplayer, this.getClass());
            String id = null;
            if (script != null && !(idMap = script.getIdMapFor(this.getClass(), dplayer)).isEmpty()) {
                for (Map.Entry<String, String> entry : idMap.entrySet()) {
                    String entry_value = TagManager.tag(dplayer, npc, entry.getValue());
                    if (dItem.valueOf(entry_value).comparesTo(dplayer.getPlayerEntity().getItemInHand()) < 0 || !script.checkSpecificTriggerScriptRequirementsFor(this.getClass(), dplayer, npc, entry.getKey())) continue;
                    id = entry.getKey();
                }
            }
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            context.put("damage", new Element(event.getDamage()));
            if (!this.parse(npc, dplayer, script, id, context)) {
                npc.action("no damage trigger", dplayer);
            }
        }
    }

    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }
}

