/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.tags.core.AnchorTags;
import net.aufdemrand.denizen.tags.core.ConstantTags;
import net.aufdemrand.denizen.tags.core.ContextTags;
import net.aufdemrand.denizen.tags.core.FlagTags;
import net.aufdemrand.denizen.tags.core.LocationTags;
import net.aufdemrand.denizen.tags.core.NPCTags;
import net.aufdemrand.denizen.tags.core.NotableLocationTags;
import net.aufdemrand.denizen.tags.core.PlayerTags;
import net.aufdemrand.denizen.tags.core.ProcedureScriptTag;
import net.aufdemrand.denizen.tags.core.SpecialCharacterTags;
import net.aufdemrand.denizen.tags.core.TextTags;
import net.aufdemrand.denizen.tags.core.UtilTags;
import net.aufdemrand.denizen.utilities.debugging.Debuggable;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagManager
implements Listener {
    public Denizen denizen;
    private static Pattern tagRegex = Pattern.compile("<([^<>]+)>");

    public TagManager(Denizen denizen) {
        this.denizen = denizen;
    }

    public void registerCoreTags() {
        new PlayerTags(this.denizen);
        new NPCTags(this.denizen);
        new LocationTags(this.denizen);
        new UtilTags(this.denizen);
        new ProcedureScriptTag(this.denizen);
        new ContextTags(this.denizen);
        new SpecialCharacterTags(this.denizen);
        new TextTags(this.denizen);
        new AnchorTags(this.denizen);
        new FlagTags(this.denizen);
        new ConstantTags(this.denizen);
        new NotableLocationTags(this.denizen);
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @EventHandler
    public void fetchObject(ReplaceableTagEvent event) {
        if (!event.getName().contains("@")) {
            return;
        }
        String object_type = event.getName().split("@")[0].toLowerCase();
        Class object_class = ObjectFetcher.getObjectClass(object_type);
        if (object_class == null) {
            dB.echoError("Invalid object type! Could not fetch '" + object_type + "'!");
            event.setReplaced("null");
            return;
        }
        try {
            if (!ObjectFetcher.checkMatch(object_class, event.hasNameContext() ? event.getName() + '[' + event.getNameContext() + ']' : event.getName())) {
                dB.echoDebug((Debuggable)event.getScriptEntry(), "Returning null. '" + event.getName() + "' is an invalid " + object_class.getSimpleName() + ".");
                event.setReplaced("null");
                return;
            }
            dObject arg = ObjectFetcher.getObjectFrom(object_class, event.hasNameContext() ? event.getName() + '[' + event.getNameContext() + ']' : event.getName());
            if (arg == null) {
                dB.echoError(event.hasNameContext() ? event.getName() + '[' + event.getNameContext() + ']' : event.getName() + " is an invalid dObject!");
                return;
            }
            Attribute attribute = new Attribute(event.raw_tag, event.getScriptEntry());
            event.setReplaced(arg.getAttribute(attribute.fulfill(1)));
        }
        catch (Exception e) {
            dB.echoError("Uh oh! Report this to aufdemrand! Err: TagManagerObjectReflection");
            e.printStackTrace();
        }
    }

    public static String tag(dPlayer player, dNPC npc, String arg) {
        return TagManager.tag(player, npc, arg, false, null);
    }

    public static String tag(dPlayer player, dNPC npc, String arg, boolean instant) {
        return TagManager.tag(player, npc, arg, instant, null);
    }

    public static String tag(dPlayer player, dNPC npc, String arg, boolean instant, ScriptEntry scriptEntry) {
        if (arg == null) {
            return null;
        }
        if (arg.indexOf(62) == -1 || arg.length() < 3) {
            return arg;
        }
        int[] positions = TagManager.locateTag(arg);
        if (positions == null) {
            if (!instant) {
                arg = arg.replace("\\<", "<").replace("\\>", ">");
            }
            return arg;
        }
        int failsafe = 0;
        do {
            ++failsafe;
            if (positions == null) break;
            ReplaceableTagEvent event = new ReplaceableTagEvent(player, npc, arg.substring(positions[0] + 1, positions[1]), scriptEntry);
            if (event.isInstant() != instant) {
                arg = arg.substring(0, positions[0]) + String.valueOf('\u0001') + event.getReplaced() + String.valueOf('\u0002') + arg.substring(positions[1] + 1, arg.length());
                continue;
            }
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (!event.replaced() && event.getAlternative() != null || event.getReplaced().equals("null") && event.getAlternative() != null) {
                event.setReplaced(event.getAlternative());
            }
            arg = arg.substring(0, positions[0]) + event.getReplaced() + arg.substring(positions[1] + 1, arg.length());
        } while ((positions = TagManager.locateTag(arg)) != null || failsafe < 50);
        arg = arg.replace('\u0001', '<').replace('\u0002', '>');
        if (!instant) {
            arg = arg.replace("\\<", "<").replace("\\>", ">");
        }
        return arg;
    }

    private static int[] locateTag(String arg) {
        Matcher tagMatcher = tagRegex.matcher(arg = arg.replace("\\<", "  ").replace("\\>", "  "));
        if (tagMatcher.find()) {
            return new int[]{tagMatcher.start(), tagMatcher.end() - 1};
        }
        return null;
    }

    public static List<String> fillArguments(List<String> args, ScriptEntry scriptEntry) {
        return TagManager.fillArguments(args, scriptEntry, false);
    }

    public static List<String> fillArguments(List<String> args, ScriptEntry scriptEntry, boolean instant) {
        ArrayList<String> filledArgs = new ArrayList<String>();
        int nested_level = 0;
        if (args != null) {
            for (String argument : args) {
                if (argument.equals("{")) {
                    ++nested_level;
                }
                if (argument.equals("}")) {
                    --nested_level;
                }
                if (nested_level < 1) {
                    filledArgs.add(TagManager.tag(scriptEntry.getPlayer(), scriptEntry.getNPC(), argument, instant, scriptEntry));
                    continue;
                }
                filledArgs.add(argument);
            }
        }
        return filledArgs;
    }

    public static List<String> fillArguments(String[] args, dPlayer player, dNPC npc) {
        ArrayList<String> filledArgs = new ArrayList<String>();
        if (args != null) {
            for (String argument : args) {
                filledArgs.add(TagManager.tag(player, npc, argument, false));
            }
        }
        return filledArgs;
    }
}

