/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.utilities.debugging.dB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mechanism {
    private boolean fulfilled = false;
    private String raw_mechanism;
    private Element value;
    private String outcome = null;

    public Mechanism(Element mechanism, Element value) {
        this.raw_mechanism = mechanism.asString();
        this.value = value;
    }

    public void fulfill(String _outcome) {
        this.fulfilled = true;
        this.outcome = _outcome;
    }

    public boolean fulfilled() {
        return this.fulfilled;
    }

    public String getName() {
        return this.raw_mechanism;
    }

    public Element getValue() {
        return this.value;
    }

    public boolean matches(String string) {
        if (string.equalsIgnoreCase(this.raw_mechanism)) {
            this.fulfill("");
            return true;
        }
        return false;
    }

    public boolean requireBoolean() {
        return this.requireBoolean("Invalid boolean. Must specify TRUE or FALSE.");
    }

    public boolean requireDouble() {
        return this.requireDouble("Invalid double specified.");
    }

    public boolean requireEnum(boolean allowInt, Enum<?> ... values) {
        return this.requireEnum("Invalid " + values[0].getDeclaringClass().getName() + "." + " Must specify valid name" + (allowInt ? " or number" : "") + ".", allowInt, values);
    }

    public boolean requireFloat() {
        return this.requireFloat("Invalid float specified.");
    }

    public boolean requireInteger() {
        return this.requireInteger("Invalid integer specified.");
    }

    public <T extends dObject> boolean requireObject(Class<T> type) {
        return this.requireObject("Invalid " + type.getSimpleName() + " specified.", type);
    }

    public boolean requireBoolean(String error) {
        if (this.value.isBoolean()) {
            return true;
        }
        dB.echoError(error);
        return false;
    }

    public boolean requireDouble(String error) {
        if (this.value.isDouble()) {
            return true;
        }
        dB.echoError(error);
        return false;
    }

    public boolean requireEnum(String error, boolean allowInt, Enum<?> ... values) {
        if (allowInt && this.value.isInt() && this.value.asInt() < values.length) {
            return true;
        }
        if (this.value.isString()) {
            String raw_value = this.value.asString().toUpperCase();
            for (Enum<?> check_value : values) {
                if (!raw_value.equals(check_value.name())) continue;
                return true;
            }
        }
        dB.echoError(error);
        return false;
    }

    public boolean requireFloat(String error) {
        if (this.value.isFloat()) {
            return true;
        }
        dB.echoError(error);
        return false;
    }

    public boolean requireInteger(String error) {
        if (this.value.isInt()) {
            return true;
        }
        dB.echoError(error);
        return false;
    }

    public <T extends dObject> boolean requireObject(String error, Class<T> type) {
        if (this.value.matchesType(type)) {
            return true;
        }
        dB.echoError(error);
        return false;
    }

    public void reportInvalid() {
        dB.echoError("Invalid mechanism specified: " + this.raw_mechanism);
    }
}

