/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Adjustable;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.Fetchable;
import net.aufdemrand.denizen.objects.Mechanism;
import net.aufdemrand.denizen.objects.dChunk;
import net.aufdemrand.denizen.objects.dColor;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.debugging.dB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFetcher {
    private static Map<String, Class> objects = new HashMap<String, Class>();
    static Map<Class, Method> matches = new WeakHashMap<Class, Method>();
    static Map<Class, Method> valueof = new WeakHashMap<Class, Method>();
    private static ArrayList<Class> fetchable_objects = new ArrayList();
    static final Pattern PROPERTIES_PATTERN = Pattern.compile("(.+)\\[(.+=.+)\\]", 2);

    public static void _initialize() throws IOException, ClassNotFoundException {
        if (fetchable_objects.isEmpty()) {
            return;
        }
        HashMap<String, Class> adding = new HashMap<String, Class>();
        for (Class dClass : fetchable_objects) {
            for (Method method : dClass.getMethods()) {
                String[] identifiers;
                if (!method.isAnnotationPresent(Fetchable.class)) continue;
                for (String identifer : identifiers = method.getAnnotation(Fetchable.class).value().split(",")) {
                    adding.put(identifer.trim().toLowerCase(), dClass);
                }
            }
        }
        objects.putAll(adding);
        dB.echoApproval("Added objects to the ObjectFetcher " + adding.keySet().toString());
        fetchable_objects.clear();
    }

    public static void _registerCoreObjects() throws NoSuchMethodException, ClassNotFoundException, IOException {
        ObjectFetcher.registerWithObjectFetcher(dItem.class);
        ObjectFetcher.registerWithObjectFetcher(dCuboid.class);
        ObjectFetcher.registerWithObjectFetcher(dEntity.class);
        ObjectFetcher.registerWithObjectFetcher(dInventory.class);
        ObjectFetcher.registerWithObjectFetcher(dColor.class);
        ObjectFetcher.registerWithObjectFetcher(dList.class);
        ObjectFetcher.registerWithObjectFetcher(dLocation.class);
        ObjectFetcher.registerWithObjectFetcher(dMaterial.class);
        ObjectFetcher.registerWithObjectFetcher(dNPC.class);
        ObjectFetcher.registerWithObjectFetcher(dPlayer.class);
        ObjectFetcher.registerWithObjectFetcher(dScript.class);
        ObjectFetcher.registerWithObjectFetcher(dWorld.class);
        ObjectFetcher.registerWithObjectFetcher(Element.class);
        ObjectFetcher.registerWithObjectFetcher(Duration.class);
        ObjectFetcher.registerWithObjectFetcher(dChunk.class);
        ObjectFetcher._initialize();
    }

    public static void registerWithObjectFetcher(Class dObject2) throws NoSuchMethodException {
        fetchable_objects.add(dObject2);
        matches.put(dObject2, dObject2.getMethod("matches", String.class));
        valueof.put(dObject2, dObject2.getMethod("valueOf", String.class));
    }

    public static boolean canFetch(String id) {
        return objects.containsKey(id.toLowerCase());
    }

    public static Class getObjectClass(String id) {
        if (ObjectFetcher.canFetch(id)) {
            return objects.get(id.toLowerCase());
        }
        return null;
    }

    public static boolean checkMatch(Class<? extends dObject> dClass, String value) {
        try {
            Matcher m = PROPERTIES_PATTERN.matcher(value);
            return (Boolean)matches.get(dClass).invoke(null, m.matches() ? m.group(1) : value);
        }
        catch (Exception e) {
            dB.echoError(e);
            return false;
        }
    }

    public static <T extends dObject> T getObjectFrom(Class<T> dClass, String value) {
        return ObjectFetcher.getObjectFrom(dClass, value, null, null);
    }

    public static <T extends dObject> T getObjectFrom(Class<T> dClass, String value, dPlayer player, dNPC npc) {
        try {
            Matcher m = PROPERTIES_PATTERN.matcher(value);
            boolean matched = m.matches();
            dObject gotten = (dObject)(dClass.equals(dItem.class) ? dItem.valueOf(matched ? m.group(1) : value, player, npc) : valueof.get(dClass).invoke(null, matched ? m.group(1) : value));
            if (gotten != null && gotten instanceof Adjustable && matched) {
                String[] properties;
                for (String property : properties = m.group(2).split(";")) {
                    String[] data = property.split("=", 2);
                    ((Adjustable)((Object)gotten)).adjust(new Mechanism(new Element(data[0]), new Element(data[1].replace('\u2011', ';'))));
                }
            }
            return (T)gotten;
        }
        catch (Exception e) {
            dB.echoError(e);
            return null;
        }
    }
}

