/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Adjustable;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.Fetchable;
import net.aufdemrand.denizen.objects.Mechanism;
import net.aufdemrand.denizen.objects.Properties;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.notable.Notable;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.objects.properties.Item.ItemDisplayname;
import net.aufdemrand.denizen.objects.properties.Item.ItemDurability;
import net.aufdemrand.denizen.objects.properties.Item.ItemLore;
import net.aufdemrand.denizen.objects.properties.Item.ItemSkullskin;
import net.aufdemrand.denizen.objects.properties.Property;
import net.aufdemrand.denizen.objects.properties.PropertyParser;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptContainer;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class dItem
implements dObject,
Notable,
Properties,
Adjustable {
    static final Pattern ITEM_PATTERN = Pattern.compile("(?:item:)?([\\w ]+)[:,]?(\\d+)?\\[?(\\d+)?\\]?", 2);
    public static final String itemscriptIdentifier = "\u00a70id:";
    public static boolean nope = false;
    private ItemStack item = null;
    private String prefix = this.getObjectType();

    public static dItem valueOf(String string) {
        return dItem.valueOf(string, null, null);
    }

    @Fetchable(value="i")
    public static dItem valueOf(String string, dPlayer player, dNPC npc) {
        block23: {
            Pattern item_by_saved;
            if (string == null) {
                return null;
            }
            dItem stack = null;
            Pattern item_by_entity_id = Pattern.compile("(i@)(\\d+)\\[?(\\d+)?\\]?");
            Matcher m = item_by_entity_id.matcher(string);
            if (m.matches()) {
                for (World world : Bukkit.getWorlds()) {
                    for (Item entity : world.getEntitiesByClass(Item.class)) {
                        if (entity.getEntityId() != Integer.valueOf(m.group(2)).intValue()) continue;
                        stack = new dItem(entity.getItemStack());
                        if (m.group(3) != null) {
                            stack.setAmount(Integer.valueOf(m.group(3)));
                        }
                        return stack;
                    }
                }
            }
            if ((m = (item_by_saved = Pattern.compile("(i@)(.+)\\[?(\\d+)?\\]?")).matcher(string)).matches() && NotableManager.isSaved(m.group(2)) && NotableManager.isType(m.group(2), dItem.class)) {
                stack = (dItem)NotableManager.getSavedObject(m.group(2));
                if (m.group(3) != null) {
                    stack.setAmount(Integer.valueOf(m.group(3)));
                }
                return stack;
            }
            m = ITEM_PATTERN.matcher(string = string.replace("i@", ""));
            if (m.matches()) {
                try {
                    if (ScriptRegistry.containsScript(m.group(1), ItemScriptContainer.class)) {
                        stack = ScriptRegistry.getScriptContainerAs(m.group(1), ItemScriptContainer.class).getItemFrom(player, npc);
                    } else if (ScriptRegistry.containsScript(m.group(1), BookScriptContainer.class)) {
                        stack = ScriptRegistry.getScriptContainerAs(m.group(1), BookScriptContainer.class).getBookFrom(player, npc);
                    }
                    if (stack != null) {
                        if (m.group(3) != null) {
                            stack.setAmount(Integer.valueOf(m.group(3)));
                        }
                        return stack;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    String material = m.group(1).toUpperCase();
                    if (aH.matchesInteger(material)) {
                        stack = new dItem(Integer.valueOf(material));
                    } else {
                        dMaterial mat = dMaterial.valueOf(material);
                        stack = new dItem(mat.getMaterial());
                        if (mat.hasData()) {
                            stack.setDurability(mat.getData().byteValue());
                        }
                    }
                    if (m.group(2) != null) {
                        stack.setDurability(Short.valueOf(m.group(2)));
                    }
                    if (m.group(3) != null) {
                        stack.setAmount(Integer.valueOf(m.group(3)));
                    }
                    return stack;
                }
                catch (Exception e) {
                    if (string.equalsIgnoreCase("none")) break block23;
                    dB.log("Does not match a valid item ID or material: " + string);
                }
            }
        }
        if (!nope) {
            dB.log("valueOf dItem returning null: " + string);
        }
        return null;
    }

    public static boolean matches(String arg) {
        nope = true;
        if (dItem.valueOf(arg) != null) {
            nope = false;
            return true;
        }
        nope = false;
        return false;
    }

    public dItem(Material material) {
        this.item = new ItemStack(material);
    }

    public dItem(int itemId) {
        this.item = new ItemStack(itemId);
    }

    public dItem(Material material, int qty) {
        this.item = new ItemStack(material, qty);
    }

    public dItem(dMaterial material, int qty) {
        this.item = new ItemStack(material.getMaterial(), qty);
    }

    public dItem(int type, int qty) {
        this.item = new ItemStack(type, qty);
    }

    public dItem(ItemStack item) {
        this.item = item;
    }

    public dItem(Item item) {
        this.item = item.getItemStack();
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public int comparesTo(dItem item) {
        return this.comparesTo(item.getItemStack());
    }

    public int comparesTo(ItemStack item) {
        if (item == null) {
            return -1;
        }
        int determination = 0;
        ItemStack compared = this.getItemStack();
        ItemStack compared_to = item;
        if (compared.getTypeId() != compared_to.getTypeId()) {
            return -1;
        }
        if (compared_to.hasItemMeta()) {
            if (!compared.hasItemMeta()) {
                return -1;
            }
            if (compared_to.getItemMeta().hasDisplayName()) {
                if (!compared.getItemMeta().hasDisplayName()) {
                    return -1;
                }
                if (compared_to.getItemMeta().getDisplayName().toUpperCase().startsWith(compared.getItemMeta().getDisplayName().toUpperCase())) {
                    if (compared.getItemMeta().getDisplayName().length() > compared_to.getItemMeta().getDisplayName().length()) {
                        ++determination;
                    }
                } else {
                    return -1;
                }
            }
            if (compared_to.getItemMeta().hasLore()) {
                if (!compared.getItemMeta().hasLore()) {
                    return -1;
                }
                for (String string : compared_to.getItemMeta().getLore()) {
                    if (compared.getItemMeta().getLore().contains(string)) continue;
                    return -1;
                }
                if (compared.getItemMeta().getLore().size() > compared_to.getItemMeta().getLore().size()) {
                    ++determination;
                }
            }
            if (!compared_to.getItemMeta().getEnchants().isEmpty()) {
                if (compared.getItemMeta().getEnchants().isEmpty()) {
                    return -1;
                }
                for (Map.Entry entry : compared_to.getItemMeta().getEnchants().entrySet()) {
                    if (compared.getItemMeta().getEnchants().containsKey(entry.getKey()) && (Integer)compared.getItemMeta().getEnchants().get(entry.getKey()) >= (Integer)entry.getValue()) continue;
                    return -1;
                }
                if (compared.getItemMeta().getEnchants().size() > compared_to.getItemMeta().getEnchants().size()) {
                    ++determination;
                }
            }
        }
        if (this.isRepairable()) {
            if (compared.getDurability() < compared_to.getDurability()) {
                ++determination;
            }
        } else if (this.getItemStack().getData().getData() != item.getData().getData()) {
            return -1;
        }
        return determination;
    }

    public boolean containsLore(String prefix) {
        if (this.getItemStack().hasItemMeta() && this.getItemStack().getItemMeta().hasLore()) {
            for (String itemLore : this.getItemStack().getItemMeta().getLore()) {
                if (!itemLore.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public String getLore(String prefix) {
        for (String itemLore : this.getItemStack().getItemMeta().getLore()) {
            if (!itemLore.startsWith(prefix)) continue;
            return itemLore.substring(prefix.length());
        }
        return "";
    }

    public boolean isItemscript() {
        return this.containsLore(itemscriptIdentifier);
    }

    public dMaterial getMaterial() {
        return dMaterial.getMaterialFrom(this.getItemStack().getType(), this.getItemStack().getData().getData());
    }

    public String getMaterialName() {
        return this.getItemStack().getType().name().toLowerCase();
    }

    public void setAmount(int value) {
        if (this.item != null) {
            this.item.setAmount(value);
        }
    }

    public void setDurability(short value) {
        if (this.item != null) {
            this.item.setDurability(value);
        }
    }

    public void setData(byte value) {
        if (this.item != null) {
            this.item.getData().setData(value);
        }
    }

    public boolean isRepairable() {
        return this.item.getType().getMaxDurability() > 0;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public dItem setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getObjectType() {
        return "Item";
    }

    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    public String identify() {
        if (this.item == null) {
            return "null";
        }
        if (this.item.getTypeId() != 0) {
            if (this.isUnique()) {
                return "i@" + NotableManager.getSavedId(this);
            }
            if (this.isItemscript()) {
                return "i@" + this.getLore(itemscriptIdentifier);
            }
        }
        return "i@" + this.identifyMaterial().replace("m@", "") + PropertyParser.getPropertiesString(this);
    }

    public String identifyMaterial() {
        return dMaterial.getMaterialFrom(this.item.getType(), this.item.getData().getData()).identify();
    }

    public String toString() {
        return this.identify();
    }

    public boolean isUnique() {
        return NotableManager.isSaved(this);
    }

    public Object getSaveObject() {
        StringBuilder sb = new StringBuilder();
        sb.append("i@");
        sb.append(this.item.getType().name().toUpperCase());
        return sb.toString();
    }

    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    public void forget() {
        NotableManager.remove(this);
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("id")) {
            return new Element(this.getItemStack().getTypeId()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("data")) {
            return new Element(this.getItemStack().getData().getData()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("repairable")) {
            return new Element(ItemDurability.describes(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_lore")) {
            return new Element(ItemLore.describes(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("material.formatted")) {
            String id = this.item.getType().name().toLowerCase().replace('_', ' ');
            if (id.equals("air")) {
                return new Element("nothing").getAttribute(attribute.fulfill(2));
            }
            if (id.equals("ice") || id.equals("dirt")) {
                return new Element(id).getAttribute(attribute.fulfill(2));
            }
            if (this.getItemStack().getAmount() > 1) {
                if (id.equals("cactus")) {
                    return new Element("cactuses").getAttribute(attribute.fulfill(2));
                }
                if (id.endsWith("y")) {
                    return new Element(id.substring(0, id.length() - 1) + "ies").getAttribute(attribute.fulfill(2));
                }
                if (id.endsWith("s")) {
                    return new Element(id).getAttribute(attribute.fulfill(2));
                }
                return new Element(id + "s").getAttribute(attribute.fulfill(2));
            }
            if (id.equals("cactus")) {
                return new Element("a cactus").getAttribute(attribute.fulfill(2));
            }
            if (id.endsWith("s")) {
                return new Element(id).getAttribute(attribute.fulfill(2));
            }
            if (id.startsWith("a") || id.startsWith("e") || id.startsWith("i") || id.startsWith("o") || id.startsWith("u")) {
                return new Element("an " + id).getAttribute(attribute.fulfill(2));
            }
            return new Element("a " + id).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("material")) {
            return this.getMaterial().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_display")) {
            return new Element(ItemDisplayname.describes(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("book")) {
            if (this.getItemStack().getType() == Material.WRITTEN_BOOK) {
                attribute.fulfill(1);
                BookMeta bookInfo = (BookMeta)this.getItemStack().getItemMeta();
                if (attribute.startsWith("author")) {
                    return new Element(bookInfo.getAuthor()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("title")) {
                    return new Element(bookInfo.getTitle()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("page_count")) {
                    return new Element(bookInfo.getPageCount()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("get_page") && aH.matchesInteger(attribute.getContext(1))) {
                    return new Element(bookInfo.getPage(attribute.getIntContext(1))).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("pages")) {
                    return new dList(bookInfo.getPages()).getAttribute(attribute.fulfill(1));
                }
            } else {
                dB.echoError("Item referenced is not a written book!");
                return "null";
            }
        }
        if (attribute.startsWith("scriptname") && this.isItemscript()) {
            return new Element(this.getLore(itemscriptIdentifier)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    public void adjust(Mechanism mechanism) {
        ItemMeta meta;
        Element value = mechanism.getValue();
        if (mechanism.matches("display_name")) {
            meta = this.item.getItemMeta();
            meta.setDisplayName(value.asString());
            this.item.setItemMeta(meta);
        }
        if (mechanism.matches("lore")) {
            meta = this.item.getItemMeta();
            meta.setLore((List)value.asType(dList.class));
            this.item.setItemMeta(meta);
        }
        if (mechanism.matches("enchantments")) {
            for (String enchant : value.asType(dList.class)) {
                if (!enchant.contains(",")) {
                    dB.echoError("Invalid enchantment format, use name,level|...");
                    continue;
                }
                String[] data = enchant.split(",", 2);
                if (Integer.valueOf(data[1]) == null) {
                    dB.echoError("Cannot apply enchantment '" + data[0] + "': '" + data[1] + "' is not a valid integer!");
                    continue;
                }
                try {
                    this.item.addEnchantment(Enchantment.getByName((String)data[0].toUpperCase()), Integer.valueOf(data[1]).intValue());
                }
                catch (NullPointerException e) {
                    dB.echoError("Unknown enchantment '" + data[0] + "'");
                }
            }
        }
        if (mechanism.matches("quantity") && mechanism.requireInteger()) {
            this.item.setAmount(value.asInt());
        }
        if (mechanism.matches("durability") && mechanism.requireInteger()) {
            if (ItemDurability.describes(this)) {
                this.item.setDurability((short)value.asInt());
            } else {
                dB.echoError("Material '" + this.getMaterial().identify().replace("m@", "") + "' is not repairable.");
            }
        }
        if (mechanism.matches("skull_skin")) {
            if (ItemSkullskin.describes(this)) {
                meta = (SkullMeta)this.item.getItemMeta();
                meta.setOwner(value.asString());
                this.item.setItemMeta(meta);
            } else {
                dB.echoError("Material '" + this.getMaterial().identify().replace("m@", "") + "' cannot hold a skin.");
            }
        }
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }
}

