/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.objects.Adjustable;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.Fetchable;
import net.aufdemrand.denizen.objects.Mechanism;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.objects.properties.Property;
import net.aufdemrand.denizen.objects.properties.PropertyParser;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.tags.core.PlayerTags;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Achievement;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.BlockIterator;

public class dPlayer
implements dObject,
Adjustable {
    static Map<String, dPlayer> players = new HashMap<String, dPlayer>();
    String player_name = null;
    private String prefix = "Player";

    public static dPlayer mirrorBukkitPlayer(OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        if (players.containsKey(player.getName())) {
            return players.get(player.getName());
        }
        return new dPlayer(player);
    }

    @Fetchable(value="p")
    public static dPlayer valueOf(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace("p@", "");
        OfflinePlayer returnable = null;
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            if (!player.getName().equalsIgnoreCase(string)) continue;
            returnable = player;
            break;
        }
        if (returnable != null) {
            if (players.containsKey(returnable.getName())) {
                return players.get(returnable.getName());
            }
            return new dPlayer(returnable);
        }
        dB.echoError("Invalid Player! '" + string + "' could not be found. Has the player logged off?");
        return null;
    }

    public static boolean matches(String arg) {
        if (arg == null) {
            return false;
        }
        if (arg.toLowerCase().startsWith("p@")) {
            return true;
        }
        OfflinePlayer returnable = null;
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            if (!player.getName().equalsIgnoreCase(arg)) continue;
            returnable = player;
            break;
        }
        return returnable != null;
    }

    public dPlayer(OfflinePlayer player) {
        if (player == null) {
            return;
        }
        this.player_name = player.getName();
        players.put(this.player_name, this);
    }

    public boolean isValid() {
        return this.getPlayerEntity() != null || this.getOfflinePlayer() != null;
    }

    public Player getPlayerEntity() {
        if (this.player_name == null) {
            return null;
        }
        return Bukkit.getPlayer((String)this.player_name);
    }

    public OfflinePlayer getOfflinePlayer() {
        if (this.player_name == null) {
            return null;
        }
        return Bukkit.getOfflinePlayer((String)this.player_name);
    }

    public dEntity getDenizenEntity() {
        return new dEntity((Entity)this.getPlayerEntity());
    }

    public dNPC getSelectedNPC() {
        if (this.getPlayerEntity().hasMetadata("selected")) {
            return dNPC.valueOf(((MetadataValue)this.getPlayerEntity().getMetadata("selected").get(0)).asString());
        }
        return null;
    }

    public String getName() {
        return this.player_name;
    }

    public dLocation getLocation() {
        if (this.isOnline()) {
            return new dLocation(this.getPlayerEntity().getLocation());
        }
        return null;
    }

    public dLocation getEyeLocation() {
        if (this.isOnline()) {
            return new dLocation(this.getPlayerEntity().getEyeLocation());
        }
        return null;
    }

    public World getWorld() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getWorld();
        }
        return null;
    }

    public boolean isOnline() {
        return this.getPlayerEntity() != null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public dPlayer setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getObjectType() {
        return "Player";
    }

    public String identify() {
        return "p@" + this.player_name;
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (this.player_name == null) {
            return Element.NULL.getAttribute(attribute);
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("chat_history_list")) {
            return new dList(PlayerTags.playerChatHistory.get(this.player_name)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("chat_history")) {
            int x = 1;
            if (attribute.hasContext(1) && aH.matchesInteger(attribute.getContext(1))) {
                x = attribute.getIntContext(1);
            }
            if (!PlayerTags.playerChatHistory.containsKey(this.player_name)) {
                return Element.NULL.getAttribute(attribute.fulfill(1));
            }
            return new Element(PlayerTags.playerChatHistory.get(this.player_name).get(x - 1)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("flag")) {
            if (!attribute.hasContext(1)) {
                return Element.NULL.getAttribute(attribute.fulfill(1));
            }
            String flag_name = attribute.getContext(1);
            attribute.fulfill(1);
            if (attribute.startsWith("is_expired") || attribute.startsWith("isexpired")) {
                return new Element(!FlagManager.playerHasFlag(this, flag_name)).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("size") && !FlagManager.playerHasFlag(this, flag_name)) {
                return new Element(0).getAttribute(attribute.fulfill(1));
            }
            if (FlagManager.playerHasFlag(this, flag_name)) {
                return new dList(DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag(this.getName(), flag_name)).getAttribute(attribute);
            }
            return Element.NULL.getAttribute(attribute);
        }
        if (attribute.startsWith("has_flag")) {
            if (!attribute.hasContext(1)) {
                return Element.NULL.getAttribute(attribute.fulfill(1));
            }
            String flag_name = attribute.getContext(1);
            return new Element(FlagManager.playerHasFlag(this, flag_name)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("current_step")) {
            String outcome = "null";
            if (attribute.hasContext(1)) {
                try {
                    outcome = DenizenAPI.getCurrentInstance().getSaves().getString("Players." + this.getName() + ".Scripts." + dScript.valueOf(attribute.getContext(1)).getName() + ".Current Step");
                }
                catch (Exception e) {
                    outcome = "null";
                }
            }
            return new Element(outcome).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("money")) {
            if (Depends.economy != null) {
                if (attribute.startsWith("money.currency_singular")) {
                    return new Element(Depends.economy.currencyNameSingular()).getAttribute(attribute.fulfill(2));
                }
                if (attribute.startsWith("money.currency")) {
                    return new Element(Depends.economy.currencyNamePlural()).getAttribute(attribute.fulfill(2));
                }
                return new Element(Depends.economy.getBalance(this.player_name)).getAttribute(attribute.fulfill(1));
            }
            dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
            return Element.NULL.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("target")) {
            BlockIterator bi;
            int range = 50;
            int attribs = 1;
            if (attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2) && aH.matchesInteger(attribute.getContext(2))) {
                attribs = 2;
                range = attribute.getIntContext(2);
            }
            List entities = this.getPlayerEntity().getNearbyEntities((double)range, (double)range, (double)range);
            ArrayList<LivingEntity> possibleTargets = new ArrayList<LivingEntity>();
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity)) continue;
                if (attribute.hasContext(1)) {
                    String context = attribute.getContext(1);
                    if (context.toLowerCase().startsWith("li@")) {
                        context = context.substring(3);
                    }
                    for (String ent : context.split("\\|")) {
                        boolean valid = false;
                        if (ent.equalsIgnoreCase("npc") && CitizensAPI.getNPCRegistry().isNPC(entity)) {
                            valid = true;
                        } else if (dEntity.matches(ent)) {
                            if (dEntity.valueOf(ent).isGeneric()) {
                                if (!CitizensAPI.getNPCRegistry().isNPC(entity)) {
                                    valid = true;
                                }
                            } else {
                                valid = true;
                            }
                        }
                        if (!valid) continue;
                        possibleTargets.add((LivingEntity)entity);
                    }
                    continue;
                }
                possibleTargets.add((LivingEntity)entity);
                entity.getType();
            }
            try {
                bi = new BlockIterator((LivingEntity)this.getPlayerEntity(), range);
            }
            catch (IllegalStateException e) {
                return Element.NULL.getAttribute(attribute.fulfill(attribs));
            }
            while (bi.hasNext()) {
                Block b = bi.next();
                int bx = b.getX();
                int by = b.getY();
                int bz = b.getZ();
                if (b.getType() != Material.AIR) break;
                for (LivingEntity possibleTarget : possibleTargets) {
                    Location l = possibleTarget.getLocation();
                    double ex = l.getX();
                    double ey = l.getY();
                    double ez = l.getZ();
                    if (!((double)bx - 0.5 <= ex) || !(ex <= (double)bx + 1.5) || !((double)bz - 0.5 <= ez) || !(ez <= (double)bz + 1.5) || !((double)(by - 1) <= ey) || !(ey <= (double)by + 2.5)) continue;
                    return new dEntity((Entity)possibleTarget).getAttribute(attribute.fulfill(attribs));
                }
            }
            return Element.NULL.getAttribute(attribute.fulfill(attribs));
        }
        if (attribute.startsWith("list")) {
            ArrayList<String> players = new ArrayList<String>();
            if (attribute.startsWith("list.online")) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    players.add(player.getName());
                }
                return new dList((List<String>)players).getAttribute(attribute.fulfill(2));
            }
            if (attribute.startsWith("list.offline")) {
                for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                    if (Bukkit.getOnlinePlayers().toString().contains(player.getName())) continue;
                    players.add(player.getName());
                }
                return new dList((List<String>)players).getAttribute(attribute.fulfill(2));
            }
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                players.add(player.getName());
            }
            return new dList((List<String>)players).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name") && !this.isOnline()) {
            return new Element(this.player_name).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("bed_spawn")) {
            return new dLocation(this.getOfflinePlayer().getBedSpawnLocation()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("first_played")) {
            return new Element(this.getOfflinePlayer().getFirstPlayed()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_played_before")) {
            return new Element(true).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("health.is_scaled")) {
            return new Element(this.getPlayerEntity().isHealthScaled()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health.scale")) {
            return new Element(this.getPlayerEntity().getHealthScale()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("is_banned")) {
            return new Element(this.getOfflinePlayer().isBanned()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_online")) {
            return new Element(this.isOnline()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_op")) {
            return new Element(this.getOfflinePlayer().isOp()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_whitelisted")) {
            return new Element(this.getOfflinePlayer().isWhitelisted()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_played")) {
            return new Element(this.getOfflinePlayer().getLastPlayed()).getAttribute(attribute.fulfill(1));
        }
        if (!this.isOnline()) {
            return new Element(this.identify()).getAttribute(attribute);
        }
        if (attribute.startsWith("selected_npc")) {
            if (this.getPlayerEntity().hasMetadata("selected")) {
                return this.getSelectedNPC().getAttribute(attribute.fulfill(1));
            }
            return Element.NULL.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("entity") && !attribute.startsWith("entity_")) {
            return new dEntity((Entity)this.getPlayerEntity()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ip") || attribute.startsWith("host_name")) {
            return new Element(this.getPlayerEntity().getAddress().getHostName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name.display")) {
            return new Element(this.getPlayerEntity().getDisplayName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("name.list")) {
            return new Element(this.getPlayerEntity().getPlayerListName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("name")) {
            return new Element(this.player_name).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("inventory")) {
            return new dInventory((Inventory)this.getPlayerEntity().getInventory()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("item_on_cursor")) {
            return new dItem(this.getPlayerEntity().getItemOnCursor()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("permission") || attribute.startsWith("has_permission")) {
            if (Depends.permissions == null) {
                dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                return null;
            }
            String permission = attribute.getContext(1);
            if (attribute.getAttribute(2).startsWith("global")) {
                return new Element(Depends.permissions.has((World)null, this.player_name, permission)).getAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).startsWith("world")) {
                return new Element(Depends.permissions.has(attribute.getContext(2), this.player_name, permission)).getAttribute(attribute.fulfill(2));
            }
            return new Element(Depends.permissions.has(this.getPlayerEntity(), permission)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("group") || attribute.startsWith("in_group")) {
            if (Depends.permissions == null) {
                dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                return Element.NULL.getAttribute(attribute.fulfill(1));
            }
            String group = attribute.getContext(1);
            if (attribute.getAttribute(2).startsWith("global")) {
                return new Element(Depends.permissions.playerInGroup((World)null, this.player_name, group)).getAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).startsWith("world")) {
                return new Element(Depends.permissions.playerInGroup(attribute.getContext(2), this.player_name, group)).getAttribute(attribute.fulfill(2));
            }
            return new Element(Depends.permissions.playerInGroup(this.getPlayerEntity(), group)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("compass_target")) {
            return new dLocation(this.getPlayerEntity().getCompassTarget()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("allowed_flight")) {
            return new Element(this.getPlayerEntity().getAllowFlight()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("fly_speed")) {
            return new Element(Float.valueOf(this.getPlayerEntity().getFlySpeed())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("food_level.formatted")) {
            double maxHunger = this.getPlayerEntity().getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHunger = attribute.getIntContext(2);
            }
            if ((double)this.getPlayerEntity().getFoodLevel() / maxHunger < 0.1) {
                return new Element("starving").getAttribute(attribute.fulfill(2));
            }
            if ((double)this.getPlayerEntity().getFoodLevel() / maxHunger < 0.4) {
                return new Element("famished").getAttribute(attribute.fulfill(2));
            }
            if ((double)this.getPlayerEntity().getFoodLevel() / maxHunger < 0.75) {
                return new Element("parched").getAttribute(attribute.fulfill(2));
            }
            if ((double)this.getPlayerEntity().getFoodLevel() / maxHunger < 1.0) {
                return new Element("hungry").getAttribute(attribute.fulfill(2));
            }
            return new Element("healthy").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("saturation")) {
            return new Element(Float.valueOf(this.getPlayerEntity().getSaturation())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("food_level")) {
            return new Element(this.getPlayerEntity().getFoodLevel()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("oxygen.max")) {
            return new Element(this.getPlayerEntity().getMaximumAir()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("oxygen")) {
            return new Element(this.getPlayerEntity().getRemainingAir()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("gamemode.id")) {
            return new Element(this.getPlayerEntity().getGameMode().getValue()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("gamemode")) {
            return new Element(this.getPlayerEntity().getGameMode().name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_blocking")) {
            return new Element(this.getPlayerEntity().isBlocking()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_flying")) {
            return new Element(this.getPlayerEntity().isFlying()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sleeping")) {
            return new Element(this.getPlayerEntity().isSleeping()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sneaking")) {
            return new Element(this.getPlayerEntity().isSneaking()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sprinting")) {
            return new Element(this.getPlayerEntity().isSprinting()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("time_asleep")) {
            return new Duration(this.getPlayerEntity().getSleepTicks() / 20).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("time")) {
            return new Element(this.getPlayerEntity().getPlayerTime()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("walk_speed")) {
            return new Element(Float.valueOf(this.getPlayerEntity().getWalkSpeed())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("weather")) {
            return new Element(this.getPlayerEntity().getPlayerWeather().name()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp.level")) {
            return new Element(this.getPlayerEntity().getLevel()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp.to_next_level")) {
            return new Element(this.getPlayerEntity().getExpToLevel()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp.total")) {
            return new Element(this.getPlayerEntity().getTotalExperience()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp")) {
            return new Element(Float.valueOf(this.getPlayerEntity().getExp() * 100.0f)).getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new dEntity((Entity)this.getPlayerEntity()).getAttribute(attribute);
    }

    public void adjust(Mechanism mechanism) {
        Element value = mechanism.getValue();
        if (mechanism.matches("level") && mechanism.requireInteger()) {
            this.getPlayerEntity().setLevel(value.asInt());
        }
        if (mechanism.matches("award_achievement") && mechanism.requireEnum(false, (Enum<?>[])Achievement.values())) {
            this.getPlayerEntity().awardAchievement(Achievement.valueOf((String)value.asString().toUpperCase()));
        }
        if (mechanism.matches("health_scale") && mechanism.requireDouble()) {
            this.getPlayerEntity().setHealthScale(value.asDouble());
        }
        if (mechanism.matches("scale_health") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setHealthScaled(value.asBoolean());
        }
        if (mechanism.matches("texture_pack")) {
            this.getPlayerEntity().setTexturePack(value.asString());
        }
        if (mechanism.matches("saturation") && mechanism.requireFloat()) {
            this.getPlayerEntity().setSaturation(value.asFloat());
        }
        if (mechanism.matches("food_level") && mechanism.requireInteger()) {
            this.getPlayerEntity().setFoodLevel(value.asInt());
        }
        if (mechanism.matches("bed_spawn_location") && mechanism.requireObject(dLocation.class)) {
            this.getPlayerEntity().setBedSpawnLocation((Location)dLocation.valueOf(value.asString()));
        }
        if (mechanism.matches("fly_speed") && mechanism.requireFloat()) {
            this.getPlayerEntity().setFlySpeed(value.asFloat());
        }
        if (mechanism.matches("weather") && mechanism.requireEnum(false, (Enum<?>[])WeatherType.values())) {
            this.getPlayerEntity().setPlayerWeather(WeatherType.valueOf((String)value.asString().toUpperCase()));
        }
        if (mechanism.matches("reset_weather")) {
            this.getPlayerEntity().resetPlayerWeather();
        }
        if (mechanism.matches("player_list_name")) {
            this.getPlayerEntity().setPlayerListName(value.asString());
        }
        if (mechanism.matches("display_name")) {
            this.getPlayerEntity().setDisplayName(value.asString());
            return;
        }
        if (mechanism.matches("time") && mechanism.requireInteger()) {
            this.getPlayerEntity().setPlayerTime((long)value.asInt(), true);
        }
        if (mechanism.matches("freeze_time")) {
            if (mechanism.requireInteger("Invalid integer specified. Assuming current world time.")) {
                this.getPlayerEntity().setPlayerTime((long)value.asInt(), false);
            } else {
                this.getPlayerEntity().setPlayerTime(this.getPlayerEntity().getWorld().getTime(), false);
            }
        }
        if (mechanism.matches("reset_time")) {
            this.getPlayerEntity().resetPlayerTime();
        }
        if (mechanism.matches("walk_speed") && mechanism.requireFloat()) {
            this.getPlayerEntity().setWalkSpeed(value.asFloat());
        }
        if (!mechanism.fulfilled()) {
            dEntity entity = new dEntity((Entity)this.getPlayerEntity());
            entity.adjust(mechanism);
        }
    }
}

