/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.bukkit.ScriptEntryExecuteEvent;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.Debuggable;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

public class CommandExecuter {
    private final Denizen plugin;
    private static final Pattern definition_pattern = Pattern.compile("%(.+?)%");

    public CommandExecuter(Denizen denizen) {
        this.plugin = denizen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ScriptEntry scriptEntry) {
        Matcher m = definition_pattern.matcher(scriptEntry.getCommandName());
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String definition = scriptEntry.getResidingQueue().getDefinition(m.group(1));
            if (definition == null) {
                definition = "null";
            }
            m.appendReplacement(sb, definition);
        }
        m.appendTail(sb);
        scriptEntry.setCommandName(sb.toString());
        if (this.plugin.getCommandRegistry().get(scriptEntry.getCommandName()) == null) {
            dB.echoDebug(scriptEntry, dB.DebugElement.Header, "Executing command: " + scriptEntry.getCommandName());
            dB.echoError(scriptEntry.getCommandName() + " is an invalid dCommand! Are you sure it loaded?");
            dB.echoDebug((Debuggable)scriptEntry, dB.DebugElement.Footer);
            return false;
        }
        AbstractCommand command = this.plugin.getCommandRegistry().get(scriptEntry.getCommandName());
        if (scriptEntry.getPlayer() != null) {
            dB.echoDebug(scriptEntry, dB.DebugElement.Header, "Executing dCommand: " + scriptEntry.getCommandName() + "/" + scriptEntry.getPlayer().getName());
        } else {
            dB.echoDebug(scriptEntry, dB.DebugElement.Header, "Executing dCommand: " + scriptEntry.getCommandName() + (scriptEntry.getNPC() != null ? "/" + scriptEntry.getNPC().getName() : ""));
        }
        boolean keepGoing = true;
        try {
            if (command.getOptions().REQUIRED_ARGS > scriptEntry.getArguments().size()) {
                throw new InvalidArgumentsException("");
            }
            if (scriptEntry.has_tags) {
                scriptEntry.setArguments(TagManager.fillArguments(scriptEntry.getArguments(), scriptEntry, true));
            }
            ArrayList<String> newArgs = new ArrayList<String>();
            int nested_depth = 0;
            boolean if_ignore = false;
            for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
                String value;
                if (arg.getValue().equals("{")) {
                    ++nested_depth;
                }
                if (arg.getValue().equals("}")) {
                    --nested_depth;
                }
                if (nested_depth > 0) {
                    newArgs.add(arg.raw_value);
                    continue;
                }
                m = definition_pattern.matcher(arg.raw_value);
                sb = new StringBuffer();
                while (m.find()) {
                    String definition = scriptEntry.getResidingQueue().getDefinition(m.group(1));
                    if (definition == null) {
                        definition = "null";
                    }
                    m.appendReplacement(sb, definition);
                }
                m.appendTail(sb);
                arg = aH.Argument.valueOf(sb.toString());
                if (command.getName().equalsIgnoreCase("if") && DenizenAPI.getCurrentInstance().getCommandRegistry().get(arg.getValue()) != null) {
                    if_ignore = true;
                }
                if (arg.matchesPrefix("player") && !if_ignore) {
                    dB.echoDebug((Debuggable)scriptEntry, "...replacing the linked player with " + arg.getValue());
                    value = TagManager.tag(scriptEntry.getPlayer(), scriptEntry.getNPC(), arg.getValue(), false, scriptEntry);
                    dPlayer player = dPlayer.valueOf(value);
                    if (player == null || !player.isValid()) {
                        dB.echoError(value + " is an invalid player!");
                        boolean bl = false;
                        return bl;
                    }
                    scriptEntry.setPlayer(player);
                    continue;
                }
                if (arg.matchesPrefix("npc, npcid") && !if_ignore) {
                    dB.echoDebug((Debuggable)scriptEntry, "...replacing the linked NPC with " + arg.getValue());
                    value = TagManager.tag(scriptEntry.getPlayer(), scriptEntry.getNPC(), arg.getValue(), false, scriptEntry);
                    dNPC npc = dNPC.valueOf(value);
                    if (npc == null || !npc.isValid()) {
                        dB.echoError(value + " is an invalid NPC!");
                        boolean bl = false;
                        return bl;
                    }
                    scriptEntry.setNPC(npc);
                    continue;
                }
                if (arg.matchesPrefix("save") && !if_ignore) {
                    dB.echoDebug((Debuggable)scriptEntry, "...remembering this script entry!");
                    scriptEntry.getResidingQueue().holdScriptEntry(arg.getValue(), scriptEntry);
                    continue;
                }
                newArgs.add(arg.raw_value);
            }
            scriptEntry.setArguments(newArgs);
            if (scriptEntry.has_tags) {
                scriptEntry.setArguments(TagManager.fillArguments(scriptEntry.getArguments(), scriptEntry, false));
            }
            command.parseArgs(scriptEntry);
        }
        catch (InvalidArgumentsException e) {
            keepGoing = false;
            dB.echoError("Woah! Invalid arguments were specified!");
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                dB.log(ChatColor.YELLOW + "+> MESSAGE follows: " + ChatColor.WHITE + "'" + e.getMessage() + "'");
            }
            dB.log("Usage: " + command.getUsageHint());
            dB.echoDebug((Debuggable)scriptEntry, dB.DebugElement.Footer);
        }
        catch (Exception e) {
            keepGoing = false;
            dB.echoError("Woah! An exception has been called with this command!");
            dB.echoError(e);
            dB.echoDebug((Debuggable)scriptEntry, dB.DebugElement.Footer);
        }
        finally {
            if (keepGoing) {
                try {
                    ScriptEntryExecuteEvent event = new ScriptEntryExecuteEvent(scriptEntry);
                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                    if (event.isAltered()) {
                        scriptEntry = event.getScriptEntry();
                    }
                    if (!event.isCancelled()) {
                        command.execute(scriptEntry);
                    } else {
                        dB.echoDebug((Debuggable)scriptEntry, "ScriptEntry has been cancelled.");
                    }
                }
                catch (Exception e) {
                    dB.echoError("Woah!! An exception has been called with this command!");
                    dB.echoError(e);
                }
            }
        }
        return true;
    }
}

