/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.commands.core.CooldownCommand;
import net.aufdemrand.denizen.scripts.commands.core.FailCommand;
import net.aufdemrand.denizen.scripts.commands.core.FinishCommand;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class ResetCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matches("finishes, finished, finish") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.FINISH);
                continue;
            }
            if (arg.matches("fails, failed, fail") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.FAIL);
                continue;
            }
            if (arg.matches("cooldown") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.PLAYER_COOLDOWN);
                continue;
            }
            if (arg.matches("global_cooldown") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.GLOBAL_COOLDOWN);
                continue;
            }
            if (arg.matches("saves") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.SAVES);
                continue;
            }
            if (arg.matchesArgumentType(dScript.class)) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (arg.matchesArgumentList(dPlayer.class)) {
                scriptEntry.addObject("players", arg.asType(dList.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.getObject("type").equals((Object)Type.GLOBAL_COOLDOWN)) {
            scriptEntry.defaultObject("players", scriptEntry.getPlayer());
        }
        if (!scriptEntry.hasObject("script") && !scriptEntry.getObject("type").equals((Object)Type.SAVES)) {
            throw new InvalidArgumentsException("Must specify a script!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dObject player = scriptEntry.getdObject("players");
        dList players = player instanceof dPlayer ? new dList(player.identify()) : (dList)scriptEntry.getdObject("players");
        Element type = (Element)scriptEntry.getdObject("type");
        dScript script = (dScript)scriptEntry.getObject("script");
        dB.report(scriptEntry, this.getName(), (players != null ? players.debug() : "") + type.debug() + (script != null ? script.debug() : ""));
        if (Type.valueOf(type.asString()) == Type.GLOBAL_COOLDOWN) {
            CooldownCommand.setCooldown(null, Duration.ZERO, script.getName(), true);
            return;
        }
        for (String object : players) {
            dPlayer resettable = dPlayer.valueOf(object);
            if (!resettable.isValid()) continue;
            switch (Type.valueOf(type.asString())) {
                case FAIL: {
                    FailCommand.resetFails(resettable.getName(), script.getName());
                    return;
                }
                case FINISH: {
                    FinishCommand.resetFinishes(resettable.getName(), script.getName());
                    return;
                }
                case PLAYER_COOLDOWN: {
                    CooldownCommand.setCooldown(resettable.getName(), Duration.ZERO, script.getName(), false);
                    return;
                }
                case SAVES: {
                    DenizenAPI.getCurrentInstance().getSaves().set("Players." + resettable.getName(), null);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        FINISH,
        FAIL,
        PLAYER_COOLDOWN,
        GLOBAL_COOLDOWN,
        SAVES;

    }
}

