/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.traits.HealthTrait;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class HealthCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("target") && arg.matches("player")) {
                if (!scriptEntry.hasPlayer()) {
                    throw new InvalidArgumentsException("No player attached!");
                }
                scriptEntry.addObject("target", Arrays.asList(scriptEntry.getPlayer()));
                continue;
            }
            if (!scriptEntry.hasObject("qty") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("qty", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("target", arg.asType(dList.class).filter(dEntity.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("state")) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("qty") && !scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a quantity!");
        }
        if (!scriptEntry.hasObject("target")) {
            if (!scriptEntry.hasNPC()) {
                throw new InvalidArgumentsException("Missing NPC!");
            }
            scriptEntry.addObject("target", Arrays.asList(scriptEntry.getNPC()));
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element qty = scriptEntry.getElement("qty");
        Element action = scriptEntry.getElement("action");
        List targets = (List)scriptEntry.getObject("target");
        dB.report(scriptEntry, this.getName(), (qty != null ? qty.debug() : "") + (action != null ? action.debug() : "") + aH.debugObj("target", targets.toString()));
        if (qty == null && action == null) {
            dB.echoError("Null quantity!");
        }
        if (action == null) {
            action = Element.TRUE;
        }
        for (dEntity target : targets) {
            if (target.isNPC()) {
                if (action.asString().equalsIgnoreCase("true")) {
                    target.getNPC().addTrait(HealthTrait.class);
                } else if (action.asString().equalsIgnoreCase("false")) {
                    target.getNPC().removeTrait(HealthTrait.class);
                } else if (target.getNPC().hasTrait(HealthTrait.class)) {
                    target.getNPC().removeTrait(HealthTrait.class);
                } else {
                    target.getNPC().addTrait(HealthTrait.class);
                }
            }
            if (qty == null) continue;
            if (target.isNPC()) {
                if (target.getNPC().hasTrait(HealthTrait.class)) {
                    ((HealthTrait)target.getNPC().getTrait(HealthTrait.class)).setMaxhealth(qty.asInt());
                    continue;
                }
                dB.echoError("NPC doesn't have health trait!");
                continue;
            }
            if (target.isLivingEntity()) {
                target.getLivingEntity().setMaxHealth(qty.asDouble());
                continue;
            }
            dB.echoError("Entity '" + target.identify() + "'is not alive!");
        }
    }
}

