/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.plugin.Plugin;

public class DisplayItemCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesArgumentType(Duration.class) && !scriptEntry.hasObject("duration")) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (arg.matchesArgumentType(dLocation.class) && !scriptEntry.hasObject("location")) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class) && !scriptEntry.hasObject("item")) {
                scriptEntry.addObject("item", arg.asType(dItem.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("item")) {
            throw new InvalidArgumentsException("Must specify an item to display.");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        if (!scriptEntry.hasObject("duration")) {
            scriptEntry.addObject("duration", Duration.valueOf("1m"));
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dItem item = (dItem)scriptEntry.getObject("item");
        Duration duration = (Duration)scriptEntry.getObject("duration");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        dB.report(scriptEntry, this.getName(), item.debug() + duration.debug() + location.debug());
        final Item dropped = location.getBlock().getLocation().add(0.0, 1.0, 0.0).getWorld().dropItem((Location)location, item.getItemStack());
        dropped.setPickupDelay(Integer.MAX_VALUE);
        dropped.setTicksLived(Integer.MAX_VALUE);
        scriptEntry.addObject("dropped", new dEntity((Entity)dropped));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                if (dropped.isValid() && !dropped.isDead()) {
                    dropped.remove();
                }
            }
        }, duration.getTicks());
    }
}

