/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.trait.trait.Spawned;

public class DespawnCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("npcs") && arg.matchesArgumentList(dNPC.class)) {
                scriptEntry.addObject("npcs", arg.asType(dList.class).filter(dNPC.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("npcs")) {
            if (scriptEntry.hasNPC()) {
                scriptEntry.addObject("npcs", Arrays.asList(scriptEntry.getNPC()));
            } else {
                throw new InvalidArgumentsException("Must specify a valid list of NPCs!");
            }
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List npcs = (List)scriptEntry.getObject("npcs");
        dB.report(scriptEntry, this.getName(), aH.debugObj("NPCs", npcs.toString()));
        for (dNPC npc : npcs) {
            if (!npc.isSpawned()) continue;
            if (npc.getCitizen().hasTrait(Spawned.class)) {
                ((Spawned)npc.getCitizen().getTrait(Spawned.class)).setSpawned(false);
            }
            npc.getCitizen().despawn(DespawnReason.PLUGIN);
        }
    }
}

