/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.trait.Poses;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PoseCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matches("add, assume, remove")) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (arg.matchesPrefix("id")) {
                scriptEntry.addObject("pose_id", arg.getValue());
                continue;
            }
            if (arg.matches("player")) {
                scriptEntry.addObject("target", (Object)TargetType.PLAYER);
                continue;
            }
            if (!arg.matchesArgumentType(dLocation.class)) continue;
            scriptEntry.addObject("pose_loc", arg.asType(dLocation.class));
        }
        if (!scriptEntry.hasNPC()) {
            throw new InvalidArgumentsException("This command requires an NPC!");
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("No ID specified!");
        }
        scriptEntry.defaultObject("target", new Object[]{TargetType.NPC});
        scriptEntry.defaultObject("action", new Object[]{Action.ASSUME});
        if (scriptEntry.getObject("target") == TargetType.PLAYER) {
            if (scriptEntry.getObject("action") != Action.ASSUME) {
                throw new InvalidArgumentsException("You cannot add or remove poses from a player.");
            }
            if (!scriptEntry.hasPlayer()) {
                throw new InvalidArgumentsException("This command requires a linked player!");
            }
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        TargetType target = (TargetType)((Object)scriptEntry.getObject("target"));
        dNPC npc = scriptEntry.getNPC();
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        String id = (String)scriptEntry.getObject("pose_id");
        dLocation pose_loc = (dLocation)scriptEntry.getObject("pose_loc");
        dB.report(scriptEntry, this.getName(), aH.debugObj("Target", target.toString()) + (target == TargetType.PLAYER ? scriptEntry.getPlayer().debug() : "") + npc.debug() + aH.debugObj("Action", action.toString()) + aH.debugObj("Id", id) + (pose_loc != null ? pose_loc.debug() : ""));
        if (!npc.getCitizen().hasTrait(Poses.class)) {
            npc.getCitizen().addTrait(Poses.class);
        }
        Poses poses = (Poses)npc.getCitizen().getTrait(Poses.class);
        switch (action) {
            case ASSUME: {
                if (!poses.hasPose(id)) {
                    throw new CommandExecutionException("Pose \"" + id + "\" doesn't exist for " + npc.toString());
                }
                if (target.name().equals("NPC")) {
                    poses.assumePose(id);
                    break;
                }
                Player player = scriptEntry.getPlayer().getPlayerEntity();
                Location location = player.getLocation();
                location.setYaw(poses.getPose(id).getYaw());
                location.setPitch(poses.getPose(id).getPitch());
                player.teleport(location);
                break;
            }
            case ADD: {
                if (poses.addPose(id, (Location)pose_loc)) break;
                throw new CommandExecutionException(npc.toString() + " already has that pose!");
            }
            case REMOVE: {
                if (poses.removePose(id)) break;
                throw new CommandExecutionException(npc.toString() + " does not have that pose!");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        ADD,
        REMOVE,
        ASSUME;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TargetType {
        NPC,
        PLAYER;

    }
}

