/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.util.List;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.bukkit.ReplaceableTagEvent;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.utilities.debugging.Debuggable;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ProcedureScriptTag
implements Listener {
    public ProcedureScriptTag(Denizen denizen) {
        denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
    }

    @EventHandler
    public void procedureTag(ReplaceableTagEvent event) {
        if (!event.matches("proc, pr")) {
            return;
        }
        dScript script = null;
        if (event.hasNameContext()) {
            script = dScript.valueOf(event.getNameContext());
        } else if (event.getValue() != null) {
            script = dScript.valueOf(event.getValue());
        } else {
            dB.echoError("Invalid procedure script tag '" + event.getValue() + "'!");
            return;
        }
        if (script == null) {
            dB.echoError("Missing script for procedure script tag '" + event.getValue() + "'!");
            return;
        }
        List<ScriptEntry> entries = script.getContainer().getBaseEntries(event.getPlayer(), event.getNPC());
        if (entries.isEmpty()) {
            return;
        }
        long id = DetermineCommand.getNewId();
        ScriptBuilder.addObjectToEntries(entries, "ReqId", id);
        InstantQueue queue = InstantQueue.getQueue(ScriptQueue._getNextId());
        queue.addEntries(entries);
        if (event.hasType() && event.getType().equalsIgnoreCase("context") && event.hasTypeContext()) {
            int x = 1;
            dList definitions = new dList(event.getTypeContext());
            String[] definition_names = null;
            try {
                definition_names = script.getContainer().getString("definitions").split("\\|");
            }
            catch (Exception e) {
                // empty catch block
            }
            for (String definition : definitions) {
                String name = definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x);
                queue.addDefinition(name, definition);
                dB.echoDebug((Debuggable)event.getScriptEntry(), "Adding definition %" + name + "% as " + definition);
                ++x;
            }
        }
        queue.start();
        if (DetermineCommand.hasOutcome(id)) {
            event.setReplaced(DetermineCommand.getOutcome(id));
        }
    }
}

