/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.utilities.ReflectionUtil;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ParticleEffect {
    HUGE_EXPLOSION("hugeexplosion", 0),
    LARGE_EXPLODE("largeexplode", 1),
    FIREWORKS_SPARK("fireworksSpark", 2),
    BUBBLE("bubble", 3),
    SUSPEND("suspend", 4),
    DEPTH_SUSPEND("depthSuspend", 5),
    TOWN_AURA("townaura", 6),
    CRIT("crit", 7),
    MAGIC_CRIT("magicCrit", 8),
    MOB_SPELL("mobSpell", 9),
    MOB_SPELL_AMBIENT("mobSpellAmbient", 10),
    SPELL("spell", 11),
    INSTANT_SPELL("instantSpell", 12),
    WITCH_MAGIC("witchMagic", 13),
    NOTE("note", 14),
    PORTAL("portal", 15),
    ENCHANTMENT_TABLE("enchantmenttable", 16),
    EXPLODE("explode", 17),
    FLAME("flame", 18),
    LAVA("lava", 19),
    FOOTSTEP("footstep", 20),
    SPLASH("splash", 21),
    LARGE_SMOKE("largesmoke", 22),
    CLOUD("cloud", 23),
    RED_DUST("reddust", 24),
    SNOWBALL_POOF("snowballpoof", 25),
    DRIP_WATER("dripWater", 26),
    DRIP_LAVA("dripLava", 27),
    SNOW_SHOVEL("snowshovel", 28),
    SLIME("slime", 29),
    HEART("heart", 30),
    ANGRY_VILLAGER("angryVillager", 31),
    HAPPY_VILLAGER("happyVillager", 32);

    private static final Map<String, ParticleEffect> NAME_MAP;
    private static final Map<Integer, ParticleEffect> ID_MAP;
    private static final double MAX_RANGE = 100.0;
    private static Constructor<?> PARTICLE_PACKET_CONSTRUCTOR;
    private String name;
    private int id;

    private ParticleEffect(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public static ParticleEffect fromName(String name) {
        if (name != null) {
            for (Map.Entry<String, ParticleEffect> e : NAME_MAP.entrySet()) {
                if (!e.getKey().equalsIgnoreCase(name)) continue;
                return e.getValue();
            }
        }
        return null;
    }

    public static ParticleEffect fromId(int id) {
        return ID_MAP.get(id);
    }

    private static List<Player> getPlayersInRange(Location loc, double range) {
        ArrayList<Player> players = new ArrayList<Player>();
        double sqr = range * range;
        for (Player p : loc.getWorld().getPlayers()) {
            if (!(p.getLocation().distanceSquared(loc) <= sqr)) continue;
            players.add(p);
        }
        return players;
    }

    private static Object createPacket(String name, Location loc, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("Amount of particles has to be greater than 0");
        }
        try {
            Object p = PARTICLE_PACKET_CONSTRUCTOR.newInstance(new Object[0]);
            ReflectionUtil.setValues(p, new ReflectionUtil.FieldEntry("a", name), new ReflectionUtil.FieldEntry("b", Float.valueOf((float)loc.getX())), new ReflectionUtil.FieldEntry("c", Float.valueOf((float)loc.getY())), new ReflectionUtil.FieldEntry("d", Float.valueOf((float)loc.getZ())), new ReflectionUtil.FieldEntry("e", Float.valueOf(offsetX)), new ReflectionUtil.FieldEntry("f", Float.valueOf(offsetY)), new ReflectionUtil.FieldEntry("g", Float.valueOf(offsetZ)), new ReflectionUtil.FieldEntry("h", Float.valueOf(speed)), new ReflectionUtil.FieldEntry("i", amount));
            return p;
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("[ParticleEffect] Failed to create a particle packet!");
            return null;
        }
    }

    private Object createPacket(Location loc, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        return ParticleEffect.createPacket(this.getName(), loc, offsetX, offsetY, offsetZ, speed, amount);
    }

    private static Object createIconCrackPacket(int id, Location loc, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        return ParticleEffect.createPacket("iconcrack_" + id, loc, offsetX, offsetY, offsetZ, speed, amount);
    }

    private static Object createBlockCrackPacket(int id, byte data, Location loc, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        return ParticleEffect.createPacket("blockcrack_" + id + "_" + data, loc, offsetX, offsetY, offsetZ, speed, amount);
    }

    private static Object createBlockDustPacket(int id, byte data, Location loc, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        return ParticleEffect.createPacket("blockdust_" + id + "_" + data, loc, offsetX, offsetY, offsetZ, speed, amount);
    }

    private static void sendPacket(Player p, Object packet) {
        if (packet != null && !CitizensAPI.getNPCRegistry().isNPC((Entity)p)) {
            try {
                Object entityPlayer = ReflectionUtil.invokeMethod("getHandle", p.getClass(), p, new Object[0]);
                Object playerConnection = ReflectionUtil.getValue("playerConnection", entityPlayer);
                ReflectionUtil.invokeMethod("sendPacket", playerConnection.getClass(), playerConnection, packet);
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("[ParticleEffect] Failed to send a particle packet to " + p.getName() + "!");
            }
        }
    }

    private static void sendPacket(Collection<Player> players, Object packet) {
        for (Player p : players) {
            ParticleEffect.sendPacket(p, packet);
        }
    }

    public void display(Location loc, float offsetX, float offsetY, float offsetZ, float speed, int amount, Player ... players) {
        ParticleEffect.sendPacket(Arrays.asList(players), this.createPacket(loc, offsetX, offsetY, offsetZ, speed, amount));
    }

    public void display(Location loc, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        this.display(loc, 100.0, offsetX, offsetY, offsetZ, speed, amount);
    }

    public void display(Location loc, double range, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (range > 100.0) {
            throw new IllegalArgumentException("Effect radius must be less than or equal to the maximum range of 100 blocks");
        }
        ParticleEffect.sendPacket(ParticleEffect.getPlayersInRange(loc, range), this.createPacket(loc, offsetX, offsetY, offsetZ, speed, amount));
    }

    public static void displayIconCrack(Location loc, int id, float offsetX, float offsetY, float offsetZ, float speed, int amount, Player ... players) {
        ParticleEffect.sendPacket(Arrays.asList(players), ParticleEffect.createIconCrackPacket(id, loc, offsetX, offsetY, offsetZ, speed, amount));
    }

    public static void displayIconCrack(Location loc, int id, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        ParticleEffect.displayIconCrack(loc, 100.0, id, offsetX, offsetY, offsetZ, speed, amount);
    }

    public static void displayIconCrack(Location loc, double range, int id, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (range > 100.0) {
            throw new IllegalArgumentException("Effect radius must be less than or equal to the maximum range of 100 blocks");
        }
        ParticleEffect.sendPacket(ParticleEffect.getPlayersInRange(loc, range), ParticleEffect.createIconCrackPacket(id, loc, offsetX, offsetY, offsetZ, speed, amount));
    }

    public static void displayBlockCrack(Location loc, int id, byte data, float offsetX, float offsetY, float offsetZ, float speed, int amount, Player ... players) {
        ParticleEffect.sendPacket(Arrays.asList(players), ParticleEffect.createBlockCrackPacket(id, data, loc, offsetX, offsetY, offsetZ, speed, amount));
    }

    public static void displayBlockCrack(Location loc, int id, byte data, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        ParticleEffect.displayBlockCrack(loc, 100.0, id, data, offsetX, offsetY, offsetZ, speed, amount);
    }

    public static void displayBlockCrack(Location loc, double range, int id, byte data, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (range > 100.0) {
            throw new IllegalArgumentException("Effect radius must be less than or equal to the maximum range of 100 blocks");
        }
        ParticleEffect.sendPacket(ParticleEffect.getPlayersInRange(loc, range), ParticleEffect.createBlockCrackPacket(id, data, loc, offsetX, offsetY, offsetZ, speed, amount));
    }

    public static void displayBlockDust(Location loc, int id, byte data, float offsetX, float offsetY, float offsetZ, float speed, int amount, Player ... players) {
        ParticleEffect.sendPacket(Arrays.asList(players), ParticleEffect.createBlockDustPacket(id, data, loc, offsetX, offsetY, offsetZ, speed, amount));
    }

    public static void displayBlockDust(Location loc, int id, byte data, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        ParticleEffect.displayBlockDust(loc, 100.0, id, data, offsetX, offsetY, offsetZ, speed, amount);
    }

    public static void displayBlockDust(Location loc, double range, int id, byte data, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (range > 100.0) {
            throw new IllegalArgumentException("Effect radius must be less than or equal to the maximum range of 100 blocks");
        }
        ParticleEffect.sendPacket(ParticleEffect.getPlayersInRange(loc, range), ParticleEffect.createBlockDustPacket(id, data, loc, offsetX, offsetY, offsetZ, speed, amount));
    }

    static {
        NAME_MAP = new HashMap<String, ParticleEffect>();
        ID_MAP = new HashMap<Integer, ParticleEffect>();
        for (ParticleEffect effect : ParticleEffect.values()) {
            NAME_MAP.put(effect.name, effect);
            ID_MAP.put(effect.id, effect);
        }
        try {
            PARTICLE_PACKET_CONSTRUCTOR = ReflectionUtil.getConstructor(ReflectionUtil.getClass("PacketPlayOutWorldParticles", ReflectionUtil.DynamicPackage.MINECRAFT_SERVER), new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

