/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.debugging;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.debugging.Debuggable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import sun.reflect.Reflection;

public class dB {
    public static boolean showDebug = Settings.ShowDebug();
    public static boolean showStackTraces = true;
    public static boolean showScriptBuilder = false;
    public static boolean showColor = true;
    public static boolean showEventsTrimming = false;
    public static List<String> filter = new ArrayList<String>();
    public static boolean shouldTrim = true;
    public static int trimSize = 512;
    public static boolean record = false;
    public static StringBuilder Recording = new StringBuilder();
    private static final Map<Class<?>, String> classNameCache = new WeakHashMap();

    public static void toggle() {
        showDebug = !showDebug;
    }

    public static void report(Debuggable caller, String name, String report) {
        if (!showDebug) {
            return;
        }
        dB.echo("<Y>+> <G>Executing '<Y>" + name + "<G>': " + dB.trimMessage(report), caller);
        if (caller instanceof ScriptEntry && ((ScriptEntry)caller).hasPlayer() && FlagManager.playerHasFlag(((ScriptEntry)caller).getPlayer(), "show_command_reports")) {
            String message = "<Y>+> <G>Executing '<Y>" + name + "<G>': " + dB.trimMessage(report);
            ((ScriptEntry)caller).getPlayer().getPlayerEntity().sendRawMessage(message.replace("<Y>", ChatColor.YELLOW.toString()).replace("<G>", ChatColor.DARK_GRAY.toString()).replace("<A>", ChatColor.AQUA.toString()));
        }
    }

    public static void echoDebug(Debuggable caller, DebugElement element) {
        if (!showDebug) {
            return;
        }
        dB.echoDebug(caller, element, null);
    }

    public static void echoDebug(Debuggable caller, DebugElement element, String string) {
        if (!showDebug) {
            return;
        }
        StringBuilder sb = new StringBuilder(24);
        switch (element) {
            case Footer: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+---------------------+");
                break;
            }
            case Header: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+- ").append(string).append(" ---------+");
            }
        }
        dB.echo(sb.toString(), caller);
    }

    public static void echoDebug(Debuggable caller, String message) {
        if (!showDebug) {
            return;
        }
        dB.echo(ChatColor.LIGHT_PURPLE + " " + ChatColor.WHITE + dB.trimMessage(message), caller);
    }

    @Deprecated
    public static void echoDebug(String message) {
        dB.echo(message, null);
    }

    @Deprecated
    public static void echoDebug(DebugElement de, String message) {
        dB.echoDebug(null, de, message);
    }

    public static void echoApproval(String message) {
        if (!showDebug) {
            return;
        }
        ConsoleSender.sendMessage(ChatColor.LIGHT_PURPLE + " " + ChatColor.GREEN + "OKAY! " + ChatColor.WHITE + message);
    }

    public static void echoError(String message) {
        if (!showDebug) {
            return;
        }
        ConsoleSender.sendMessage(ChatColor.LIGHT_PURPLE + " " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + dB.trimMessage(message));
    }

    public static void echoError(Throwable ex) {
        if (!showDebug) {
            return;
        }
        if (!showStackTraces) {
            dB.echoError("Exception! Enable '/denizen debug -s' for the nitty-gritty.");
        } else {
            ex.printStackTrace();
            if (record) {
                String prefix = ConsoleSender.dateFormat.format(new Date()) + " [SEVERE] ";
                Recording.append(URLEncoder.encode(prefix + ex.toString() + "\n"));
                for (StackTraceElement ste : ex.getStackTrace()) {
                    Recording.append(URLEncoder.encode(prefix + ste.toString() + "\n"));
                }
            }
        }
    }

    public static void log(String message) {
        if (!showDebug) {
            return;
        }
        Class caller = Reflection.getCallerClass((int)2);
        String callerName = classNameCache.get(caller);
        if (callerName == null) {
            callerName = caller.getSimpleName();
            classNameCache.put(caller, callerName);
        }
        ConsoleSender.sendMessage(ChatColor.YELLOW + "+> [" + (callerName.length() > 16 ? callerName.substring(0, 12) + "..." : callerName) + "] " + ChatColor.WHITE + dB.trimMessage(message));
    }

    public static void log(DebugElement element, String string) {
        if (!showDebug) {
            return;
        }
        StringBuilder sb = new StringBuilder(24);
        switch (element) {
            case Footer: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+---------------------+");
                break;
            }
            case Header: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+- ").append(string).append(" ---------+");
                break;
            }
        }
        ConsoleSender.sendMessage(sb.toString());
    }

    private static String trimMessage(String message) {
        if (!shouldTrim) {
            return message;
        }
        if (message.length() > trimSize) {
            message = message.substring(0, trimSize - 1) + "... * snip! *";
        }
        return message;
    }

    private static void echo(String string, Debuggable caller) {
        boolean should_send;
        block6: {
            should_send = true;
            if (caller != null) {
                try {
                    if (filter.isEmpty()) {
                        should_send = caller.shouldDebug();
                        break block6;
                    }
                    should_send = false;
                    for (String criteria : filter) {
                        if (!caller.shouldFilter(criteria)) continue;
                        should_send = true;
                        break;
                    }
                }
                catch (Exception e) {
                    should_send = true;
                }
            }
        }
        if (should_send) {
            ConsoleSender.sendMessage(string);
        }
    }

    private static class ConsoleSender {
        static CommandSender commandSender = null;
        public static SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        static boolean skipFooter = false;

        private ConsoleSender() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void sendMessage(String string) {
            if (commandSender == null) {
                commandSender = Bukkit.getServer().getConsoleSender();
            }
            if ((string = TagManager.CleanOutputFully(string.replace("<Y>", ChatColor.YELLOW.toString()).replace("<G>", ChatColor.DARK_GRAY.toString()).replace("<A>", ChatColor.AQUA.toString()))).equals(ChatColor.LIGHT_PURPLE + "+---------------------+")) {
                if (skipFooter) return;
                skipFooter = true;
            } else {
                skipFooter = false;
            }
            String[] words = string.split(" ");
            StringBuilder buffer = new StringBuilder();
            int length = 0;
            for (String word : words) {
                int strippedLength = ChatColor.stripColor((String)word).length() + 1;
                if (length + strippedLength < Settings.ConsoleWidth()) {
                    buffer.append(word).append(" ");
                    length += strippedLength;
                    continue;
                }
                length = strippedLength;
                buffer.append("\n                   ").append(word).append(" ");
            }
            String result = buffer.toString();
            if (record) {
                Recording.append(URLEncoder.encode(dateFormat.format(new Date()) + " [INFO] " + result.replace('\u00a7', '\u0001') + "\n"));
            }
            commandSender.sendMessage(showColor ? result : ChatColor.stripColor((String)result));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebugElement {
        Header,
        Footer,
        Spacer;

    }
}

