/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.events.EventManager;
import net.aufdemrand.denizen.events.SmartEvent;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CuboidEnterExitSmartEvent
implements SmartEvent,
Listener {
    ArrayList<String> cuboids_to_watch = new ArrayList();
    private boolean broad_detection = false;
    private Map<String, List<dCuboid>> player_cuboids = new ConcurrentHashMap<String, List<dCuboid>>();

    @Override
    public boolean shouldInitialize(Set<String> events) {
        boolean should_register = false;
        for (String event : events) {
            Matcher m = Pattern.compile("on player (?:enters|exits) (notable cuboid|cu@\\w+)", 2).matcher(event);
            if (!m.matches()) continue;
            boolean registerable = true;
            if (m.group(1).equalsIgnoreCase("notable cuboid")) {
                this.broad_detection = true;
            } else if (!dCuboid.matches(m.group(1))) {
                dB.echoError("Possible issue with '" + event + "' world event in script(s) " + EventManager.events.get(event) + ". Specified cuboid is not valid.");
                registerable = false;
            } else {
                this.cuboids_to_watch.add(m.group(1).toLowerCase());
            }
            if (!registerable) continue;
            should_register = true;
        }
        return should_register;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Cuboid Enter & Exit SmartEvent.");
    }

    @Override
    public void breakDown() {
        PlayerMoveEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void playerMoveEvent(PlayerMoveEvent event) {
        String determination;
        if (event.getFrom().getBlock().equals(event.getTo().getBlock())) {
            return;
        }
        ArrayList<String> events = new ArrayList<String>();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(event.getTo());
        List<Object> match = new ArrayList();
        if (this.player_cuboids.containsKey(event.getPlayer().getName().toLowerCase())) {
            match = this.player_cuboids.get(event.getPlayer().getName().toLowerCase());
        }
        ArrayList exits = new ArrayList(match);
        exits.removeAll(cuboids);
        ArrayList<dCuboid> enters = new ArrayList<dCuboid>(cuboids);
        enters.removeAll(match);
        if (exits.isEmpty() && enters.isEmpty()) {
            return;
        }
        if (!exits.isEmpty()) {
            for (dCuboid cuboid : exits) {
                events.add("player exits " + cuboid.identify());
            }
        }
        if (!enters.isEmpty()) {
            for (dCuboid cuboid : enters) {
                events.add("player enters " + cuboid.identify());
            }
        }
        if ((determination = EventManager.doEvents(events, null, event.getPlayer(), context, true)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        this.player_cuboids.put(event.getPlayer().getName().toLowerCase(), cuboids);
    }
}

