/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.events.EventManager;
import net.aufdemrand.denizen.events.SmartEvent;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitySpawnSmartEvent
implements SmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        boolean should_register = false;
        for (String event : events) {
            Matcher m = Pattern.compile("on (.+|entity|npc) spawns(?: because (\\w+))?", 2).matcher(event);
            if (!m.matches()) continue;
            boolean registerable = true;
            if (!(dEntity.matches(m.group(1)) || m.group(1).equalsIgnoreCase("entity") || m.group(1).equalsIgnoreCase("npc"))) {
                dB.echoError("Possible issue with '" + event + "' world event in script(s) " + EventManager.events.get(event) + ". Specified entity is not valid.");
                registerable = false;
            }
            if (m.group(2) != null && CreatureSpawnEvent.SpawnReason.valueOf((String)m.group(2).toUpperCase()) == null) {
                dB.echoError("Possible issue with '" + event + "' world event in script(s) " + EventManager.events.get(event) + ". Specified reason is not valid.");
                registerable = false;
            }
            if (!registerable) continue;
            should_register = true;
        }
        return should_register;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Entity Spawn SmartEvent.");
    }

    @Override
    public void breakDown() {
        CreatureSpawnEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void creatureSpawn(CreatureSpawnEvent event) {
        ArrayList<String> events = new ArrayList<String>();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        String reason = event.getSpawnReason().name();
        List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(event.getLocation());
        if (cuboids.size() > 0) {
            dList cuboid_context = new dList();
            for (dCuboid cuboid : cuboids) {
                events.add("entity spawns in " + cuboid.identify());
                events.add("entity spawns in " + cuboid.identify() + " because " + reason);
                events.add(entity.identifyType() + " spawns in " + cuboid.identify());
                events.add(entity.identifyType() + " spawns in " + cuboid.identify() + " because " + reason);
            }
            context.put("cuboids", cuboid_context);
        }
        events.add("entity spawns");
        events.add("entity spawns because " + reason);
        events.add(entity.identifyType() + " spawns");
        events.add(entity.identifyType() + " spawns because " + reason);
        context.put("entity", entity);
        context.put("reason", new Element(reason));
        String determination = EventManager.doEvents(events, entity.isNPC() ? entity.getDenizenNPC() : null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }
}

