/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners.core;

import java.util.List;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TravelListenerInstance
extends AbstractListener
implements Listener {
    private TravelType type;
    private dNPC target;
    private dLocation end_point;
    private dCuboid end_cuboid;
    private int radius = 2;
    private Integer blocks_walked = 0;
    private Integer distance_required = null;

    @Override
    public void constructed() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @Override
    public void deconstructed() {
        PlayerMoveEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public void onBuild(List<aH.Argument> args) {
        for (aH.Argument arg : args) {
            if (this.type == null && arg.matchesEnum(TravelType.values())) {
                this.type = TravelType.valueOf(arg.getValue().toUpperCase());
                continue;
            }
            if (arg.matchesPrefix("d, distance") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                this.distance_required = aH.getIntegerFrom(arg.getValue());
                continue;
            }
            if (arg.matchesPrefix("r, radius") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                this.radius = aH.getIntegerFrom(arg.getValue());
                continue;
            }
            if (arg.matchesArgumentType(dCuboid.class)) {
                this.end_cuboid = arg.asType(dCuboid.class);
                continue;
            }
            if (arg.matchesArgumentType(dLocation.class)) {
                this.end_point = arg.asType(dLocation.class);
                continue;
            }
            if (!arg.matchesArgumentType(dNPC.class)) continue;
            this.target = arg.asType(dNPC.class);
        }
        if (this.type == null) {
            dB.echoError("Missing TYPE argument! Valid: DISTANCE, TOLOCATION, TONPC, TOCUBOID");
            this.cancel();
        }
        if (this.type == TravelType.DISTANCE && this.distance_required == null) {
            dB.echoError("Missing 'distance' argument!");
            this.cancel();
        }
        if (this.type == TravelType.TOCUBOID && this.end_cuboid == null) {
            dB.echoError("Missing 'cuboid' argument!");
            this.cancel();
        }
        if (this.type == TravelType.TOLOCATION && this.end_point == null) {
            dB.echoError("Missing 'location' argument!");
            this.cancel();
        }
        if (this.type == TravelType.TONPC && this.target == null) {
            dB.echoError("Missing 'npc' argument!");
            this.cancel();
        }
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onLoad() {
        this.type = TravelType.valueOf((String)this.get("Type"));
        this.distance_required = (Integer)this.get("Distance");
        this.blocks_walked = (Integer)this.get("Blocks Walked");
        this.end_cuboid = dCuboid.valueOf((String)this.get("End Cuboid"));
        this.end_point = dLocation.valueOf((String)this.get("End Location"));
    }

    @Override
    public void onSave() {
        this.store("Type", this.type.name());
        this.store("Distance", this.distance_required);
        this.store("Radius", this.radius);
        this.store("Blocks Walked", this.blocks_walked);
        if (this.end_point != null) {
            this.store("End Location", this.end_point.identify());
        }
        if (this.end_cuboid != null) {
            this.store("End Cuboid", this.end_cuboid.identify());
        }
    }

    @Override
    public String report() {
        if (this.type == TravelType.DISTANCE) {
            return this.player.getName() + "has traveled " + this.blocks_walked + " blocks out of " + this.distance_required;
        }
        if (this.type == TravelType.TOLOCATION) {
            return this.player.getName() + " is traveling to " + this.end_point;
        }
        if (this.type == TravelType.TONPC) {
            return this.player.getName() + " is traveling to NPC " + this.target.getId();
        }
        return "Failed to create detailed report";
    }

    @EventHandler
    public void walking(PlayerMoveEvent event) {
        if (!event.getPlayer().equals(this.player.getPlayerEntity())) {
            return;
        }
        if (event.getTo().getBlock().equals(event.getFrom().getBlock())) {
            return;
        }
        if (this.type == TravelType.DISTANCE) {
            Integer n = this.blocks_walked;
            Integer n2 = this.blocks_walked = Integer.valueOf(this.blocks_walked + 1);
            this.check();
        } else if (this.type == TravelType.TOLOCATION) {
            if (!this.player.getPlayerEntity().getLocation().getWorld().equals(this.end_point.getWorld())) {
                return;
            }
            if (Utilities.checkLocation((LivingEntity)this.player.getPlayerEntity(), (Location)this.end_point, (double)this.radius)) {
                this.finish();
            }
        } else if (this.type == TravelType.TONPC && Utilities.checkLocation((LivingEntity)this.player.getPlayerEntity(), (Location)this.target.getLocation(), (double)this.radius)) {
            this.finish();
        }
    }

    private void check() {
        if (this.blocks_walked >= this.distance_required) {
            this.finish();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TravelType {
        DISTANCE,
        TOLOCATION,
        TONPC,
        TOCUBOID;

    }
}

