/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameplateTrait
extends Trait
implements Listener {
    private static final String DEFAULT_KEY = "_default_";
    @Persist(value="text")
    private String text = null;
    @Persist(value="colors", collectionType=ConcurrentHashMap.class)
    private Map<String, String> colors = new ConcurrentHashMap<String, String>(8, 0.9f, 1);

    public NameplateTrait() {
        super("nameplate");
    }

    public void onSpawn() {
        if (this.text != null) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    NameplateTrait.this.npc.getBukkitEntity().setCustomNameVisible(true);
                    NameplateTrait.this.npc.getBukkitEntity().setCustomName(NameplateTrait.this.text);
                }
            }, 2L);
        }
        if (this.getColor() != null) {
            this.refreshTag(this.getNPC());
        }
    }

    public void onDespawn() {
        if (this.npc.getBukkitEntity().getCustomName() != null) {
            this.text = this.npc.getBukkitEntity().getCustomName();
        }
    }

    public void setColor(ChatColor color) {
        this.setColor(color, DEFAULT_KEY);
    }

    public void setColor(ChatColor color, String player) {
        this.colors.put(player, color.name());
        this.refreshTag(this.getNPC());
    }

    public ChatColor getColor() {
        try {
            return ChatColor.valueOf((String)this.colors.get(DEFAULT_KEY));
        }
        catch (Exception e) {
            return ChatColor.YELLOW;
        }
    }

    public ChatColor getColor(String player) {
        if (!this.colors.containsKey(player)) {
            return this.getColor();
        }
        return ChatColor.valueOf((String)this.colors.get(player));
    }

    public boolean hasColor() {
        return this.getColor() != null;
    }

    public boolean hasColor(String player) {
        return this.getColor(player) != null;
    }

    public String getTrimmedTag() {
        return this.getTrimmedTag(DEFAULT_KEY);
    }

    public String getTrimmedTag(String player) {
        String tag = this.getNPC().getName();
        ChatColor c = this.getColor(player);
        if (c != null) {
            tag = c + tag;
        }
        if (tag.length() > 16) {
            tag = tag.substring(0, 16);
        }
        return tag;
    }

    public void refreshTag(NPC npc) {
        if (Depends.protocolManager == null || !npc.isSpawned()) {
            return;
        }
        int maxDistance = Bukkit.getServer().getViewDistance() * 16;
        ArrayList<Player> viewers = new ArrayList<Player>();
        for (Player p : this.getPlayersInRadius(npc, maxDistance)) {
            if (p.getEntityId() == npc.getBukkitEntity().getEntityId()) continue;
            viewers.add(p);
        }
        this.refreshTag(npc, viewers);
    }

    private void refreshTag(NPC npc, List<Player> players) {
        LivingEntity npcEntity = npc.getBukkitEntity();
        if (npcEntity != null) {
            Depends.protocolManager.updateEntity((Entity)npcEntity, players);
        }
    }

    private List<Player> getPlayersInRadius(NPC npc, int distance) {
        ArrayList<Player> players = new ArrayList<Player>();
        int dSquared = distance * distance;
        Location loc = npc.getBukkitEntity().getLocation();
        World world = npc.getBukkitEntity().getWorld();
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (p.getWorld() != world || !(p.getLocation().distanceSquared(loc) <= (double)dSquared)) continue;
            players.add(p);
        }
        return players;
    }
}

