/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.Item;

import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.properties.Property;
import net.aufdemrand.denizen.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.inventory.meta.BookMeta;

public class ItemBook
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem && (((dItem)item).getItemStack().getType().equals((Object)Material.WRITTEN_BOOK) || ((dItem)item).getItemStack().getType().equals((Object)Material.BOOK_AND_QUILL));
    }

    public static ItemBook getFrom(dObject _item) {
        if (!ItemBook.describes(_item)) {
            return null;
        }
        return new ItemBook((dItem)_item);
    }

    private ItemBook(dItem _item) {
        this.item = _item;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("book")) {
            BookMeta bookInfo = (BookMeta)this.item.getItemStack().getItemMeta();
            if (this.item.getItemStack().getType() == Material.WRITTEN_BOOK) {
                if (attribute.startsWith("author")) {
                    return new Element(bookInfo.getAuthor()).getAttribute(attribute.fulfill(2));
                }
                if (attribute.startsWith("title")) {
                    return new Element(bookInfo.getTitle()).getAttribute(attribute.fulfill(2));
                }
            }
            if (attribute.startsWith("page_count")) {
                return new Element(bookInfo.getPageCount()).getAttribute(attribute.fulfill(2));
            }
            if (attribute.startsWith("get_page") && aH.matchesInteger(attribute.getContext(2))) {
                return new Element(bookInfo.getPage(attribute.getIntContext(2))).getAttribute(attribute.fulfill(2));
            }
            if (attribute.startsWith("pages")) {
                return new dList(bookInfo.getPages()).getAttribute(attribute.fulfill(2));
            }
            String output = this.getPropertyString();
            if (output == null) {
                output = "null";
            }
            return new Element(output).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public static String Escape(String input) {
        return input.replace("&", "&amp;").replace("|", "&pipe;").replace(">", "&gt;").replace("<", "&lt;").replace("\n", "&nl;");
    }

    public static String unEscape(String input) {
        return input.replace("&pipe;", "|").replace("&nl;", "\n").replace("&gt;", ">").replace("&lt;", "<").replace("&amp;", "&");
    }

    public String getPropertyString() {
        StringBuilder output = new StringBuilder();
        BookMeta bookInfo = (BookMeta)this.item.getItemStack().getItemMeta();
        if (this.item.getItemStack().getType().equals((Object)Material.WRITTEN_BOOK)) {
            output.append("author|").append(ItemBook.Escape(bookInfo.getAuthor())).append("|title|").append(ItemBook.Escape(bookInfo.getTitle())).append("|");
        }
        output.append("pages|");
        for (String page : bookInfo.getPages()) {
            output.append(ItemBook.Escape(page)).append("|");
        }
        if (output.length() == 6) {
            return null;
        }
        return output.substring(0, output.length() - 1);
    }

    public String getPropertyId() {
        return "book";
    }
}

