/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class InjectCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matches("instant, instantly")) {
                scriptEntry.addObject("instant", new Element(true));
                continue;
            }
            if (arg.matches("local, locally")) {
                scriptEntry.addObject("local", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(dScript.class) && !arg.matchesPrefix("p, path")) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (!scriptEntry.hasObject("path")) {
                scriptEntry.addObject("path", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("script") && !scriptEntry.hasObject("local")) {
            throw new InvalidArgumentsException("Must define a SCRIPT to be injected.");
        }
        if (!scriptEntry.hasObject("path") && scriptEntry.hasObject("local")) {
            throw new InvalidArgumentsException("Must specify a PATH.");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dB.report(scriptEntry, this.getName(), (scriptEntry.hasObject("script") ? scriptEntry.getdObject("script").debug() : scriptEntry.getScript().debug()) + (scriptEntry.hasObject("instant") ? scriptEntry.getdObject("instant").debug() : "") + (scriptEntry.hasObject("path") ? scriptEntry.getElement("path").debug() : "") + (scriptEntry.hasObject("local") ? scriptEntry.getElement("local").debug() : ""));
        dScript script = (dScript)scriptEntry.getObject("script");
        List<ScriptEntry> entries = scriptEntry.hasObject("local") ? scriptEntry.getScript().getContainer().getEntries(scriptEntry.getPlayer(), scriptEntry.getNPC(), scriptEntry.getElement("path").asString()) : (scriptEntry.hasObject("path") ? script.getContainer().getEntries(scriptEntry.getPlayer(), scriptEntry.getNPC(), scriptEntry.getElement("path").asString()) : script.getContainer().getBaseEntries(scriptEntry.getPlayer(), scriptEntry.getNPC()));
        if (scriptEntry.hasObject("instant")) {
            for (ScriptEntry entry : entries) {
                entry.setInstant(true);
            }
        }
        ScriptBuilder.addObjectToEntries(entries, "ReqId", scriptEntry.getObject("ReqId"));
        scriptEntry.getResidingQueue().injectEntries(entries, 0);
    }
}

