/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.aufdemrand.denizen.events.bukkit.ReplaceableTagEvent;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.Debuggable;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class YamlCommand
extends AbstractCommand
implements Listener {
    Map<String, YamlConfiguration> yamls = new HashMap<String, YamlConfiguration>();

    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    private YamlConfiguration getYaml(String id) {
        if (id == null) {
            return null;
        }
        return this.yamls.get(id.toUpperCase());
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("LOAD")) {
                scriptEntry.addObject("action", new Element("LOAD"));
                scriptEntry.addObject("filename", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("SAVE, SAVEFILE, FILESAVE")) {
                scriptEntry.addObject("action", new Element("SAVE"));
                scriptEntry.addObject("filename", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("CREATE")) {
                scriptEntry.addObject("action", new Element("CREATE"));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("WRITE")) {
                scriptEntry.addObject("action", new Element("WRITE"));
                scriptEntry.addObject("key", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("value") && arg.matchesPrefix("VALUE")) {
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("ID")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("Must specify an id!");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action!");
        }
        if (!scriptEntry.hasObject("key") && scriptEntry.getElement("action").asString().equalsIgnoreCase("write")) {
            throw new InvalidArgumentsException("Must specify a key!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element filename = scriptEntry.getElement("filename");
        Element key = scriptEntry.getElement("key");
        Element value = scriptEntry.getElement("value");
        Action action = Action.valueOf(scriptEntry.getElement("action").asString().toUpperCase());
        String id = scriptEntry.getElement("id").asString();
        switch (action) {
            case LOAD: {
                File file = new File(DenizenAPI.getCurrentInstance().getDataFolder(), filename.asString());
                if (!file.exists()) {
                    dB.echoError("File cannot be found!");
                    return;
                }
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
                if (yamlConfiguration == null) break;
                this.yamls.put(id.toUpperCase(), yamlConfiguration);
                break;
            }
            case SAVE: {
                if (!this.yamls.containsKey(id.toUpperCase())) break;
                try {
                    this.yamls.get(id.toUpperCase()).save(new File(DenizenAPI.getCurrentInstance().getDataFolder(), filename.asString()));
                }
                catch (IOException e) {
                    dB.echoError(e);
                }
                break;
            }
            case WRITE: {
                if (!this.yamls.containsKey(id.toUpperCase())) break;
                this.yamls.get(id.toUpperCase()).set(key.asString(), (Object)value.asString());
                break;
            }
            case CREATE: {
                YamlConfiguration yamlConfiguration = new YamlConfiguration();
                this.yamls.put(id.toUpperCase(), yamlConfiguration);
            }
        }
    }

    @EventHandler
    public void yaml(ReplaceableTagEvent event) {
        if (!event.matches("yaml")) {
            return;
        }
        if (!event.hasNameContext() || !event.hasTypeContext()) {
            dB.echoError("YAML tag '" + event.raw_tag + "' is missing required context. Tag replacement aborted.");
            return;
        }
        String id = event.getNameContext();
        String path = event.getTypeContext();
        if (!this.yamls.containsKey(id.toUpperCase())) {
            dB.echoError("YAML tag '" + event.raw_tag + "' has specified an invalid ID, or the specified id has already" + "been closed. Tag replacement aborted.");
            return;
        }
        Attribute attribute = new Attribute(event.raw_tag, event.getScriptEntry());
        attribute.fulfill(1);
        if (attribute.startsWith("contains")) {
            event.setReplaced(new Element(this.getYaml(id).contains(path)).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("read")) {
            String value = this.getYaml(id).getString(path);
            if (value == null) {
                dB.echoDebug((Debuggable)event.getScriptEntry(), "YAML tag '" + event.raw_tag + "' has returned null.");
                event.setReplaced(new Element("null").getAttribute(attribute.fulfill(1)));
                return;
            }
            event.setReplaced(new Element(value).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_keys")) {
            ConfigurationSection section = this.getYaml(id).getConfigurationSection(path);
            if (section == null) {
                dB.echoDebug((Debuggable)event.getScriptEntry(), "YAML tag '" + event.raw_tag + "' has returned null.");
                event.setReplaced(new Element("null").getAttribute(attribute.fulfill(1)));
                return;
            }
            Set keys = section.getKeys(false);
            if (keys == null) {
                dB.echoDebug((Debuggable)event.getScriptEntry(), "YAML tag '" + event.raw_tag + "' has returned null.");
                event.setReplaced(new Element("null").getAttribute(attribute.fulfill(1)));
                return;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(keys);
            event.setReplaced(new dList((List<String>)list).getAttribute(attribute.fulfill(1)));
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        LOAD,
        CREATE,
        READ,
        WRITE,
        SAVE;

    }
}

