/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class AssignmentCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesEnum(Action.values()) && !scriptEntry.hasObject("action")) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (arg.matchesArgumentType(dScript.class) && !scriptEntry.hasObject("script")) {
                if (arg.asType(dScript.class) != null && arg.asType(dScript.class).getType().equalsIgnoreCase("assignment")) {
                    scriptEntry.addObject("script", arg.asType(dScript.class));
                    continue;
                }
                throw new InvalidArgumentsException("Script specified is not an 'assignment-type' container.");
            }
            arg.reportUnhandled();
        }
        if (scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException("NPC linked was missing or invalid.");
        }
        if (scriptEntry.getObject("action").equals((Object)Action.SET) && !scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Script specified was missing or invalid.");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dB.report(scriptEntry, this.getName(), scriptEntry.getNPC().debug() + scriptEntry.reportObject("action") + scriptEntry.reportObject("script"));
        if (scriptEntry.getObject("action").equals((Object)Action.SET)) {
            ((AssignmentTrait)scriptEntry.getNPC().getCitizen().getTrait(AssignmentTrait.class)).setAssignment(scriptEntry.getdObjectAs("script", dScript.class).getName(), scriptEntry.getPlayer());
        } else if (scriptEntry.getObject("action").equals((Object)Action.REMOVE)) {
            ((AssignmentTrait)scriptEntry.getNPC().getCitizen().getTrait(AssignmentTrait.class)).removeAssignment(scriptEntry.getPlayer());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        SET,
        REMOVE;

    }
}

