/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Location;

public class CreateCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("entity_type") && arg.matchesArgumentType(dEntity.class)) {
                dEntity ent = arg.asType(dEntity.class);
                if (!ent.isGeneric()) {
                    throw new InvalidArgumentsException("Entity supplied must be generic!");
                }
                scriptEntry.addObject("entity_type", ent);
                continue;
            }
            if (!scriptEntry.hasObject("spawn_location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("spawn_location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("name")) {
                scriptEntry.addObject("name", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("traits") && arg.matchesPrefix("t, trait, traits") && arg.matchesArgumentType(dList.class)) {
                scriptEntry.addObject("traits", arg.asType(dList.class));
                continue;
            }
            arg.reportUnhandled();
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element name = (Element)scriptEntry.getObject("name");
        dEntity type = (dEntity)scriptEntry.getObject("entity_type");
        dLocation loc = (dLocation)scriptEntry.getObject("spawn_location");
        dList traits = (dList)scriptEntry.getObject("traits");
        dB.report(scriptEntry, this.getName(), name.debug() + type.debug() + (loc != null ? loc.debug() : "") + (traits != null ? traits.debug() : ""));
        scriptEntry.addObject("created_npc", dNPC.mirrorCitizensNPC(CitizensAPI.getNPCRegistry().createNPC(type.getEntityType(), name.asString())));
        if (loc != null) {
            ((dNPC)scriptEntry.getObject("created_npc")).getCitizen().spawn((Location)loc);
        }
        if (traits != null) {
            for (String trait_name : traits) {
                Trait trait = CitizensAPI.getTraitFactory().getTrait(trait_name);
                if (trait != null) {
                    ((dNPC)scriptEntry.getObject("created_npc")).getCitizen().addTrait(trait);
                    continue;
                }
                dB.echoError("Could not add trait to NPC: " + trait_name);
            }
        }
    }
}

