/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.ArrayList;
import java.util.UUID;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.Debuggable;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class ListenCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ArrayList<aH.Argument> arguments = new ArrayList<aH.Argument>();
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", arg.asElement());
            } else if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id, i")) {
                scriptEntry.addObject("id", arg.asElement());
            } else if (!scriptEntry.hasObject("finish_script") && arg.matchesPrefix("script") && arg.matchesArgumentType(dScript.class)) {
                scriptEntry.addObject("finish_script", arg.asType(dScript.class));
            } else if (!scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", arg.asElement());
            }
            arguments.add(arg);
        }
        scriptEntry.defaultObject("action", new Element("new"));
        scriptEntry.defaultObject("id", new Element(UUID.randomUUID().toString()));
        if (!scriptEntry.hasObject("type") && scriptEntry.getElement("action").asString().equalsIgnoreCase("new")) {
            throw new InvalidArgumentsException("Must specify a listener type!");
        }
        if (scriptEntry.getPlayer() == null) {
            throw new InvalidArgumentsException("Must specify a player!");
        }
        scriptEntry.addObject("args", arguments);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element action = scriptEntry.getElement("action");
        Element type = scriptEntry.getElement("type");
        Element id = scriptEntry.getElement("id");
        dScript finish_script = (dScript)scriptEntry.getObject("finish_script");
        dB.report(scriptEntry, this.getName(), action.debug() + (type != null ? type.debug() : "") + id.debug() + (finish_script != null ? finish_script.debug() : ""));
        ArrayList arguments = (ArrayList)scriptEntry.getObject("args");
        switch (Action.valueOf(action.asString().toUpperCase())) {
            case NEW: {
                if (this.denizen.getListenerRegistry().getListenersFor(scriptEntry.getPlayer()) != null && this.denizen.getListenerRegistry().getListenersFor(scriptEntry.getPlayer()).containsKey(id.asString().toLowerCase())) {
                    dB.echoError("Cancelled creation of NEW listener! Listener ID '" + id.asString() + "' already exists!");
                    break;
                }
                try {
                    this.denizen.getListenerRegistry().get(type.asString()).createInstance(scriptEntry.getPlayer(), id.asString()).build(scriptEntry.getPlayer(), id.asString(), type.asString(), arguments, finish_script, scriptEntry.getNPC());
                }
                catch (Exception e) {
                    dB.echoDebug((Debuggable)scriptEntry, "Cancelled creation of NEW listener!");
                    if (this.denizen.getListenerRegistry().get(type.asString()) == null) {
                        dB.echoError("Invalid listener type!");
                    } else {
                        dB.echoError(e);
                    }
                    try {
                        this.denizen.getListenerRegistry().getListenerFor(scriptEntry.getPlayer(), id.asString()).cancel();
                    }
                    catch (Exception ex) {}
                }
                break;
            }
            case FINISH: {
                if (this.denizen.getListenerRegistry().getListenerFor(scriptEntry.getPlayer(), id.asString()) == null) break;
                this.denizen.getListenerRegistry().getListenerFor(scriptEntry.getPlayer(), id.asString()).finish();
                break;
            }
            case CANCEL: {
                if (scriptEntry.getPlayer() != null) {
                    if (this.denizen.getListenerRegistry().getListenerFor(scriptEntry.getPlayer(), id.asString()) == null) break;
                    this.denizen.getListenerRegistry().getListenerFor(scriptEntry.getPlayer(), id.asString()).cancel();
                    break;
                }
                this.denizen.getSaves().set("Listeners." + scriptEntry.getPlayer().getName() + "." + id, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        NEW,
        CANCEL,
        FINISH;

    }
}

