/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptContainer;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemScriptHelper
implements Listener {
    public static Map<String, ItemScriptContainer> item_scripts = new ConcurrentHashMap<String, ItemScriptContainer>(8, 0.9f, 1);

    public ItemScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public static String doEvents(String scriptName, List<String> eventNames, dNPC npc, Player player, Map<String, Object> context) {
        String determination = "none";
        ItemScriptContainer script = item_scripts.get(scriptName);
        if (script == null) {
            return determination;
        }
        for (String eventName : eventNames) {
            List<ScriptEntry> entries;
            if (!script.contains("EVENTS.ON " + eventName.toUpperCase()) || (entries = script.getEntries(player != null ? new dPlayer((OfflinePlayer)player) : null, npc, "events.on " + eventName)).isEmpty()) continue;
            dB.report(script, "Event", aH.debugObj("Type", "On " + eventName) + script.getAsScriptArg().debug() + (npc != null ? aH.debugObj("NPC", npc.toString()) : "") + (player != null ? aH.debugObj("Player", player.getName()) : "") + (context != null ? aH.debugObj("Context", context.toString()) : ""));
            dB.echoDebug(script, dB.DebugElement.Header, "Building event 'On " + eventName.toUpperCase() + "' for " + script.getName());
            if (context != null) {
                for (Map.Entry<String, Object> entry : context.entrySet()) {
                    ScriptBuilder.addObjectToEntries(entries, entry.getKey(), entry.getValue());
                }
            }
            long id = DetermineCommand.getNewId();
            ScriptBuilder.addObjectToEntries(entries, "ReqId", id);
            InstantQueue.getQueue(null).addEntries(entries).start();
            if (!DetermineCommand.hasOutcome(id)) continue;
            determination = DetermineCommand.getOutcome(id);
        }
        return determination;
    }

    public static void removeDenizenRecipes() {
        try {
            Iterator recipes = Bukkit.getServer().recipeIterator();
            while (recipes.hasNext()) {
                Recipe current = (Recipe)recipes.next();
                if (!ItemScriptHelper.isItemscript(current.getResult())) continue;
                recipes.remove();
            }
            ItemScriptContainer.specialrecipesMap.clear();
        }
        catch (Throwable e) {
            dB.echoError(e);
        }
    }

    public static boolean isBound(ItemStack item) {
        return ItemScriptHelper.isItemscript(item) && ItemScriptHelper.getItemScriptContainer((ItemStack)item).bound;
    }

    public static boolean isItemscript(ItemStack item) {
        if (item.hasItemMeta() && item.getItemMeta().hasLore()) {
            for (String itemLore : item.getItemMeta().getLore()) {
                if (!itemLore.startsWith("\u00a70id:")) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemScriptContainer getItemScriptContainer(ItemStack item) {
        if (ItemScriptHelper.isItemscript(item)) {
            for (String itemLore : item.getItemMeta().getLore()) {
                if (!itemLore.startsWith("\u00a70id:")) continue;
                return item_scripts.get(itemLore.replace("\u00a70id:", ""));
            }
        }
        return null;
    }

    @EventHandler
    public void specialRecipeClick(InventoryClickEvent event) {
        if (ItemScriptContainer.specialrecipesMap.isEmpty()) {
            return;
        }
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        InventoryType.SlotType slotType = event.getSlotType();
        if (slotType.equals((Object)InventoryType.SlotType.CRAFTING) || slotType.equals((Object)InventoryType.SlotType.RESULT)) {
            CraftingInventory inventory = (CraftingInventory)event.getInventory();
            Player player = (Player)event.getWhoClicked();
            if (slotType.equals((Object)InventoryType.SlotType.RESULT) && event.isShiftClick()) {
                this.emulateSpecialRecipeResultShiftClick(inventory, player);
            } else {
                this.processSpecialRecipes(inventory, player);
            }
        }
    }

    @EventHandler
    public void specialRecipeDrag(InventoryDragEvent event) {
        if (ItemScriptContainer.specialrecipesMap.isEmpty()) {
            return;
        }
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        for (Integer slot : event.getInventorySlots()) {
            if (slot >= 10) continue;
            CraftingInventory inventory = (CraftingInventory)event.getInventory();
            Player player = (Player)event.getWhoClicked();
            this.processSpecialRecipes(inventory, player);
            break;
        }
    }

    public void processSpecialRecipes(final CraftingInventory inventory, final Player player) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                ItemStack[] matrix = inventory.getMatrix();
                dItem result = ItemScriptHelper.this.getSpecialRecipeResult(matrix);
                if (result != null) {
                    inventory.setResult(result.getItemStack());
                    player.updateInventory();
                }
            }
        }, 1L);
    }

    public dItem getSpecialRecipeResult(ItemStack[] matrix) {
        for (Map.Entry<dItem, dList> entry : ItemScriptContainer.specialrecipesMap.entrySet()) {
            boolean matchesSpecialRecipe = true;
            for (int n = 0; n < 9; ++n) {
                if (dItem.valueOf((String)entry.getValue().get(n)).identify().equals(new dItem(matrix[n]).identify())) continue;
                matchesSpecialRecipe = false;
                break;
            }
            if (!matchesSpecialRecipe) continue;
            return entry.getKey();
        }
        return null;
    }

    public void emulateSpecialRecipeResultShiftClick(CraftingInventory inventory, Player player) {
        ItemStack[] matrix = inventory.getMatrix();
        dItem result = this.getSpecialRecipeResult(matrix);
        if (result != null) {
            int n;
            int lowestAmount = 0;
            for (n = 0; n < matrix.length - 1; ++n) {
                if ((matrix[n].getAmount() <= 0 || matrix[n].getAmount() >= lowestAmount) && lowestAmount != 0) continue;
                lowestAmount = matrix[n].getAmount();
            }
            for (n = 0; n < matrix.length - 1; ++n) {
                if (matrix[n].getAmount() <= 0) continue;
                matrix[n].setAmount(matrix[n].getAmount() - lowestAmount + 1);
            }
            if (lowestAmount > 1) {
                ItemStack resultStack = result.getItemStack().clone();
                resultStack.setAmount(lowestAmount);
                inventory.setResult(resultStack);
                player.updateInventory();
            }
        }
    }

    @EventHandler
    public void boundInventoryClickEvent(InventoryClickEvent event) {
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        ItemStack item = event.getCursor();
        if (item == null || !ItemScriptHelper.isBound(item)) {
            return;
        }
        if (event.getSlotType() == InventoryType.SlotType.CRAFTING) {
            this.removeBoundItems((CraftingInventory)event.getInventory(), (Player)event.getWhoClicked(), item);
        }
    }

    @EventHandler
    public void boundInventoryDragEvent(InventoryDragEvent event) {
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        ItemStack item = event.getOldCursor();
        if (item == null || !ItemScriptHelper.isBound(item)) {
            return;
        }
        if (event.getInventorySlots().toArray()[0] == event.getRawSlots().toArray()[0]) {
            this.removeBoundItems((CraftingInventory)event.getInventory(), (Player)event.getWhoClicked(), item);
            event.setCursor(null);
        }
    }

    public void removeBoundItems(final CraftingInventory inventory, final Player player, final ItemStack oldCursor) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                ItemStack[] matrix = inventory.getMatrix();
                boolean removedItems = false;
                for (int i = 0; i < matrix.length - 1; ++i) {
                    if (!ItemScriptHelper.isBound(matrix[i])) continue;
                    matrix[i] = null;
                    removedItems = true;
                }
                inventory.setMatrix(matrix);
                if (removedItems) {
                    player.getInventory().addItem(new ItemStack[]{oldCursor});
                }
                player.updateInventory();
            }
        }, 1L);
    }

    @EventHandler
    public void boundDropItem(PlayerDropItemEvent event) {
        if (ItemScriptHelper.isBound(event.getItemDrop().getItemStack())) {
            event.setCancelled(true);
            event.getPlayer().updateInventory();
        }
    }

    @EventHandler
    public void dropItem(PlayerDropItemEvent event) {
        ItemStack item = event.getItemDrop().getItemStack();
        if (ItemScriptHelper.isItemscript(item)) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("location", new dLocation(event.getItemDrop().getLocation()));
            String determination = ItemScriptHelper.doEvents(ItemScriptHelper.getItemScriptContainer(item).getName(), Arrays.asList("drop"), null, event.getPlayer(), context);
            if (determination.toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            }
        }
    }
}

