/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.EventManager;
import net.aufdemrand.denizen.events.bukkit.ReplaceableTagEvent;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.Debuggable;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class NPCTags
implements Listener {
    public static Map<Integer, dLocation> previousLocations = new HashMap<Integer, dLocation>();

    public NPCTags(Denizen denizen) {
        denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
    }

    @EventHandler
    public void npcTags(ReplaceableTagEvent event) {
        if (!event.matches("npc") || event.replaced()) {
            return;
        }
        Attribute attribute = new Attribute(event.raw_tag, event.getScriptEntry());
        dNPC n = event.getNPC();
        if (attribute.hasContext(1)) {
            if (dNPC.matches(attribute.getContext(1))) {
                n = dNPC.valueOf(attribute.getContext(1));
            } else {
                dB.echoDebug((Debuggable)event.getScriptEntry(), "Could not match '" + attribute.getContext(1) + "' to a valid NPC!");
                return;
            }
        }
        if (n == null || !n.isValid()) {
            dB.echoDebug((Debuggable)event.getScriptEntry(), "Invalid or missing NPC for tag <" + event.raw_tag + ">!");
            event.setReplaced("null");
            return;
        }
        event.setReplaced(n.getAttribute(attribute.fulfill(1)));
    }

    @EventHandler
    public void navComplete(NavigationCompleteEvent event) {
        EventManager.doEvents(Arrays.asList("npc completes navigation"), dNPC.mirrorCitizensNPC(event.getNPC()), null, null);
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        dNPC npc = DenizenAPI.getDenizenNPC(event.getNPC());
        npc.action("complete navigation", null);
    }

    @EventHandler
    public void navBegin(NavigationBeginEvent event) {
        EventManager.doEvents(Arrays.asList("npc begins navigation"), dNPC.mirrorCitizensNPC(event.getNPC()), null, null);
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        dNPC npc = DenizenAPI.getDenizenNPC(event.getNPC());
        npc.action("begin navigation", null);
        if (event.getNPC().getNavigator().getTargetType() == TargetType.ENTITY) {
            LivingEntity entity = event.getNPC().getNavigator().getEntityTarget().getTarget();
            if (event.getNPC().getNavigator().getEntityTarget().isAggressive() && !entity.isDead()) {
                dPlayer player = null;
                if (entity instanceof Player) {
                    player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)((Player)entity));
                }
                npc.action("attack", player);
                npc.action("attack on " + entity.getType().toString(), player);
            }
            previousLocations.put(event.getNPC().getId(), npc.getLocation());
        }
    }

    @EventHandler
    public void navCancel(NavigationCancelEvent event) {
        EventManager.doEvents(Arrays.asList("npc cancels navigation"), dNPC.mirrorCitizensNPC(event.getNPC()), null, null);
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        dNPC npc = DenizenAPI.getDenizenNPC(event.getNPC());
        npc.action("cancel navigation", null);
        npc.action("cancel navigation due to " + event.getCancelReason().toString(), null);
    }
}

