/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.midi;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.midi.NoteBlockReceiver;
import org.bukkit.Sound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiUtil {
    public static Map<String, Receiver> receivers = new HashMap<String, Receiver>();
    private static final int[] instruments = new int[]{0, 0, 0, 0, 0, 0, 0, 5, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 2, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 3, 1, 1, 1, 5, 1, 1, 1, 1, 1, 2, 4, 3};

    public static void startSequencer(File file, float tempo, Receiver receiver) throws InvalidMidiDataException, IOException, MidiUnavailableException {
        Sequencer sequencer = MidiSystem.getSequencer(false);
        sequencer.setSequence(MidiSystem.getSequence(file));
        sequencer.open();
        sequencer.setTempoFactor(tempo);
        sequencer.getTransmitter().setReceiver(receiver);
        sequencer.start();
    }

    public static void playMidi(File file, float tempo, List<dEntity> entities) {
        try {
            NoteBlockReceiver receiver = new NoteBlockReceiver(entities);
            for (dEntity entity : entities) {
                MidiUtil.stopMidi(entity.getUUID().toString());
                receivers.put(entity.getUUID().toString(), receiver);
            }
            MidiUtil.startSequencer(file, tempo, receiver);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    public static void playMidi(File file, float tempo, dLocation location) {
        try {
            NoteBlockReceiver receiver = new NoteBlockReceiver(location);
            MidiUtil.stopMidi(location.identify());
            receivers.put(location.identify(), receiver);
            MidiUtil.startSequencer(file, tempo, receiver);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    public static void stopMidi(String object) {
        if (receivers.containsKey(object)) {
            receivers.get(object).close();
            receivers.remove(object);
        }
    }

    public static void stopMidi(List<dEntity> entities) {
        for (dEntity entity : entities) {
            MidiUtil.stopMidi(entity.getUUID().toString());
        }
    }

    public static Sound patchToInstrument(int patch) {
        switch (instruments[patch]) {
            case 1: {
                return Sound.NOTE_BASS_GUITAR;
            }
            case 2: {
                return Sound.NOTE_SNARE_DRUM;
            }
            case 3: {
                return Sound.NOTE_STICKS;
            }
            case 4: {
                return Sound.NOTE_BASS_DRUM;
            }
            case 5: {
                return Sound.NOTE_PLING;
            }
            case 6: {
                return Sound.NOTE_BASS;
            }
        }
        return Sound.NOTE_PIANO;
    }
}

