/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dColor;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class FireworkCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("random")) {
                scriptEntry.addObject("type", new Element(FireworkEffect.Type.values()[Utilities.getRandom().nextInt(FireworkEffect.Type.values().length)].name()));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matchesEnum((Enum[])FireworkEffect.Type.values())) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("power") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("power", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("flicker") && arg.matches("flicker")) {
                scriptEntry.addObject("flicker", "");
                continue;
            }
            if (!scriptEntry.hasObject("trail") && arg.matches("trail")) {
                scriptEntry.addObject("trail", "");
                continue;
            }
            if (!scriptEntry.hasObject("primary") && arg.matchesPrefix("primary") && arg.matchesArgumentList(dColor.class)) {
                scriptEntry.addObject("primary", arg.asType(dList.class).filter(dColor.class));
                continue;
            }
            if (!scriptEntry.hasObject("fade") && arg.matchesPrefix("fade") && arg.matchesArgumentList(dColor.class)) {
                scriptEntry.addObject("fade", arg.asType(dList.class).filter(dColor.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("location", scriptEntry.hasNPC() ? scriptEntry.getNPC().getLocation() : null, scriptEntry.hasPlayer() ? scriptEntry.getPlayer().getLocation() : null);
        scriptEntry.defaultObject("type", new Element("ball"));
        scriptEntry.defaultObject("power", new Element(1));
        scriptEntry.defaultObject("primary", Arrays.asList(dColor.valueOf("yellow")));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation location = scriptEntry.hasObject("location") ? (dLocation)scriptEntry.getObject("location") : scriptEntry.getNPC().getLocation();
        Element type = (Element)scriptEntry.getObject("type");
        Element power = (Element)scriptEntry.getObject("power");
        boolean flicker = scriptEntry.hasObject("flicker");
        boolean trail = scriptEntry.hasObject("trail");
        List primary = (List)scriptEntry.getObject("primary");
        List fade = (List)scriptEntry.getObject("fade");
        dB.report(scriptEntry, this.getName(), location.debug() + type.debug() + power.debug() + (flicker ? aH.debugObj("flicker", flicker) : "") + (trail ? aH.debugObj("trail", trail) : "") + aH.debugObj("primary colors", primary.toString()) + (fade != null ? aH.debugObj("fade colors", fade.toString()) : ""));
        Firework firework = (Firework)location.getWorld().spawn((Location)location, Firework.class);
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        fireworkMeta.setPower(power.asInt());
        FireworkEffect.Builder fireworkBuilder = FireworkEffect.builder();
        fireworkBuilder.with(FireworkEffect.Type.valueOf((String)type.asString().toUpperCase()));
        fireworkBuilder.withColor(Conversion.convertColors(primary));
        if (fade != null) {
            fireworkBuilder.withFade(Conversion.convertColors(fade));
        }
        if (flicker) {
            fireworkBuilder.withFlicker();
        }
        if (trail) {
            fireworkBuilder.withTrail();
        }
        fireworkMeta.addEffects(new FireworkEffect[]{fireworkBuilder.build()});
        firework.setFireworkMeta(fireworkMeta);
    }
}

