/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.core.CooldownCommand;
import net.aufdemrand.denizen.scripts.requirements.RequirementsContext;
import net.aufdemrand.denizen.scripts.requirements.RequirementsMode;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.Debuggable;
import org.bukkit.configuration.ConfigurationSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptContainer
implements Debuggable {
    ConfigurationSection contents;
    private String name;

    public ScriptContainer(ConfigurationSection configurationSection, String scriptContainerName) {
        this.contents = configurationSection;
        this.name = scriptContainerName.toUpperCase();
    }

    public ConfigurationSection getContents() {
        return this.contents;
    }

    public <T extends ScriptContainer> T getAsContainerType(Class<T> type) {
        return (T)((ScriptContainer)type.cast(this));
    }

    public String getName() {
        return this.name;
    }

    public dScript getAsScriptArg() {
        return dScript.valueOf(this.name);
    }

    public String getContainerType() {
        return this.contents.contains("TYPE") ? this.contents.getString("TYPE").toUpperCase() : null;
    }

    public boolean contains(String path) {
        return this.contents.contains(path.toUpperCase());
    }

    public String getString(String path) {
        return this.contents.getString(path.toUpperCase());
    }

    public String getString(String path, String def) {
        return this.contents.getString(path.toUpperCase(), def);
    }

    public List<String> getStringList(String path) {
        return this.contents.getStringList(path.toUpperCase());
    }

    public ConfigurationSection getConfigurationSection(String path) {
        return this.contents.getConfigurationSection(path.toUpperCase());
    }

    public void set(String path, Object object) {
        this.contents.set(path.toUpperCase(), object);
    }

    public boolean checkBaseRequirements(dPlayer player, dNPC npc) {
        return this.checkRequirements(player, npc, "");
    }

    public boolean checkRequirements(dPlayer player, dNPC npc, String path) {
        if (path == null) {
            path = "";
        }
        if (path.length() > 0) {
            path = path + ".";
        }
        List requirements = this.contents.getStringList(path + "REQUIREMENTS.LIST");
        String mode = this.contents.getString(path + "REQUIREMENTS.MODE", "ALL");
        if (requirements == null || requirements.isEmpty()) {
            return true;
        }
        RequirementsContext context = new RequirementsContext(new RequirementsMode(mode), requirements, this);
        context.attachPlayer(player);
        context.attachNPC(npc);
        return DenizenAPI.getCurrentInstance().getScriptEngine().getRequirementChecker().check(context);
    }

    public List<ScriptEntry> getBaseEntries(dPlayer player, dNPC npc) {
        return this.getEntries(player, npc, null);
    }

    public List<ScriptEntry> getEntries(dPlayer player, dNPC npc, String path) {
        List stringEntries;
        List<ScriptEntry> list = new ArrayList<ScriptEntry>();
        if (path == null) {
            path = "script";
        }
        if ((stringEntries = this.contents.getStringList(path.toUpperCase())) == null || stringEntries.size() == 0) {
            return list;
        }
        list = ScriptBuilder.buildScriptEntries(stringEntries, this, player, npc);
        return list;
    }

    public boolean checkCooldown(dPlayer player) {
        return CooldownCommand.checkCooldown(player != null ? player.getName() : null, this.name);
    }

    @Override
    public boolean shouldDebug() throws Exception {
        return !this.contents.contains("DEBUG") || !this.contents.getString("DEBUG").equalsIgnoreCase("false");
    }

    @Override
    public boolean shouldFilter(String criteria) throws Exception {
        return this.name.equalsIgnoreCase(criteria.replace("s@", ""));
    }

    public String toString() {
        return "s@" + this.getName().toLowerCase();
    }
}

