/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.interfaces.dExternal;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;
import org.shade.abstractmeta.toolbox.compilation.compiler.JavaSourceCompiler;
import org.shade.abstractmeta.toolbox.compilation.compiler.impl.JavaSourceCompilerImpl;

public class RuntimeCompiler {
    Denizen denizen;
    private static final File pluginsFolder = new File("plugins");
    private static final FilenameFilter jarFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".jar");
        }
    };
    private static final FilenameFilter javaFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".java");
        }
    };

    public RuntimeCompiler(Denizen denizen) {
        this.denizen = denizen;
    }

    public void loader() {
        File file;
        ArrayList<String> dependencies = new ArrayList<String>();
        dB.log("Loading external dependencies for run-time compiler.");
        try {
            file = new File(this.denizen.getDataFolder() + File.separator + "externals" + File.separator + "dependencies");
            for (File f : file.listFiles(jarFilter)) {
                dependencies.add(f.getPath());
                dB.log("Loaded  " + f.getName());
            }
        }
        catch (Exception error) {
            dB.log("No dependencies to load.");
        }
        try {
            file = new File(this.denizen.getDataFolder() + File.separator + "externals");
            File[] files = file.listFiles(javaFilter);
            if (files != null && files.length > 0) {
                for (File f : files) {
                    String fileName = f.getName();
                    dB.log("Processing '" + fileName + "'... ");
                    JavaSourceCompilerImpl javaSourceCompiler = new JavaSourceCompilerImpl();
                    JavaSourceCompiler.CompilationUnit compilationUnit = javaSourceCompiler.createCompilationUnit();
                    if (!dependencies.isEmpty()) {
                        compilationUnit.addClassPathEntries(dependencies);
                    }
                    compilationUnit.addClassPathEntries(Arrays.asList(this.denizen.getDataFolder().list(jarFilter)));
                    compilationUnit.addClassPathEntries(Arrays.asList(pluginsFolder.list(jarFilter)));
                    try {
                        compilationUnit.addJavaSource(fileName.replace(".java", ""), this.readFile(f.getAbsolutePath()));
                        ClassLoader classLoader = javaSourceCompiler.compile(compilationUnit, new String[0]);
                        Class<?> load = classLoader.loadClass(fileName.replace(".java", ""));
                        dExternal loadedClass = (dExternal)load.newInstance();
                        loadedClass.load();
                    }
                    catch (Exception e) {
                        if (e instanceof IllegalStateException) {
                            dB.echoError("No JDK found! External .java files will not be loaded.");
                            dB.echoError(e);
                            continue;
                        }
                        dB.echoError(ChatColor.RED + "Error compiling " + fileName + "!");
                        dB.echoError(e);
                    }
                }
                dB.echoApproval("All externals loaded!");
            }
        }
        catch (Exception error) {
            dB.echoError(error);
        }
    }

    private String readFile(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return stringBuilder.toString();
    }
}

