/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.command.Command;
import net.aufdemrand.denizen.utilities.command.CommandContext;
import net.aufdemrand.denizen.utilities.command.Paginator;
import net.aufdemrand.denizen.utilities.command.exceptions.CommandException;
import net.aufdemrand.denizen.utilities.command.messaging.Messaging;
import net.aufdemrand.denizen.utilities.debugging.DebugSubmit;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.events.core.ReloadScriptsScriptEvent;
import net.aufdemrand.denizencore.scripts.ScriptHelper;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DenizenCommandHandler {
    private final Denizen denizen;

    public DenizenCommandHandler(Denizen denizen) {
        this.denizen = denizen;
    }

    @Command(aliases={"denizen"}, usage="submit", desc="Submits recorded logs triggered by /denizen debug -r", modifiers={"submit"}, min=1, max=3, permission="denizen.submit")
    public void submit(CommandContext args, final CommandSender sender) throws CommandException {
        if (!net.aufdemrand.denizen.utilities.debugging.dB.record) {
            Messaging.sendError(sender, "Use /denizen debug -r  to record debug information to be submitted");
            return;
        }
        net.aufdemrand.denizen.utilities.debugging.dB.record = false;
        Messaging.send(sender, "Submitting...");
        final DebugSubmit submit = new DebugSubmit();
        submit.recording = net.aufdemrand.denizen.utilities.debugging.dB.Recording.toString();
        net.aufdemrand.denizen.utilities.debugging.dB.Recording = new StringBuilder();
        submit.start();
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                if (!submit.isAlive()) {
                    if (submit.Result == null) {
                        Messaging.sendError(sender, "Error while submitting.");
                    } else {
                        Messaging.send(sender, "Successfully submitted to http://mcmonkey.org" + submit.Result);
                    }
                    this.cancel();
                }
            }
        };
        task.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), 0L, 10L);
    }

    @Command(aliases={"denizen"}, usage="debug", desc="Toggles debug mode for Denizen.", modifiers={"debug", "de", "db", "dbug"}, min=1, max=5, permission="denizen.debug", flags="scebrxov")
    public void debug(CommandContext args, CommandSender sender) throws CommandException {
        if (args.hasFlag('s')) {
            if (!net.aufdemrand.denizen.utilities.debugging.dB.showDebug) {
                net.aufdemrand.denizen.utilities.debugging.dB.toggle();
            }
            net.aufdemrand.denizen.utilities.debugging.dB.showStackTraces = !net.aufdemrand.denizen.utilities.debugging.dB.showStackTraces;
            Messaging.sendInfo(sender, net.aufdemrand.denizen.utilities.debugging.dB.showStackTraces ? "Denizen dBugger is now showing caught exception stack traces." : "Denizen dBugger is now hiding caught stacktraces.");
        }
        if (args.hasFlag('c')) {
            if (!net.aufdemrand.denizen.utilities.debugging.dB.showDebug) {
                net.aufdemrand.denizen.utilities.debugging.dB.toggle();
            }
            net.aufdemrand.denizen.utilities.debugging.dB.showColor = !net.aufdemrand.denizen.utilities.debugging.dB.showColor;
            Messaging.sendInfo(sender, net.aufdemrand.denizen.utilities.debugging.dB.showColor ? "Denizen dBugger is now showing color." : "Denizen dBugger color has been disabled.");
        }
        if (args.hasFlag('o')) {
            if (!net.aufdemrand.denizen.utilities.debugging.dB.showDebug) {
                net.aufdemrand.denizen.utilities.debugging.dB.toggle();
            }
            net.aufdemrand.denizen.utilities.debugging.dB.debugOverride = !net.aufdemrand.denizen.utilities.debugging.dB.debugOverride;
            Messaging.sendInfo(sender, net.aufdemrand.denizen.utilities.debugging.dB.debugOverride ? "Denizen dBugger is now overriding 'debug: false'." : "Denizen dBugger override has been disabled.");
        }
        if (args.hasFlag('e')) {
            if (!net.aufdemrand.denizen.utilities.debugging.dB.showDebug) {
                net.aufdemrand.denizen.utilities.debugging.dB.toggle();
            }
            dB.showEventsTrimming = !dB.showEventsTrimming;
            Messaging.sendInfo(sender, dB.showEventsTrimming ? "Denizen dBugger is now logging all world events." : "Denizen dBugger is now hiding world events.");
        }
        if (args.hasFlag('b')) {
            if (!net.aufdemrand.denizen.utilities.debugging.dB.showDebug) {
                net.aufdemrand.denizen.utilities.debugging.dB.toggle();
            }
            dB.showScriptBuilder = !dB.showScriptBuilder;
            Messaging.sendInfo(sender, dB.showScriptBuilder ? "Denizen dBugger is now logging the ScriptBuilder." : "Denizen dBugger is now hiding ScriptBuilder logging.");
        }
        if (args.hasFlag('r')) {
            if (!net.aufdemrand.denizen.utilities.debugging.dB.showDebug) {
                net.aufdemrand.denizen.utilities.debugging.dB.toggle();
            }
            net.aufdemrand.denizen.utilities.debugging.dB.record = !net.aufdemrand.denizen.utilities.debugging.dB.record;
            net.aufdemrand.denizen.utilities.debugging.dB.Recording = new StringBuilder();
            Messaging.sendInfo(sender, net.aufdemrand.denizen.utilities.debugging.dB.record ? "Denizen dBugger is now recording. Use /denizen submit to finish." : "Denizen dBugger recording disabled.");
        }
        if (args.hasFlag('v')) {
            if (!net.aufdemrand.denizen.utilities.debugging.dB.showDebug) {
                net.aufdemrand.denizen.utilities.debugging.dB.toggle();
            }
            dB.verbose = !dB.verbose;
            Messaging.sendInfo(sender, dB.verbose ? "Denizen dBugger is now verbose." : "Denizen dBugger verbosity disabled.");
        }
        if (args.hasFlag('x')) {
            net.aufdemrand.denizen.utilities.debugging.dB.filter = new ArrayList<String>();
            Messaging.sendInfo(sender, "Denizen dBugger filter removed.");
        }
        if (args.hasFlag('n')) {
            if (!net.aufdemrand.denizen.utilities.debugging.dB.showDebug) {
                net.aufdemrand.denizen.utilities.debugging.dB.toggle();
            }
            net.aufdemrand.denizen.utilities.debugging.dB.shouldTrim = !net.aufdemrand.denizen.utilities.debugging.dB.shouldTrim;
            Messaging.sendInfo(sender, net.aufdemrand.denizen.utilities.debugging.dB.shouldTrim ? "Denizen dBugger is now trimming long messages." : "Denizen dBugger is no longer trimming long messages.");
        }
        if (args.hasValueFlag("filter")) {
            if (!net.aufdemrand.denizen.utilities.debugging.dB.showDebug) {
                net.aufdemrand.denizen.utilities.debugging.dB.toggle();
            }
            for (String filter : args.getFlag("filter").split("\\|")) {
                net.aufdemrand.denizen.utilities.debugging.dB.filter.add(filter);
            }
            Messaging.sendInfo(sender, "Denizen dBugger filter now: " + net.aufdemrand.denizen.utilities.debugging.dB.filter.toString());
        } else if (args.getFlags().isEmpty()) {
            net.aufdemrand.denizen.utilities.debugging.dB.toggle();
            Messaging.sendInfo(sender, "Denizen dBugger is now: " + (net.aufdemrand.denizen.utilities.debugging.dB.showDebug ? "<a>ENABLED" : "<c>DISABLED"));
        }
    }

    @Command(aliases={"denizen"}, usage="do_nothing", desc="Does nothing, for better server command handling", modifiers={"do_nothing"}, min=1, max=3, permission="denizen.basic")
    public void do_nothing(CommandContext args, CommandSender sender) throws CommandException {
    }

    @Command(aliases={"denizen"}, usage="version", desc="Shows the currently loaded version of Denizen.", modifiers={"version"}, min=1, max=3, permission="denizen.basic")
    public void version(CommandContext args, CommandSender sender) throws CommandException {
        Messaging.sendInfo(sender, " _/_ _  ._  _ _  ");
        Messaging.sendInfo(sender, "(/(-/ )/ /_(-/ ) <7> scriptable NPCs");
        Messaging.send(sender, "");
        Messaging.send(sender, "<7>by: <f>aufdemrand and mcmonkey");
        Messaging.send(sender, "<7>version: <f>" + Denizen.versionTag);
    }

    @Command(aliases={"denizen"}, usage="save", desc="Saves the current state of Denizen/saves.yml.", modifiers={"save"}, min=1, max=3, permission="denizen.basic", flags="s")
    public void save(CommandContext args, CommandSender sender) throws CommandException {
        DenizenAPI.getCurrentInstance().saveSaves();
        DenizenAPI.getCurrentInstance().notableManager().saveNotables();
        Messaging.send(sender, "Denizen/saves.yml saved to disk from memory.");
    }

    @Command(aliases={"denizen"}, usage="listener (--player) --id listener_id --report|cancel|finish", desc="Checks/cancels/finishes listeners in progress.", modifiers={"listener"}, min=1, max=3, permission="denizen.basic", flags="s")
    public void listener(CommandContext args, CommandSender sender) throws CommandException {
        dPlayer player = null;
        if (sender instanceof Player) {
            player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)((Player)sender));
        }
        if (args.hasValueFlag("player")) {
            player = dPlayer.valueOf(args.getFlag("player"));
        }
        if (player == null) {
            throw new CommandException("Specified player not online or not found!");
        }
        Map<String, AbstractListener> listeners = this.denizen.getListenerRegistry().getListenersFor(player);
        if (listeners == null || listeners.isEmpty()) {
            Messaging.send(sender, player.getName() + " has no active listeners.");
            return;
        }
        if (args.hasValueFlag("report")) {
            for (AbstractListener quest : this.denizen.getListenerRegistry().getListenersFor(player).values()) {
                if (!quest.getListenerId().equalsIgnoreCase(args.getFlag("report"))) continue;
                Messaging.send(sender, quest.report());
            }
            return;
        }
        if (args.hasValueFlag("cancel")) {
            for (AbstractListener quest : this.denizen.getListenerRegistry().getListenersFor(player).values()) {
                if (!quest.getListenerId().equalsIgnoreCase(args.getFlag("cancel"))) continue;
                Messaging.send(sender, "Cancelling '" + quest.getListenerId() + "' for " + player.getName() + ".");
                quest.cancel();
            }
            return;
        }
        if (args.hasValueFlag("finish")) {
            for (AbstractListener quest : this.denizen.getListenerRegistry().getListenersFor(player).values()) {
                if (!quest.getListenerId().equalsIgnoreCase(args.getFlag("finish"))) continue;
                Messaging.send(sender, "Force-finishing '" + quest.getListenerId() + "' for " + player.getName() + ".");
                quest.finish();
            }
            return;
        }
        if (args.length() > 2 && args.getInteger(1, 0) < 1) {
            Messaging.send(sender, "");
            Messaging.send(sender, "<f>Use '--report|cancel|finish id' to modify/view a specific quest listener.");
            Messaging.send(sender, "<b>Example: /denizen listener --report \"Journey 1\"");
            Messaging.send(sender, "");
            return;
        }
        Paginator paginator = new Paginator();
        paginator.header("Active quest listeners for " + player.getName() + ":");
        paginator.addLine("<e>Key: <a>Type  <b>ID");
        if (listeners == null || listeners.isEmpty()) {
            paginator.addLine("None.");
        } else {
            for (AbstractListener quest : listeners.values()) {
                paginator.addLine("<a>" + quest.getListenerType() + "  <b>" + quest.getListenerId());
            }
        }
        paginator.sendPage(sender, args.getInteger(1, 1));
    }

    @Command(aliases={"denizen"}, usage="reload (saves|notables|config|scripts|externals) (-a)", desc="Reloads various Denizen files from disk to memory.", modifiers={"reload"}, min=1, max=3, permission="denizen.basic", flags="a")
    public void reload(CommandContext args, CommandSender sender) throws CommandException {
        if (args.hasFlag('a')) {
            this.denizen.reloadConfig();
            this.denizen.runtimeCompiler.reload();
            DenizenCore.reloadScripts();
            this.denizen.notableManager().reloadNotables();
            this.denizen.reloadSaves();
            Messaging.send(sender, "Denizen/saves.yml, Denizen/notables.yml, Denizen/config.yml, Denizen/scripts/..., and Denizen/externals/... reloaded from disk to memory.");
            if (ScriptHelper.hadError()) {
                Messaging.sendError(sender, "There was an error loading your scripts, check the console for details!");
            }
            ReloadScriptsScriptEvent.instance.reset();
            ReloadScriptsScriptEvent.instance.all = true;
            ReloadScriptsScriptEvent.instance.hadError = ScriptHelper.hadError();
            ReloadScriptsScriptEvent.instance.sender = sender.getName();
            ReloadScriptsScriptEvent.instance.data = new BukkitScriptEntryData(sender instanceof Player ? new dPlayer((Player)sender) : null, null);
            ReloadScriptsScriptEvent.instance.fire();
            return;
        }
        if (args.length() > 2) {
            if (args.getString(1).equalsIgnoreCase("saves")) {
                this.denizen.reloadSaves();
                Messaging.send(sender, "Denizen/saves.yml reloaded from disk to memory.");
                return;
            }
            if (args.getString(1).equalsIgnoreCase("notables")) {
                this.denizen.notableManager().reloadNotables();
                Messaging.send(sender, "Denizen/notables.yml reloaded from disk to memory.");
                return;
            }
            if (args.getString(1).equalsIgnoreCase("config")) {
                this.denizen.reloadConfig();
                Messaging.send(sender, "Denizen/config.yml reloaded from disk to memory.");
                return;
            }
            if (args.getString(1).equalsIgnoreCase("scripts")) {
                DenizenCore.reloadScripts();
                Messaging.send(sender, "Denizen/scripts/... reloaded from disk to memory.");
                if (ScriptHelper.hadError()) {
                    Messaging.sendError(sender, "There was an error loading your scripts, check the console for details!");
                }
                ReloadScriptsScriptEvent.instance.reset();
                ReloadScriptsScriptEvent.instance.all = false;
                ReloadScriptsScriptEvent.instance.hadError = ScriptHelper.hadError();
                ReloadScriptsScriptEvent.instance.sender = sender.getName();
                ReloadScriptsScriptEvent.instance.data = new BukkitScriptEntryData(sender instanceof Player ? new dPlayer((Player)sender) : null, null);
                ReloadScriptsScriptEvent.instance.fire();
                return;
            }
            if (args.getString(1).equalsIgnoreCase("externals")) {
                this.denizen.runtimeCompiler.reload();
                Messaging.send(sender, "Denizen/externals/... reloaded from disk to memory.");
                return;
            }
        }
        Messaging.send(sender, "");
        Messaging.send(sender, "<f>Specify which parts to reload. Valid options are: SAVES, NOTABLES, CONFIG, SCRIPTS, EXTERNALS");
        Messaging.send(sender, "<b>Example: /denizen reload scripts");
        Messaging.send(sender, "<f>Use '-a' to reload all parts.");
        Messaging.send(sender, "");
    }

    @Command(aliases={"denizen"}, usage="scripts (--type assignment|task|...) (--filter string)", desc="Lists currently loaded dScripts.", modifiers={"scripts"}, min=1, max=4, permission="denizen.basic")
    public void scripts(CommandContext args, CommandSender sender) throws CommandException {
        String type = null;
        if (args.hasValueFlag("type")) {
            type = args.getFlag("type");
        }
        String filter = null;
        if (args.hasValueFlag("filter")) {
            filter = args.getFlag("filter");
        }
        Set<String> scripts = ScriptRegistry._getScriptNames();
        Paginator paginator = new Paginator().header("Scripts");
        paginator.addLine("<e>Key: <a>Type  <b>Name");
        for (String script : scripts) {
            Object scriptContainer = ScriptRegistry.getScriptContainer(script);
            if (type != null) {
                if (!((ScriptContainer)scriptContainer).getContainerType().equalsIgnoreCase(type)) continue;
                if (filter != null) {
                    if (!script.contains(filter.toUpperCase())) continue;
                    paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
                    continue;
                }
                paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
                continue;
            }
            if (filter != null) {
                if (!script.contains(filter.toUpperCase())) continue;
                paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
                continue;
            }
            paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
        }
        if (!paginator.sendPage(sender, args.getInteger(1, 1))) {
            throw new CommandException("The page " + args.getInteger(1, 1) + " does not exist.");
        }
    }

    @Command(aliases={"notable"}, usage="add", desc="Adds a new notable to your current location", modifiers={"add", "save"}, min=2, max=20, permission="denizen.notable.basic")
    public void addnotable(CommandContext args, CommandSender sender) throws CommandException {
        NotableManager.saveAs(new dLocation(((Player)sender).getLocation()), args.getString(1));
        Messaging.send(sender, "Created new notable called " + args.getString(1));
    }

    @Command(aliases={"notable"}, usage="list", desc="Lists all notable locations", modifiers={"list"}, min=1, max=1, permission="denizen.notable.basic")
    public void listnotable(CommandContext args, CommandSender sender) throws CommandException {
        Messaging.send(sender, NotableManager.getAllType(dLocation.class).toString());
    }
}

