/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.FormatScriptContainer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncChatSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        if (!Settings.worldScriptChatEventAsynchronous()) {
            return false;
        }
        for (String event : events) {
            Matcher m = Pattern.compile("on player chats", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Async Chat SmartEvent.");
    }

    @Override
    public void breakDown() {
        AsyncPlayerChatEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void asyncPlayerChat(AsyncPlayerChatEvent event) {
        final HashMap<String, Element> context = new HashMap<String, Element>();
        context.put("message", new Element(event.getMessage()));
        context.put("format", new Element(event.getMessage()));
        final dPlayer player = new dPlayer(event.getPlayer());
        Callable<List<String>> call = new Callable<List<String>>(){

            @Override
            public List<String> call() {
                return OldEventManager.doEvents(Arrays.asList("player chats"), new BukkitScriptEntryData(player, null), context);
            }
        };
        List determinations = null;
        try {
            determinations = event.isAsynchronous() ? (List)Bukkit.getScheduler().callSyncMethod((Plugin)DenizenAPI.getCurrentInstance(), (Callable)call).get() : (List)call.call();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            dB.echoError(e);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        for (String determination : determinations) {
            if (determination == null) continue;
            if (determination.toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
                continue;
            }
            if (determination.toUpperCase().startsWith("FORMAT:")) {
                String name = determination.substring(7);
                FormatScriptContainer format = (FormatScriptContainer)ScriptRegistry.getScriptContainer(name);
                if (format == null) {
                    dB.echoError("Could not find format script matching '" + name + '\'');
                    continue;
                }
                event.setFormat(format.getFormattedText(event.getMessage(), null, player));
                continue;
            }
            if (determination.equals("none")) continue;
            event.setMessage(determination);
        }
    }
}

